<?php
/**
 * workman定时器任务事件
 */
namespace App\Console\Commands;

use App\Listens\WorkermanTimers;
use Illuminate\Console\Command;
use Workerman\Worker;

class WorkermanTimerCommand extends Command
{
    /**
     * 控制台命令的名称和参数.
     * @var string
     */
    protected $signature = 'workerman {action} {--d}';

    /**
     * 控制台命令描述.
     * @var string
     */
    protected $description = 'workerman的多进程定时任务';

    /**
     * Create a new command instance.
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        global $argv;
        $action = $this->argument('action');
        $argv[0] = 'wk';
        $argv[1] = $action;
        $argv[2] = $this->option('d') ? '-d' : '';
        $this->startServer();
    }

    /**
     * 启动workerman服务
     */
    public function startServer()
    {
        $worker = new Worker();
        // 服务名称.
        $worker->name = 'laravel timer';
        // 启动多少个进程数量，这里大家灵活配置，可以参考workerman的文档.
        $worker->count = 4;
        // 当workerman的进程启动时的回调方法.
        $worker->onWorkerStart = [WorkermanTimers::class, 'onWorkerStart'];
        // 当workerman的进程关闭时的回调方法.
        $worker->onClose = [WorkermanTimers::class, 'onClose'];
        Worker::runAll();
    }
}
