<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\UserCoupon;

class Coupon extends Model
{
    protected $table = 'coupon';

    protected $casts = [
        'store' => 'json',
        'cate_ids' => 'json',
        'store_write_off' => 'json',
    ];

    protected $guarded = [];

    public function userCoupon()
    {
        return $this->hasMany(UserCoupon::class, 'cpid', 'id');
    }

    public function getUsageTypeAttribute($usage_type)
    {
        return $this->transUseageCase($usage_type);
    }

    
    /**
     * gc_kevin 存資料 usage_type
     * @param array $usage_type 有 online offline
     * @return string
     */
    public function saveUsageCase($usage_type)
    {
        if(!$usage_type) return null;
        return count($usage_type) > 1 && $usage_type[0] !== null ? 'all' : $usage_type[0];
    }

    /**
     * gc_kevin 取資料 usage_type
     * @param string $usage_type
     * @return array 
     */
    public function getUsageCase($usage_type)
    {
        if(!$usage_type) return [];
        return $usage_type === 'all' ? ['online','offline'] : [$usage_type];
    }

    /**
     * gc_kevin 存取資料判斷 usage_type
     * @param mixed string | array
     * @return mixed string | array
     */
    public function transUseageCase($usage_type)
    {
        return is_array($usage_type) ? $this->saveUsageCase($usage_type) : $this->getUsageCase($usage_type);
    }
}
