<?php

use Curl\Curl;
use Illuminate\Contracts\Encryption\DecryptException;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Support\Facades\DB;
use App\Repositories\Common\Utils;
use Carbon\Carbon;

/**
 * 写入用户登录日志
 */
function user_loginlog($uid,$uname,$type){
    $data['uid'] = $uid;
    $data['uname'] = $uname;
    $data['type'] = $type;
    $data['ip'] = get_onlineip();
    $data['add_time'] = date('Y-m-d H:i:s');
    Db::table('user_loginlog')->insert($data);
}
 
/**
 * 写入用户发送消息表
 */
function user_message($uid,$msg,$type){
    $data['uid'] = $uid;
    $data['msg'] = $msg;
    $data['type'] = $type;
    $data['add_time'] = date('Y-m-d H:i:s');
    Db::table('user_message')->insert($data);
}

/**
 * 写入用户每日时长表-学习任务表
 */
function user_daymsg($uid,$date,$minute,$type){
    //每日学习表
    $data['uid'] = $uid;
    $data['date'] = $date;
    $data['sign'] = 0;
    $is = Db::table('day_msg')->where($data)->first();
    if(empty($is)){
        $data['study_minute'] = $minute;
        if($type == 0){//刷题时间
            $data['ques_time'] = $minute;
        }else{//视频时间
            $data['video_time'] = $minute;
        }
        Db::table('day_msg')->insert($data);
    }else{
        $data['study_minute'] = $is->study_minute+$minute;
        if($type == 0){//刷题时间
            $data['ques_time'] = $is->ques_time+$minute;
        }else{
            $data['video_time'] = $is->video_time+$minute;
        }
        Db::table('day_msg')->where('id',$is->id)->update($data);
    }
    //学习任务表
    // $w['uid'] = UID;
    // $w['from'] = 1;
    // $w[] = ['add_time','like','%'.$date.'%']; 
    // $sum = Db::table('user_coins')->where($w)->sum('coins');
    // if($sum < 100){
    //     $last = 100-$sum;
    //     if($minute > $last){
    //         $coins['coins'] = $last;
    //     }else{
    //         $coins['coins'] = $minute;
    //     }
    //     $coins['uid'] = UID;
    //     $coins['add_time'] = date('Y-m-d H:i:s');
    //     $coins['type'] = 0;
    //     $coins['from'] = 1;
    //     $coins['remark'] = '学习任务获得金币'.$coins['coins'].'枚';
    //     Db::table('user_coins')->insert($coins);
    //     Db::table('user')->where('id',UID)->increment('all_coins',$coins['coins']);
    //     Db::table('user')->where('id',UID)->increment('study_coins',$coins['coins']);
    // }
}

/**

 *  调用淘宝API根据IP查询地址

 */

function ip_address($ip){

    $ip = '175.8.51.248';

    $url = file_get_contents('https://ip.taobao.com/outGetIpInfo?accessKey=alibaba-inc&ip='.$ip);
    $data = json_decode($url,true);
    // 初始化

    return $data['data'];

}

/**
 * 生成随机字符串
 * @return string
 */
function rand_str($lenght = 6)
{
    $randStr = str_shuffle('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890');
    $rand = substr($randStr,0,$lenght);

    return $rand;
}


/**
 * 生成随机数字
 */
function rand_code($n = 4)
{
    $chars='0123456789';
    mt_srand((double)microtime() * pow(10, $n) * getmypid());

    $CheckCode="";
    while(strlen($CheckCode) < $n)
        $CheckCode .= substr($chars, (mt_rand()%strlen($chars)), 1);


    return $CheckCode;
}



/**
 * 获取毫秒级时间戳
 */

if (! function_exists('getMicroTime')) {
    function getMicroTime(){
        $mt = microtime();
        $pair = explode(' ', $mt);
        return $pair[1].substr($pair[0], 2, 6);
    }
}


/**
 * 获取线上ip
 * @return array|false|string
 */
function get_onlineip(){
    $onlineip = '';
    if(getenv('HTTP_CLIENT_IP') && strcasecmp(getenv('HTTP_CLIENT_IP'), 'unknown'))
    {
        $onlineip = getenv('HTTP_CLIENT_IP');
    }
    elseif(getenv('HTTP_X_FORWARDED_FOR') && strcasecmp(getenv('HTTP_X_FORWARDED_FOR'), 'unknown'))
    {
        $onlineip = getenv('HTTP_X_FORWARDED_FOR');
    }
    elseif(getenv('REMOTE_ADDR') && strcasecmp(getenv('REMOTE_ADDR'), 'unknown'))
    {
        $onlineip = getenv('REMOTE_ADDR');
    }
    elseif(isset($_SERVER['REMOTE_ADDR']) && $_SERVER['REMOTE_ADDR'] && strcasecmp($_SERVER['REMOTE_ADDR'], 'unknown'))
    {
        $onlineip = $_SERVER['REMOTE_ADDR'];
    }
    return $onlineip;
}

/**
 * 日志记录
 * @param $msg
 * @param $params
 * @param string $file
 */
function write_log($msg, $params=[], $file="")
{
    static $traceID;
    if ($traceID == "") {
        $traceID = rand_str(20);
        header("trace-id:". $traceID);
    }
    if ($file == "" || ! file_exists($file))
    {
        $name = !empty($file) ? $file:"laravel-access";//此路径不会自动创建，只会创建文件
        $file = storage_path("rundata".DIRECTORY_SEPARATOR."logs".DIRECTORY_SEPARATOR.$name."-".date('Y-m-d'). ".log");
    }

    $logBody                = [];
    $logBody['trace-id']    = $traceID;
    $logBody['ts']          = date('Y-m-d H:i:s',time());
    $logBody['msg']         = $msg;
    $logBody['values']      = $params;

    error_log(json_encode($logBody, JSON_UNESCAPED_UNICODE)."\n",3,$file);
}


/**
 * 解析加密token(为了游客页面 与 需要登录页面)
 */
function expain_token($token)
{
    try
    {
        $params = Crypt::decrypt($token);
    }
    catch(DecryptException $e)//捕获异常信息
    {
        failed($e->getMessage());
    }

    //判断是否过期
    if(time()>$params['expire'])
        failed("token已过期！",4001);

    if(!isset($params["uid"]))
        failed("请求错误！",4001);

    return $params["uid"];
}

/**
 * 隐藏手机号中间4位
 * @param $mobile
 * @return mixed
 */
function hideMobile($mobile)
{
    $new_mobile = substr_replace($mobile, '****', 3, 4);
    return $new_mobile;
}

/**
 * 递归 树节点算法
 * @param $array
 * @param  $pid
 * @return  mixed
 */
 function getChild($array,$pid = 0){
    $data = array();
    foreach ($array as $k=>$v){
        //PID符合条件的
        if($v->org_up == $pid){

            //寻找子集
            $child = getChild($array,$v->org_id);
            //加入数组
            $v->child = $child?:array();

            $data[] = $v;//加入数组中
        }
    }

    return $data;
}


/**
 * 失败响应
 * @param $msg
 * @param int $code
 */
function failed($data,$code=4000,$msg="failed")
{
    $data = [
        "msg"   => $msg,
        "code"  => $code,
        "data"  => $data,
        "time"  => date("Y-m-d H:i:s")
    ];

    throw new HttpResponseException(response()->json($data));
}

function getToken(){
    $app_sercet = '83debf5990f4ee596e8ea4773767c2e8';
    $data['app_id'] = '102635';
    $data['random_str'] = Utils::getRandomString(12);
    $data['timestamp'] = time();
    $data['key'] = md5($data['app_id'].$data['random_str'].$data['timestamp'].$app_sercet);
    $url = 'http://cloud-api.tengface.com/api/common/getAccessToken';
    $res = getResult($url,$data,"post");
    if($res['code'] == 200){
        return $res['data']['token'];
    }else{
        return $res['msg'];
    }
}


/**
 * @param $url
 * @param null $requestData
 * @param string $requestType
 * @param $headers
 * @return mixed
 * @throws Exception
 */
function getResult($url,$requestData = NULL,$requestType = "post",$headers=[])
{
    $data = !empty($requestData) ? $requestData:NULL;

    $curl = new Curl();
    $curl->setTimeout(120);
    $curl->setOpt(CURLOPT_SSL_VERIFYPEER, false);
    $curl->setOpt(CURLOPT_SSL_VERIFYHOST, false);

    if(!empty($headers))
    {

        $curl->setOpt(CURLOPT_HEADER, 0);
        $curl->setHeaders($headers);
        //$curl->setOpt(CURLOPT_HTTPHEADER, $headers);
    }

    $res    = $requestType == "get" ? $curl->get($url, $data) : $curl->post($url, $data);

    if ($curl->error)
        throw new Exception($curl->errorMessage);

    $res = is_object($res) ? object_to_array($res) : json_decode($res, true);

    return $res;
}

/**
 * 对象转数组
 * @param $object
 * @return mixed
 */
function object_to_array(&$object){
    $object = json_decode(json_encode($object),true);
    return  $object;
}


/**
 * 把返回的数据集转换成Tree
 * @param array $list 要转换的数据集
 * @param string $pk  自定义主键
 * @param string $pid  自定义父节点
 * @param string $child  子节点标识
 * @param int $root  节点层级
 * @return array
 */
function list_to_tree($list, $pk='id',$pid = 'pid',$child = '_child',$root='00000000') {
    // 创建Tree
    $tree = array();

    if(is_object($list)) {
        // 创建基于主键的数组引用
        $refer = array();
        foreach ($list as $key => $data) {
            $refer[$data->$pk] =& $list[$key];
        }
        foreach ($list as $key => $data) {
            // 判断是否存在parent
            $parentId = $data->$pid;
            if ($root == $parentId) {
                $tree[] =& $list[$key];
            }else{
                if (isset($refer[$parentId])) {
                    $parent =& $refer[$parentId];
                    $parent->$child[] =& $list[$key];
                }
            }
        }
    }
    return $tree;
}

//树转数组

function treeToList($tree,&$result=array()){

    foreach($tree as $k=>$v){
        $result[$v->org_id]=$v;
        if (isset($v->child)) {
            treeToList($v->child,$result);
        }
    }

    $result = array_map(function($item){
        unset($item->child);
        return  $item;
    },$result);
    return $result;
}

/*************************简单加密解密***************************/

/**
 * @desc加密
 * @param string $str 待加密字符串
 * @param string $key 密钥
 * @return string
 */
function my_encrypt($str, $key){
    $mixStr = md5(date('Y-m-d H:i:s').rand(0,1000));
    $tmp = '';
    $strLen = strlen($str);
    for($i=0, $j=0; $i<$strLen; $i++, $j++){
        $j = $j == 32 ? 0 : $j;
        $tmp .= $mixStr[$j].($str[$i] ^ $mixStr[$j]);
    }
    return base64_encode(bind_key($tmp, $key));
}

/**
 * @desc解密
 * @param string $str 待解密字符串
 * @param string $key 密钥
 * @return string
 */
function my_decrypt($str, $key){
    $str = bind_key(base64_decode($str), $key);
    $strLen = strlen($str);
    $tmp = '';
    for($i=0; $i<$strLen; $i++){
        $tmp .= $str[$i] ^ $str[++$i];
    }
    return $tmp;
}

/**
 * @desc辅助方法 用密钥对随机化操作后的字符串进行处理
 * @param $str
 * @param $key
 * @return string
 */
function bind_key($str, $key){
    $encrypt_key = md5($key);

    $tmp = '';
    $strLen = strlen($str);
    for($i=0, $j=0; $i<$strLen; $i++, $j++){
        $j = $j == 32 ? 0 : $j;
        $tmp .= $str[$i] ^ $encrypt_key[$j];
    }
    return $tmp;
}


function isHTTPS()
{

    if (defined('HTTPS') && HTTPS) return true;
    if (!isset($_SERVER)) return FALSE;

    if (!isset($_SERVER['HTTPS'])) return FALSE;

    if ($_SERVER['HTTPS'] === 1) {  //Apache
        return TRUE;
    } elseif ($_SERVER['HTTPS'] === 'on') { //IIS

        return TRUE;

    } elseif ($_SERVER['SERVER_PORT'] == 443) { //其他

        return TRUE;

    }
    return FALSE;
}


function getErrorMsg($errorStr,$lang='tc',$field=""){
    return $field.trans("error.$errorStr",[],$lang);
}


if (!function_exists('is_mobile')) {
    function is_mobile($phone)
    {

        if (preg_match("/^1[123456789]{1}\d{9}$/", $phone)) {
            return true;
        } else {
            return false;
        }
    }
}


/**
 * 處理存進來的時間
 * @param string $str 目前時間
 * @param int $num 轉換時間預設 GTM - 07
 * @param bool $bool true 為 +，false 為 -
 * @return string
 */
function transferTime($str, $num = 7, $bool = false){
    $carbonTime = Carbon::parse($str);
    return $bool ? $carbonTime->addHours($num) : $carbonTime->subHours($num);
}

// /**
//  * 處理存取 json
//  * @param array $arr 輸入的陣列
//  * @param bool $bool true 為 incode，false 為 decode，預設 decode
//  * @return mixed 如果是 decode 操作，返回 decode 參數；如果是 encode 操作，返回 JSON 字符串
//  */
// function jsonTrans($arr, $bool = false){
//     return $bool ? json_encode($arr) : json_decode($arr, true);
// }