<?php

/**
 * Created by PhpStorm.
 * User: VolitationXiaoXing
 * Date: 2018/11/14
 * Time: 上午11:42
 */

namespace App\Helpers;

class Token
{

    //一个新用户获取Token
    public static function getToken($uid, $type, $list = [])
    {

        $key = md5(env("TOKEN_KEY"));
        $data = ["uid" => $uid];
        $data["create_time"] = time();
        $data["type"] = $type;
        $data["data"] = $list;

        $jsonData = json_encode($data);
        $jsonData = self::confoundData($jsonData);

        $encrypt =  openssl_encrypt($jsonData, "AES-128-CBC", $key, 0, env("TOKEN_IV"));

        return $encrypt;
    }

    //将token中信息解析出来
    public static function parseToken($token)
    {

        $token = str_replace(" ", "+", $token);

        $key = md5(env("TOKEN_KEY"));

        $data =  openssl_decrypt($token, "AES-128-CBC", $key, 0, env("TOKEN_IV"));

        $data = self::restoreData($data);

        return json_decode($data, true);
    }

    //判断Token是否失效
    public static function checkTokenLoseEfficacy($token)
    {

        $token = str_replace(" ", "+", $token);

        $key = md5(env("TOKEN_KEY"));

        $data =  openssl_decrypt($token, "AES-128-CBC", $key, 0, env("TOKEN_IV"));

        $json = self::restoreData($data);

        $json = json_decode($json, true);

        if (!$json) {
            return false;
        }

        if (empty("type")) {
            return false;
        }

        if ($json["type"] == 1) {
            //商户
            if (env("TOKEN_VALIDITY") == -1) {
                if ($json["uid"]) {
                    //不支持多点就要登入查数据库看看是否，是最新的Token
                    return $json["uid"];
                } else {
                    return false;
                }
            } else {
                $t = $json["create_time"] + env("TOKEN_VALIDITY") * 60 * 60;
                if (time() > $t) {
                    return false;
                } else {
                    if (!empty($json["uid"])) {
                        return $json["uid"];
                    } else {
                        return false;
                    }
                }
            }
        } else if ($json["type"] == 2) {
            //用户
            if (env("TOKEN_VALIDITY_FANS") == -1) {
                if ($json["uid"]) {
                    //不支持多点就要登入查数据库看看是否，是最新的Token
                    return $json["uid"];
                } else {
                    return false;
                }
            } else {
                $t = $json["create_time"] + env("TOKEN_VALIDITY_FANS") * 60 * 60;
                if (time() > $t) {
                    return false;
                } else {
                    if (!empty($json["uid"])) {
                        return $json["uid"];
                    } else {
                        return false;
                    }
                }
            }
        }

        return false;
    }


    //刷新token
    public static function refillToken($token)
    {

        $token = str_replace(" ", "+", $token);

        $key = md5(env("TOKEN_KEY"));

        $data =  openssl_decrypt($token, "AES-128-CBC", $key, 0, env("TOKEN_IV"));

        $json = self::restoreData($data);

        $jsonData = json_decode($json, true);

        if (!$jsonData) {

            return false;
        }

        $jsonData["create_time"] = time();
        $jsonData = json_encode($jsonData);

        $jsonData = self::confoundData($jsonData);

        $encrypt =  openssl_encrypt($jsonData, "AES-128-CBC", $key, 0, env("TOKEN_IV"));

        return $encrypt;
    }

    protected static function confoundData($data)
    {

        $arr = json_decode(env("TOKEN_RANDOM"), true);

        $times = rand(3, 9);

        $count = 0;

        while (($count + $times) < strlen($data)) {

            $count = $count + $times;

            $data = substr_replace($data, $arr[rand(0, 19)], $count, 0);

            $count = $count + 1;
        }

        $data = substr_replace($data, $times, 5, 0);

        return $data;
    }


    protected static function restoreData($data)
    {

        $f = substr($data, 0, 5);

        $times = substr($data, 5, 1);

        $s = substr($data, 6);

        $data =  $f . $s;

        $count = 0;

        while (($count + $times) < strlen($data)) {

            $count = $count + $times;
            $f = substr($data, 0, $count);
            $s = substr($data, $count + 1);
            $data = $f . $s;
        }

        return $data;
    }
}
