<?php
/**
 * artical控制器
 * @author  lipan
 * @date 2022-12-12
 */
namespace App\Http\Controllers\Admin;
use App\Http\Controllers\BaseController;
use App\Repositories\Business\Item\ArticleRepository;
use Illuminate\Http\Request;

class ArticleController extends BaseController{

    //增加article
    public function add(Request $request, ArticleRepository $articleRepository){
        $params = $request->post();
        $lang   = $request->post("lang","tc");

        $this->checkParams($params,$lang);

        $id = $articleRepository->add($params,$lang);

        $id ? $this->success(trans('msg.operate_success',[],$lang)) :$this->failed(trans('msg.operate_failed',[],$lang));

    }

    //删除article
    public function del(Request $request, ArticleRepository $articleRepository){
        $id     = $request->post("id");
        $lang   = $request->post("lang","tc");
        if(empty($id))
            $this->failed("id不能为空");

        $bool   = $articleRepository->del($id,$lang);

        $bool ? $this->success(trans('msg.operate_success',[],$lang)) :$this->failed(trans('msg.operate_failed',[],$lang));

    }

    //修改article
    public function edit(Request $request, ArticleRepository $articleRepository){
        $params = $request->post();
        $id     = $request->post("id");
        $lang   = $request->post("lang","tc");

        if(empty($id))
            $this->failed(trans('msg.id_empty',[],$lang));

        $this->checkParams($params,$lang);

        $bool   = $articleRepository->edit($id,$params,$lang);

        $bool ? $this->success(trans('msg.operate_success',[],$lang)) :$this->failed(trans('msg.operate_failed',[],$lang));

    }

    //查询article
    public function list(Request $request, ArticleRepository $articleRepository){

        $params                   = $request->query();
        $params["page"]           = $request->get("page");
        $params["page_nums"]      = $request->get("page_nums");
        $params["lang"]           = $request->get("lang","tc");
        //$data["field"]          = $request->get("field","created_time");
        //$data["sort"]           = $request->get("sort","desc");

        $list = $articleRepository->list($params);
        $this->success($list);
    }

    //检验入参
    protected function checkParams($params,$lang){
        if(!in_array($lang,config("app.lang")))
            $this->failed(trans('msg.lang_no_exist',[],$lang));

        if(!isset($params["title"]) || empty($params["title"]))
            $this->failed(trans('msg.title_empty',[],$lang));

        if(!isset($params["sub_title"]) || empty($params["sub_title"]))
            $this->failed(trans('msg.sub_title_empty',[],$lang));

        if(!isset($params["content"]) || empty($params["content"]))
            $this->failed(trans('msg.content_empty',[],$lang));

        if(!isset($params["img"]) || empty($params["img"]))
            $this->failed(trans('msg.img_empty',[],$lang));
    }
}