<?php
/**
 * banner控制器
 * @author  lipan
 * @date 2022-12-12
 */
namespace App\Http\Controllers\Admin;
use App\Http\Controllers\BaseController;
use App\Repositories\Business\Item\BannerRepository;
use Illuminate\Http\Request;

class BannerController extends BaseController{

    //增加banner
    public function add(Request $request, BannerRepository $bannerRepository){
        $params = $request->post();
        $lang   = $request->post("lang","tc");

        $this->checkParams($params,$lang);

        $id = $bannerRepository->add($params,$lang);

        $id ? $this->success(trans('msg.operate_success',[],$lang)) :$this->failed(trans('msg.operate_failed',[],$lang));

    }

    //删除banner
    public function del(Request $request, BannerRepository $bannerRepository){
        $id     = $request->post("id");
        $lang   = $request->post("lang","tc");
        if(empty($id))
            $this->failed("id不能为空");

        $bool   = $bannerRepository->del($id,$lang);

        $bool ? $this->success(trans('msg.operate_success',[],$lang)) :$this->failed(trans('msg.operate_failed',[],$lang));

    }

    //修改banner
    public function edit(Request $request, BannerRepository $bannerRepository){
        $params = $request->post();
        $id     = $request->post("id");
        $lang   = $request->post("lang","tc");

        if(empty($id))
            $this->failed(trans('msg.id_empty',[],$lang));

        $this->checkParams($params,$lang);

        $bool   = $bannerRepository->edit($id,$params,$lang);

        $bool ? $this->success(trans('msg.operate_success',[],$lang)) :$this->failed(trans('msg.operate_failed',[],$lang));

    }

    //查询banner
    public function list(Request $request, BannerRepository $bannerRepository){

        $params                   = $request->query();
        $params["page"]           = $request->get("page");
        $params["page_nums"]      = $request->get("page_nums");
        $params["lang"]           = $request->get("lang","tc");
        //$data["field"]          = $request->get("field","created_time");
        $data["type"]           = $request->get("type","1");

        $list = $bannerRepository->list($params);
        $this->success($list);
    }

    //检验入参
    protected function checkParams($params,$lang){
        if(!in_array($lang,config("app.lang")))
            $this->failed(trans('msg.lang_no_exist',[],$lang));

        if(!isset($params["banner"]) || empty($params["banner"]))
            $this->failed(trans('msg.banner_empty',[],$lang));
    }
}