<?php
/**
 * 优惠券控制器
 * @author  lipan
 * @date 2022-12-12
 */
namespace App\Http\Controllers\Admin;
use App\Http\Controllers\BaseController;
use App\Repositories\Business\Item\CouponRepository;
use App\Repositories\Business\Item\UserCouponRepository;
use Illuminate\Http\Request;

class CouponController extends BaseController{

    //增加优惠券
    public function add(Request $request, CouponRepository $couponRepository){
        $params = $request->post();
        $lang   = $request->post("lang","tc");
        $this->checkParams($params,$lang);

        $id = $couponRepository->add($params,$lang);

        $id ? $this->success(trans('msg.operate_success',[],$lang)) :$this->failed(trans('msg.operate_failed',[],$lang));
    }

    //删除优惠券
    public function del(Request $request, CouponRepository $couponRepository){
        $id     = $request->post("id");
        $lang   = $request->post("lang","tc");
        if(empty($id))
            $this->failed("id不能为空");

        $bool   = $couponRepository->del($id,$lang);

        $bool ? $this->success(trans('msg.operate_success',[],$lang)) :$this->failed(trans('msg.operate_failed',[],$lang));
    }

    //修改优惠券
    public function edit(Request $request, CouponRepository $couponRepository){
        $params = $request->post();
        $id     = $request->post("id");
        $lang   = $request->post("lang","tc");

        if(empty($id))
            $this->failed(trans('msg.id_empty',[],$lang));

        $this->checkParams($params,$lang);

        $bool   = $couponRepository->edit($id,$params,$lang);

        $bool ? $this->success(trans('msg.operate_success',[],$lang)) :$this->failed(trans('msg.operate_failed',[],$lang));
    }

    //查询优惠券
    public function list(Request $request, CouponRepository $couponRepository){

        $params                   = $request->query();
        $params["page"]           = $request->get("page");
        $params["page_nums"]      = $request->get("page_nums");
        $params["lang"]           = $request->get("lang","tc");
        //$data["field"]          = $request->get("field","created_time");
        //$data["sort"]           = $request->get("sort","desc");

        $list = $couponRepository->list($params);

        $this->success($list);
    }


    /**
     * 发送优惠券
     * @param Request $request
     * @param UserCouponRepository $userCouponRepository
     */
    public function send(Request $request, UserCouponRepository $userCouponRepository)
    {
        $params = $request->post();
        $id     = $request->post("id");
        $lang   = $request->post("lang","tc");
        $level   = $request->post("level","1");

        if(empty($id))
            $this->failed(trans('msg.id_empty',[],$lang));

        $bool   = $userCouponRepository->add($params,$lang,$level);

        $bool ? $this->success(trans('msg.operate_success',[],$lang)) :$this->failed(trans('msg.operate_failed',[],$lang));
    }



    //检验入参
    protected function checkParams($params,$lang){
        if(!in_array($lang,config("app.lang")))
            $this->failed(trans('msg.lang_no_exist',[],$lang));

        if(!isset($params["name"]) || empty($params["name"]))
            $this->failed(trans('msg.coupon_name_empty',[],$lang));

        if(!isset($params["img"]) || empty($params["img"]))
            $this->failed(trans('msg.img_empty',[],$lang));

        if(!isset($params["ids"]) || empty($params["ids"]))
            $this->failed(trans('msg.item_ids_empty',[],$lang));

        // if(!isset($params["send_num"]) || empty($params["send_num"]))
        //     $this->failed(trans('msg.send_num_empty',[],$lang));

        if(!isset($params["start_date"]) || empty($params["start_date"]))
            $this->failed(trans('msg.start_date_empty',[],$lang));

        if(!isset($params["end_date"]) || empty($params["end_date"]))
            $this->failed(trans('msg.end_date_empty',[],$lang));

    }
}