<?php
/**
 *  后台控制器
 */
namespace App\Http\Controllers\Admin;
use App\Http\Controllers\BaseController;
use Illuminate\Http\Request;
Use Illuminate\Support\Facades\Input;
use App\Repositories\Common\SmsRepository;
use App\Repositories\Wechat\AlipayRepository;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Hash;
use Carbon\Carbon;

class HomeController extends BaseController{

    public function login(){
        $account = Input::get('account');
        $pass = Input::get('pass');
        $lang   = Input::get("lang","tc");
        
        $l = config($lang);

        if(empty($account)||empty($pass))
            $this->failed($l['param_incomplete']);
        
        $user = Db::table('clerk')->where('account',$account)->first();
        if(!$user)
            $this->failed($l['account_not_exists']);//账户不存在
                
        if($user->status != 0)
            $this->failed($l['login_error']);//账户被禁用
                
        $passmd5 = md5($pass);   
        if($passmd5 != $user->pass)
            $this->failed($l['pass_error']);
        
        $token_data = [
            'plat'          => 'admin',
            'uid'       => $user->id,  //账号id
            'expire'        => time()+3600*24*7,   //登陆有效期：7天
        ];
        $token = Crypt::encrypt($token_data);
        // $store = Db::table('store')->where('id',$user->sid)->value('name_'.$this->lang);
        $this->success(['code'=>0,'token'=>$token,'name'=>$user->name,'type'=>$user->type]);
    }

    public function getAuth(){
        $type = Db::table('clerk')->where('id',UID)->value('type');
        return $this->success($type);
    }

    public function analyze(){
        $type = Input::get('type') ?? 0;
        $lang   = Input::get("lang","tc");
        $sid   = Input::get("sid","0");
        $start_date   = Input::get("start_date");
        $end_date   = Input::get("end_date");
        if(empty($type))
            $this->failed($this->l['param_incomplete']);

        $w = [];
        if(!empty($sid)){
            $w['sid'] = $sid;
        }
        if(!empty($start_date) && !empty($end_date)){
            $w[] = ['date','<=',$end_date];
            $w[] = ['date','>=',$start_date];
        }
        // print_r($w);
        $list = Db::table('analyze')->where($w)->get();

        $resu = $nums = [];
        if($type == 2){//各店家统计
            $list = $list->groupBy('sid')->toArray();
        }else{
            $list = $list->groupBy('date')->toArray();
        }
        foreach($list as $k=>$d){
            $money = $num = 0;
            foreach($d as $v){
                $money += $v->money;
                $num += $v->num;
            }
            $resu[$k] = $money;
            $nums[$k] = $num;
        }
        
        if($type == 1){//各销售额统计
            if(!empty($start_date) && !empty($end_date)){
                $d = strtotime($start_date);
                $diff = (strtotime($end_date)-strtotime($start_date))/86400;
            }else{
                $date = Db::table('analyze')->orderBy('date','asc')->value('date');
                $today = date('Y-m-d');
                $diff = (strtotime($today)-strtotime($date))/86400;
                $d = strtotime($date);
            }
            for($i=0;$i<=$diff;$i++){
                $di = date('Y-m-d',$d+$i*86400);
                if(!array_key_exists($di,$resu)){
                    $resu[$di] = 0;
                }
            }
            ksort($resu);
            $result = $resu;
        }else if($type == 2){//各店家统计
            $result = [];
            foreach($resu as $k=>$v){
                $name = Db::table('store')->where('id',$k)->value('name_'.$lang);
                if(empty($name)){
                    continue;
                }
                $result[$name] = $v;
            }
        }else if($type == 3){
            if(!empty($start_date) && !empty($end_date)){
                $d = strtotime($start_date);
                $diff = (strtotime($end_date)-strtotime($start_date))/86400;
            }else{
                $date = Db::table('analyze')->orderBy('date','asc')->value('date');
                $today = date('Y-m-d');
                $diff = (strtotime($today)-strtotime($date))/86400;
                $d = strtotime($date);
            }
            for($i=0;$i<=$diff;$i++){
                $di = date('Y-m-d',$d+$i*86400);
                if(!array_key_exists($di,$nums)){
                    $nums[$di] = 0;
                }
            }
            ksort($nums);
            $result = $nums;
        }
        $this->success($result);
    }

    public function couponAnalyze(){
        $type = Input::get('type') ?? 0;
        $lang = Input::get("lang","tc");
        $start_date   = Input::get("start_date");
        $end_date   = Input::get("end_date");
        $w['type'] = $type;
        if(!empty($start_date) && !empty($end_date)){
            $w[] = ['create_time','<=',$end_date];
            $w[] = ['create_time','>=',$start_date];
        }
        if(empty($type))
            $this->failed($this->l['param_incomplete']);

        $list = Db::table('user_coupon')->where($w)->get();
        $list = $list->groupBy('status')->toArray();
        $resu = [];
        foreach($list as $k=>$v){
            $resu[$k] = count($v);
        }
        if($this->lang == 'en'){
            $result[0]['name'] = 'not used';
            $result[1]['name'] = 'Used';
            $result[2]['name'] = 'Expired';
        }else{
            $result[0]['name'] = '未使用';
            $result[1]['name'] = '已使用';
            $result[2]['name'] = '已過期';
        }
        
        if(array_key_exists(0,$resu)){
            $result[0]['value'] = $resu[0];
        }else{
            $result[0]['value'] = 0;
        }
        if(array_key_exists(1,$resu)){
            $result[1]['value'] = $resu[1];
        }else{
            $result[1]['value'] = 0;
        }
        if(array_key_exists(2,$resu)){
            $result[2]['value'] = $resu[2];
        }else{
            $result[2]['value'] = 0;
        }
        $this->success($result);
    }

    public function userAnalyze(){
        $start_date   = Input::get("start_date");
        $end_date   = Input::get("end_date");
        $w = [];
        if(!empty($start_date) && !empty($end_date)){
            $w[] = ['date','<=',$end_date];
            $w[] = ['date','>=',$start_date];
        }
        $date = Db::table('user')->orderBy('date','asc')->value('date');
        $list = Db::table('user')->orderBy('date','asc')->where($w)->get();
        $list = $list->groupBy('date')->toArray();
        $resu = [];//新用户
        foreach($list as $k=>$v){
            $resu[$k] = count($v);
        }
        $log = Db::table('login_log')->orderBy('date','asc')->where($w)->get();
        $log = $log->groupBy('date')->toArray();
        $resu1 = [];//在线用户
        foreach($log as $k=>$v){
            $resu1[$k] = count($v);
        }
        if(!empty($start_date) && !empty($end_date)){
            $d = strtotime($start_date);
            $diff = (strtotime($end_date)-strtotime($start_date))/86400;
        }else{
            $today = date('Y-m-d');
            $diff = (strtotime($today)-strtotime($date))/86400;
            $d = strtotime($date);
        }
        $result = [];
        for($i=0;$i<=$diff;$i++){
            $di = date('Y-m-d',$d+$i*86400);
            if(array_key_exists($di,$resu)){
                $result[$di]['new'] = $resu[$di];
            }else{
                $result[$di]['new'] = 0;
            }
            if(array_key_exists($di,$resu1)){
                $result[$di]['online'] = $resu1[$di];
            }else{
                $result[$di]['online'] = 0;
            }
        }
        $this->success($result);
    }

    //总后台修改密码
    public function editPass(){
        $code = Input::get('code');
        $repass = Input::get('repass');
        $newpass = Input::get('newpass');
        $staff = Db::table('staff')->where('id',UID)->first();

        $result = Db::table('emailmessage_log')->where('address',$staff->tel)->orderBy('time','desc')->first();
        if(empty($result))
            $this->failed("验证码未发送，请重新发送验证码！");

        if(time()-$result->time > 300){//超过五分钟，超时
            $this->failed("该验证码已超时，请重新发送验证码！");
        }

        if($result->code != $code){//验证码错误
            $this->failed("验证码错误，请重新提交验证码！");
        }

        if($newpass != $repass)
            $this->failed('两次密码输入不一致');

        $pass = Hash::make($newpass.$staff->salt);
        Db::table('staff')->where('id',UID)->update(['pass'=>$pass]);
        $this->success('修改密码成功！');
    }

    public function pushMsg(){
        $title = Input::get('title');
        $type = Input::get('type') ?? 1;
        $content = Input::get('content');
        $data['create_time'] = date('Y-m-d H:i:s');
        $lang = Input::get('lang') ?? 'tc';
        $level = Input::get('level') ?? '0';
        $notice['uid'] = 0;
        $img = Input::get('img');
        $end_time = Input::get('end_time');
        $start_time = Input::get('start_time');
        $data['end_time'] = $end_time;
        $data['img'] = $img;
        $data['start_time'] = $start_time;
        $notice['img'] = $img;
        if($lang == 'tc'){
            $data['title_tc'] = $title;
            $data['content_tc'] = $content;
            $notice['title_tc'] = $title;
        }else{
            $notice['title_en'] = $title;
            $data['title_en'] = $title;
            $data['content_en'] = $content;
        }
        $data['type'] = 1;
        $id = Db::table('arcicle')->insertGetid($data); 
        $notice['type'] = $type;
        $notice['date'] = date('Y-m-d');
        $notice['flag'] = 1;
        $notice['link'] = $id;
        $notice['level'] = $level;
        $notice['create_time'] = date('Y-m-d H:i:s');
        Db::table('notice')->insert($notice);
        $this->success('',$this->l['operation_success']);
    }

    public function userList(){
        $key = Input::get('key');
        $w = [];
        if(!empty($key)){
            $w[] = ['account','like','%'.$key.'%'];
        }
        $result = Db::table('user')->where($w)->orderBy('create_time','desc')->get(['id','name','email','account','status','avatar','create_time','sex','birthday','level'])->toArray();
        foreach($result as &$v){
            $v->levelname = Db::table('level')->where('id',$v->level)->value('name_'.$this->lang.' as name');
        }
        $this->success($result);
    }

    public function userOrder(){
        $id = Input::get('id');
        $result = Db::table('order')->where('uid',$id)->where('status','>','0')->get(['id','order_no','phone','price','pay_time','sname_'.$this->lang.' as sname'])->toArray();
        
        foreach($result as &$v){
            $goods = Db::table('cart_goods')->where('status',$v->id)->pluck('title')->toArray();
            $v->goods = implode(',',$goods);
        }
        $this->success($result);
    }

    public function switchUser(){
        $id = Input::get('id');
        $status = Input::get('status');
        Db::table('user')->where('id',$id)->update(['status'=>$status]);
        $this->success('',$this->l['operation_success']);
    }

    public function systemset(){
        $msg = Input::all();
        foreach($msg as $k=>$v){
            Db::table('exper')->where('id',$k)->update(['experience'=>$v]);
        }
        $this->success('',$this->l['operation_success']);
    }

    public function scoreset(){
        $type = Input::get('type');//1等级，2点数
        $money = Input::get('money');
        $score = Input::get('score');
        if($type == 1){
            // $data= Db::table('exper')->where('id',11)->update(['level'=>$money,'experience'=>$score]);
            $data= Db::table('exper')->where('id',11)->update(['level'=>$money]);
        }else{
            // $data= Db::table('exper')->where('id',12)->update(['level'=>$money,'experience'=>$score]);
            $data= Db::table('exper')->where('id',12)->update(['level'=>$money]);
        }
        $this->success('',$this->l['operation_success']);
    }
    
    public function systemget(){
        $this->success(Db::table('exper')->get());
    }

    public function noticeList(){
        $type = Input::get('type') ?? 1;
        $list = Db::table('notice as n')->join('arcicle as a','n.link','=','a.id')->where('n.type',$type)->orderBy('n.create_time','desc')->get(['a.*','a.title_'.$this->lang.' as title','a.content_'.$this->lang.' as content','a.sub_title_'.$this->lang.' as sub_title','n.id as nid','n.level'])->toArray();
        $this->success($list);
    }
    
    public function noticeEdit(){
        $id = Input::get('id') ?? 0;
        if(empty($id))
            $this->failed($this->l['param_incomplete']);
        
        $title = Input::get('title');
        $content = Input::get('content');
        $end_time = Input::get('end_time')??null;
        $start_time = Input::get('start_time');
        $level = Input::get('level') ?? 0;
        $lang = Input::get('lang') ?? 'tc';
        $img = Input::get('img');

        $data['end_time'] = $end_time;
        $data['img'] = $img;
        $data['start_time'] = $start_time;
        $noed['level'] = $level;
        if($lang == 'tc'){
            $data['title_tc'] = $title;
            $noed['title_tc'] = $title;
            $data['content_tc'] = $content;
        }else{
            $data['title_en'] = $title;
            $noed['title_tc'] = $title;
            $data['content_en'] = $content;
        }
        Db::table('arcicle')->where('id',$id)->update($data); 
        
        Db::table('notice')->where('link',$id)->update($noed);
        $this->success('',$this->l['operation_success']);
    }
    
    public function noticeDel(){
        $id = Input::get('nid') ?? 0;
        if(empty($id))
            $this->failed($this->l['param_incomplete']);

        Db::table('notice')->delete($id);
        $this->success('',$this->l['operation_success']);
    }

    public function getrule(){
        $me = Db::table('rule')->where('type',1)->where('flag',0)->first(['ids','num']);
        $you = Db::table('rule')->where('type',1)->where('flag',1)->first(['ids','num']);
        $this->success(compact('me','you'));
    }

    // gc_kevin : 修改存檔流程
    public function setrule(){

        $input = Input::all();
        // $flag = Input::get('flag') ?? 0;
        // $data['ids'] = Input::get('ids') ?? 0;
        // $data['num'] = Input::get('num') ?? 0;
        // Db::table('rule')->where('type',1)->where('flag',$flag)->update($data);

        // 給自己點數
        if(isset($input['me'])){
            Db::table('rule')->where('type', 1)->where('flag', 0 )->update( ['num' => $input['me'] ] );
        }
        // 給對方點數
        if(isset($input['your'])){
            Db::table('rule')->where('type', 1)->where('flag', 1 )->update( ['num' => $input['your'] ] );
        }

        $this->success('',$this->l['operation_success']);
    }

    public function levelList(){
        $list = Db::table('level')->orderBy('id','desc')->get(['name_'.$this->lang.' as name','id','img', 'score','desc1','desc2'])->toArray();
        $this->success($list);
    }

    public function levelAoE(){
        $id = Input::get('id') ?? 0;
        $lang = Input::get('lang') ?? 'tc';
        $data['score'] = Input::get('score') ?? 0;
        $data['img'] = Input::get('img');
        $data['desc1'] = Input::get('desc1');
        $data['desc2'] = Input::get('desc2');
        if(empty($id)){
            $data['name_tc'] = Input::get('name_tc');
            $data['name_en'] = Input::get('name_en');
            $score = Db::table('level')->max('score');
            if(!empty($score) && $score <= $data['score']){
                $this->failed($this->l['parameter_error']);
            }
            Db::table('level')->insert($data);
        }else{
            $data['name_'.$lang] = Input::get('name');
            Db::table('level')->where('id',$id)->update($data);
        }
        $this->success('',$this->l['operation_success']);
    }

    public function accountList(){
        $list = Db::table('clerk')->where('sid',0)->where('status',0)->orderBy('id','desc')->get(['account','name','id','type', 'create_time'])->toArray();
        $this->success($list);
    }

    public function accountAoE(){
        $id = Input::get('id') ?? 0;
        $data['name'] = Input::get('name');
        $data['type'] = Input::get('type') ?? 1;
        $pass = Input::get('pass');
        $data['account'] = Input::get('account');

        // 確認是否重複帳號
        $user = Db::table('clerk')->where('account', $data['account'])->first();
        if($user){
            $this->failed($this->l['account_reapet']);
        }

        if(empty($id)){
            if(empty($pass) || empty($data['account'])){
                $this->failed($this->l['parameter_error']);
            }
            $data['pass'] = md5($pass);
            $clerk = Db::table('clerk')->where('status',0)->where('account',$data['account'])->first();
            if(!empty($clerk)){
                $this->failed($this->l['parameter_error']);
            }
            $data['sid'] = 0;
            $data['create_time'] = date('Y-m-d H:i:s');
            Db::table('clerk')->insert($data);
        }else{
            if(!empty($pass)){
                $data['pass'] = md5($pass);
            }
            Db::table('clerk')->where('id',$id)->update($data);
        }
        $this->success('',$this->l['operation_success']);
    }

    public function accountdel(){
        $id = Input::get('id') ?? 0;
        if(empty($id)){
            $this->failed($this->l['param_incomplete']);
        }
        Db::table('clerk')->where('id',$id)->update(['status'=>1]);
        $this->success('',$this->l['operation_success']);
    }

    public function orderList(){
        $sid = Input::get('sid') ?? 0;
        $start_date = Input::get('start_date');
        $end_date = Input::get('end_date');
        $status = Input::get('status') ?? -1;
        if($status == -1){
            $w[] = ['status','>',0];
        }else{
            $w['status'] = $status;
        }
        if($sid != 0){
            $w['sid'] = $sid;
        }
        if(!empty($start_date) && !empty($end_date)){
            $w[] = ['create_time','>',$start_date];
            $w[] = ['create_time','<',$end_date];
        }
        $list = Db::table('order')->where($w)->orderBy('create_time','desc')->get(['id','coupon','num','code','pick_time','finish_time','status','order_mark','phone','create_time','sid','sname_'.$this->lang.' as sname','money','order_no','payment_id']);
        foreach($list as &$v){
            $data = Db::table('cart_goods')->where('status',$v->id)->get(['title','tag', 'num']);

            $v->projectName = null;
            if(!$v->payment_id){
                $project = DB::table('project')->find($v->coupon);
                foreach ($data as $good) {
                    $good->tag = $project->{'title_' . $this->lang};
                }
            }
            
            $v->cart_goods = $data;
            $v->short_phone = substr($v->phone, -4);
            if($v->status == 1){
                if($this->lang == 'tc'){
                    $v->stu_name = '待出餐';
                }else{
                    $v->stu_name = 'to be served';
                }
                $store = Db::table('store')->where('id',$v->sid)->first(['now_order','now_cup']);
                $store->times = $store->now_cup*2;
                $v->store = $store;
            }else if($v->status == 2){
                if($this->lang == 'tc'){
                    $v->stu_name = '待取餐';
                }else{
                    $v->stu_name = 'pending meal';
                }
            }else if($v->status == 3){
                if($this->lang == 'tc'){
                    $v->stu_name = '已完成';
                }else{
                    $v->stu_name = 'completed';
                }
            }else if($v->status == 9){
                if($this->lang == 'tc'){
                    $v->stu_name = '退款';
                }else{
                    $v->stu_name = 'Refund';
                }
            }else{
                if($this->lang == 'tc'){
                    $v->stu_name = '未支付';
                }else{
                    $v->stu_name = 'Unpaid';
                }
            }
        }
        $this->success($list);
    }

    public function orderProjectList(){
        $start_date = Input::get('start_date');
        $end_date = Input::get('end_date');
        
        $list = DB::table('project_order')->when(!empty($start_date) && !empty($end_date), function ($query) use ($start_date, $end_date) {
            $query->where('created_at', '>', $start_date)
                ->where('created_at', '<', $end_date);
            })->orderBy('created_at', 'desc')
            ->select('project_order.status', 'project_order.id', 'project_order.phone', 'project_order.price', 'project_order.project_id', 'project_order.order_no','project_order.created_at' ,'project.title_'.$this->lang.' as title', 'project_order.payment_id')
            ->join('project', 'project_order.project_id', '=', 'project.id')
            ->get();
        $this->success($list);
    }

    //兑换记录点数明细
    public function pointMsg(){
        $uid = Input::get('id') ?? 0;
        $list = Db::table('msg')->where('uid',$uid)->where('type',0)->get(['id','title_'.$this->lang.' as title','remark_'.$this->lang.' as remark','create_time','point','flag']);
        $this->success($list);
    }

    public function couponList(){
        $id = Input::get('id') ?? 0;
        $list = Db::table('user_coupon as uc')->join('user as u','uc.uid','=','u.id')->where('uc.type',1)->where('uc.status',1)->where('uc.cpid',$id)
                ->orderBy('uc.id','desc')->get(['uid','u.name','u.avatar','u.account','uc.update_time','uc.store_id']);
        $this->success($list);
    }

    public function edituser(){
        $id = Input::get('id') ?? 0;
        $data['level'] = Input::get('level') ?? 1;
        $data['name'] = Input::get('name') ?? '';
        $data['avatar'] = Input::get('avatar') ?? '';
        Db::table('user')->where('id',$id)->update($data);
        $this->success('',$this->l['operation_success']);
    }

    public function refundOrder(){
        $id = Input::get('id') ?? 0;
        if(!$id){
            $this->failed('error');
        }

        $order = Db::table('order')->where('id',$id)->first();
        Db::table('order')->where('id',$id)->update(['status' => 9]);

        $buyDay = Carbon::parse($order->finish_time)->toDateString();

        $analyzeData = Db::table('analyze')->where('sid',$order->sid)->whereDate('date', $buyDay)->first();
        $updateData = [
            'num' => $analyzeData->num - 1,
            'money' => $analyzeData->money > 0 ? $analyzeData->money - $order->money : 0
        ];
        Db::table('analyze')->where('sid',$order->sid)->whereDate('date', $buyDay)->update($updateData);
        $this->success('success');
    }

    public function refundOrderProject(){
        $id = Input::get('id') ?? 0;

        if(!$id){
            $this->failed('error');
        }

        $order = Db::table('project_order')->where('id',$id)->first();
        Db::table('project_order')->where('id',$id)->update(['status' => 9]);
        Db::table('user_coupon')->where('id', $order->coupon_id)->update(['status' => 9]);

        $this->success('success');
    }

}
