<?php
/**
 * 商品控制器
 * @author  lipan
 * @date 2022-12-12
 */
namespace App\Http\Controllers\Admin;
use App\Http\Controllers\BaseController;
use App\Repositories\Business\Item\ItemRepository;
use Illuminate\Http\Request;

class ItemController extends BaseController{

    //增加商品
    public function add(Request $request, ItemRepository $itemRepository){
        
        $params = $request->post();
        $lang   = $request->post("lang","tc");

        $this->checkParams($params,$lang);

        $id = $itemRepository->add($params,$lang);

        $id ? $this->success(trans('msg.operate_success',[],$lang)) :$this->failed(trans('msg.operate_failed',[],$lang));
    }

    //删除商品
    public function del(Request $request, ItemRepository $itemRepository){
        $id = $request->post("item_id");
        $lang   = $request->post("lang","tc");
        if(empty($id))
            $this->failed(trans('msg.item_id_empty',[],$lang));

        $bool = $itemRepository->del($id,$lang);

        $bool ? $this->success(trans('msg.operate_success',[],$lang)) :$this->failed(trans('msg.operate_failed',[],$lang));
    }

    //修改商品
    public function edit(Request $request, ItemRepository $itemRepository){
        $params = $request->post();
        $id     = $request->post("item_id");
        $lang   = $request->post("lang","tc");

        if(empty($id))
            $this->failed(trans('msg.item_id_empty',[],$lang));

        $this->checkParams($params,$lang);

        $bool   = $itemRepository->edit($id,$params,$lang);

        $bool ? $this->success(trans('msg.operate_success',[],$lang)) :$this->failed(trans('msg.operate_failed',[],$lang));

    }


    //设置上下架状态
    public function setStatus(Request $request, ItemRepository $itemRepository){
        $id     = $request->post("item_id");
        $status = $request->post("status");
        $lang   = $request->post("lang","tc");
        if(empty($id))
            $this->failed(trans('msg.item_id_empty',[],$lang));

        $bool   = $itemRepository->setStatus($id,$status,$lang);

        $bool ? $this->success(trans('msg.operate_success',[],$lang)) :$this->failed(trans('msg.operate_failed',[],$lang));
    }



    //查询商品列表
    public function list(Request $request, ItemRepository $itemRepository){
        $params                   = $request->query();
        $params["page"]           = $request->get("page");
        $params["cid"]            = $request->get("cid");
        $params["page_nums"]      = $request->get("page_nums");
        $params["lang"]           = $request->get("lang","tc");

        //$data["field"]          = $request->get("field","created_time");
        //$data["sort"]           = $request->get("sort","desc");

        $list = $itemRepository->list($params);
        $this->success($list);
    }


    //查询商品详情
    public function info(Request $request, ItemRepository $itemRepository){
        $id     = $request->get("item_id");
        $lang   = $request->get("lang","tc");
        if(empty($id))
            $this->failed(trans('msg.item_id_empty',[],$lang));

        $info   = $itemRepository->info($id,$lang);

        $this->success($info);
    }

    //检验入参
    protected function checkParams($params,$lang){

        if(!in_array($lang,config("app.lang")))
            $this->failed(trans('msg.lang_no_exist',[],$lang));

        if(!isset($params["cat_id"]) || empty($params["cat_id"]))
            $this->failed(trans('msg.cat_id_empty',[],$lang));

        if(!isset($params["title"]) || empty($params["title"]))
            $this->failed(trans('msg.title_empty',[],$lang));

        if(!isset($params["sub_title"]) || empty($params["sub_title"]))
            $this->failed(trans('msg.sub_title_empty',[],$lang));

        if(!isset($params["cover_url"]) || empty($params["cover_url"]))
            $this->failed(trans('msg.sub_title_empty',[],$lang));

        if(!isset($params["images"]) || empty($params["images"]))
            $this->failed(trans('msg.images_empty',[],$lang));

        // if(!isset($params["price"]) || empty($params["price"]))
        //     $this->failed(trans('msg.price_empty',[],$lang));

        // if(!isset($params["del_price"]) || empty($params["del_price"]))
        //     $this->failed(trans('msg.del_price_empty',[],$lang));

        if(!isset($params["desc"]) || empty($params["desc"]))
            $this->failed(trans('msg.desc_empty',[],$lang));

        if(!isset($params["status"]))
            $this->failed(trans('msg.status_empty',[],$lang));

        //增加一个对shulist选取的检查
        $itemRepository = new ItemRepository();
        $bool = $itemRepository->checkSkuList($params["cat_id"],$params["skuList"]);
        if(!$bool)
            $this->failed(trans('msg.prop_id_nochoose_full',[],$lang));
    }
}