<?php
/**
 * 配料控制器
 * @author  lipan
 * @date 2022-12-12
 */
namespace App\Http\Controllers\Admin;
use App\Http\Controllers\BaseController;
use App\Repositories\Business\Item\MixedRepository;
use Illuminate\Http\Request;

class MixedController extends BaseController{

    //增加mixed
    public function add(Request $request, MixedRepository $mixedRepository){
        $params = $request->post();
        $lang   = $request->post("lang","tc");

        $this->checkParams($params,$lang);

        $id = $mixedRepository->add($params,$lang);

        $id ? $this->success(trans('msg.operate_success',[],$lang)) :$this->failed(trans('msg.operate_failed',[],$lang));

    }

    //删除mixed
    public function del(Request $request, MixedRepository $mixedRepository){
        $id     = $request->post("id");
        $lang   = $request->post("lang","tc");
        if(empty($id))
            $this->failed("id不能为空");

        $bool   = $mixedRepository->del($id,$lang);

        $bool ? $this->success(trans('msg.operate_success',[],$lang)) :$this->failed(trans('msg.operate_failed',[],$lang));

    }

    //修改mixed
    public function edit(Request $request, MixedRepository $mixedRepository){
        $params = $request->post();
        $id     = $request->post("id");
        $lang   = $request->post("lang","tc");

        if(empty($id))
            $this->failed(trans('msg.id_empty',[],$lang));

        $this->checkParams($params,$lang,'edit');

        $bool   = $mixedRepository->edit($id,$params,$lang);

        $bool ? $this->success(trans('msg.operate_success',[],$lang)) :$this->failed(trans('msg.operate_failed',[],$lang));

    }

    //查询mixed
    public function list(Request $request, MixedRepository $mixedRepository){

        $params                   = $request->query();
        $params["page"]           = $request->get("page");
        $params["page_nums"]      = $request->get("page_nums");
        $params["lang"]           = $request->get("lang","tc");
        //$data["field"]          = $request->get("field","created_time");
        //$data["sort"]           = $request->get("sort","desc");

        $list = $mixedRepository->list($params);
        $this->success($list);
    }

    //检验入参
    protected function checkParams($params,$lang,$type="add"){
        if(!in_array($lang,config("app.lang")))
            $this->failed(trans('msg.lang_no_exist',[],$lang));

        if($type == "add")
        {
            if(!isset($params["title_tc"]) || empty($params["title_tc"]))
                $this->failed(trans('msg.title_empty',[],$lang));
            if(!isset($params["title_en"]) || empty($params["title_en"]))
                $this->failed(trans('msg.title_empty',[],$lang));
        }
        else{
            if(!isset($params["title"]) || empty($params["title"]))
                $this->failed(trans('msg.title_empty',[],$lang));
        }


        if(!isset($params["price"]) || empty($params["price"]))
            $this->failed(trans('msg.price_empty',[],$lang));
    }
}