<?php
/**
 * 方案控制器
 * @author  lipan
 * @date 2022-12-12
 */
namespace App\Http\Controllers\Admin;
use App\Http\Controllers\BaseController;
use App\Repositories\Business\Item\ProjectRepository;
use Illuminate\Http\Request;

class ProjectController extends BaseController{

    //增加banner
    public function add(Request $request, ProjectRepository $projectRepository){
        $params = $request->post();
        $lang   = $request->post("lang","tc");

        $this->checkParams($params,$lang);

        $id = $projectRepository->add($params,$lang);

        $id ? $this->success(trans('msg.operate_success',[],$lang)) :$this->failed(trans('msg.operate_failed',[],$lang));

    }

    //删除banner
    public function del(Request $request, ProjectRepository $projectRepository){
        $id     = $request->post("id");
        $lang   = $request->post("lang","tc");
        if(empty($id))
            $this->failed("id不能为空");

        $bool   = $projectRepository->del($id,$lang);

        $bool ? $this->success(trans('msg.operate_success',[],$lang)) :$this->failed(trans('msg.operate_failed',[],$lang));

    }

    //修改banner
    public function edit(Request $request, ProjectRepository $projectRepository){
        $params = $request->post();
        $id     = $request->post("id");
        $lang   = $request->post("lang","tc");

        if(empty($id))
            $this->failed(trans('msg.id_empty',[],$lang));

        $this->checkParams($params,$lang);

        $bool   = $projectRepository->edit($id,$params,$lang);

        $bool ? $this->success(trans('msg.operate_success',[],$lang)) :$this->failed(trans('msg.operate_failed',[],$lang));

    }

    //查询banner
    public function list(Request $request, ProjectRepository $projectRepository){
        
        $params                   = $request->query();
        $params["page"]           = $request->get("page");
        $params["page_nums"]      = $request->get("page_nums");
        $params["lang"]           = $request->get("lang","tc");
        //$data["field"]          = $request->get("field","created_time");
        //$data["sort"]           = $request->get("sort","desc");

        $list = $projectRepository->list($params);
        $this->success($list);
    }

    //检验入参
    protected function checkParams($params,$lang){
        if(!in_array($lang,config("app.lang")))
            $this->failed(trans('msg.lang_no_exist',[],$lang));

        if(!isset($params["title"]) || empty($params["title"]))
            $this->failed(trans('msg.ptitle_empty',[],$lang));
        if(!isset($params["sub_title"]) || empty($params["sub_title"]))
            $this->failed(trans('msg.psub_title_empty',[],$lang));
        if(!isset($params["price"]) || empty($params["price"]))
            $this->failed(trans('msg.pprice_empty',[],$lang));//todo 价格的输入还需要验证

        if(!isset($params["img"]) || empty($params["img"]))
            $this->failed(trans('msg.pimg_empty',[],$lang));
        if(!isset($params["cups"]) || empty($params["cups"]))
            $this->failed(trans('msg.pcups_empty',[],$lang));
        if(!isset($params["ids"]) || empty($params["ids"]))
            $this->failed(trans('msg.item_ids_empty',[],$lang));
        if(!isset($params["series"]) || empty($params["series"]))
            $this->failed(trans('msg.pseries_empty',[],$lang));
        // if(!isset($params["condition"]) || empty($params["condition"]))
            // $this->failed(trans('msg.pcondition_empty',[],$lang));
        if(!isset($params["start_date"]) || empty($params["start_date"]))
            $this->failed(trans('msg.start_date_empty',[],$lang));
        if(!isset($params["end_date"]) || empty($params["end_date"]))
            $this->failed(trans('msg.end_date_empty',[],$lang));

        if(!isset($params["status"]))
            $this->failed(trans('msg.pstatus_empty',[],$lang));

    }
}