<?php
/**
 * 多规格属性控制器
 * @author  lipan
 * @date 2022-12-12
 */
namespace App\Http\Controllers\Admin;
use App\Http\Controllers\BaseController;
use App\Repositories\Business\Item\PropRepository;
use App\Repositories\Business\Item\SkuRepository;
use Illuminate\Http\Request;

class PropController extends BaseController{

    //增加规格
    public function add(Request $request, PropRepository $propRepository){
        $params = $request->post();
        $lang   = $request->post("lang","tc");
        $this->checkParams($params,$lang);
        $id     = $propRepository->add($params,$lang);

        $id ? $this->success(trans('msg.operate_success',[],$lang)) :$this->failed(trans('msg.operate_failed',[],$lang));

    }

    //删除规格
    public function del(Request $request, PropRepository $propRepository){
        $id     = $request->post("prop_id");
        $lang   = $request->post("lang","tc");

        if(empty($id))
            $this->failed(trans('msg.id_empty',[],$lang));

        $id = $propRepository->del($id,$lang);

        $id ? $this->success(trans('msg.operate_success',[],$lang)) :$this->failed(trans('msg.operate_failed',[],$lang));
    }

    //修改规格
    public function edit(Request $request, PropRepository $propRepository){
        $params = $request->post();
        $id     = $request->post("prop_id");
        $lang   = $request->post("lang","tc");
        if(empty($id))
            $this->failed(trans('msg.id_empty',[],$lang));

        $this->checkParams($params,$lang,"edit");
        $bool   = $propRepository->edit($id,$params,$lang);

        $bool ? $this->success(trans('msg.operate_success',[],$lang)) :$this->failed(trans('msg.operate_failed',[],$lang));
    }

    //查询规格
    public function list(Request $request, PropRepository $propRepository){

        $params                   = $request->query();
        $params["page"]           = $request->get("page");
        $params["page_nums"]      = $request->get("page_nums");
        $params["lang"]           = $request->get("lang","tc");

        if(!isset($params["cat_id"]) || empty($params["cat_id"]))
            $this->failed(trans('msg.cat_id_empty',[],$params["lang"]));

        //$data["field"]          = $request->get("field","created_time");
        //$data["sort"]           = $request->get("sort","desc");

        $list = $propRepository->list($params);
        $this->success($list);
    }

    //检验入参
    protected function checkParams($params,$lang,$type="add"){

        if(!in_array($lang,config("app.lang")))
            $this->failed(trans('msg.lang_no_exist',[],$lang));

        if($type == 'add')
        {
            if(!isset($params["cat_id"]) || empty($params["cat_id"]))
                $this->failed(trans('msg.cat_id_empty',[],$lang));
            if(!isset($params["prop_name_tc"]) || empty($params["prop_name_tc"]))
                $this->failed(trans('msg.prop_name_empty',[],$lang));

            if(!isset($params["prop_name_en"]) || empty($params["prop_name_en"]))
                $this->failed(trans('msg.prop_name_empty',[],$lang));
        }
        else
            if(!isset($params["prop_name"]) || empty($params["prop_name"]))
                $this->failed(trans('msg.prop_name_empty',[],$lang));

    }
}