<?php
/**
 * 多规格属性值控制器
 * @author  lipan
 * @date 2022-12-12
 */
namespace App\Http\Controllers\Admin;
use App\Http\Controllers\BaseController;
use App\Repositories\Business\Item\PropValueRepository;
use Illuminate\Http\Request;

class PropValueController extends BaseController{

    //增加属性值
    public function add(Request $request, PropValueRepository $propValueRepository){
        $params = $request->post();
        $lang   = $request->post("lang","tc");
        $this->checkParams($params,$lang);

        $id     = $propValueRepository->add($params,$lang);
        $id ? $this->success(trans('msg.operate_success',[],$lang)) :$this->failed(trans('msg.operate_failed',[],$lang));
    }

    //删除属性值
    public function del(Request $request, PropValueRepository $propValueRepository){
        $id     = $request->post("prop_value_id");
        $lang   = $request->post("lang","tc");
        if(empty($id))
            $this->failed(trans('msg.id_empty',[],$lang));

        $bool  = $propValueRepository->del($id,$lang);

        $bool ? $this->success(trans('msg.operate_success',[],$lang)) :$this->failed(trans('msg.operate_failed',[],$lang));
    }

    //修改属性值
    public function edit(Request $request, PropValueRepository $propValueRepository){
        $params = $request->post();
        $id     = $request->post("prop_value_id");
        $lang   = $request->post("lang","tc");
        if(empty($id))
            $this->failed(trans('msg.id_empty',[],$lang));

        $this->checkParams($params,$lang,"edit");
        $bool   = $propValueRepository->edit($id,$params,$lang);

        $bool ? $this->success(trans('msg.operate_success',[],$lang)) :$this->failed(trans('msg.operate_failed',[],$lang));
    }

    //查询属性值
    public function list(Request $request, PropValueRepository $propValueRepository){

        $params                   = $request->query();
        $params["page"]           = $request->get("page");
        $params["page_nums"]      = $request->get("page_nums");
        $params["lang"]           = $request->get("lang","tc");

        if(!isset($params["prop_id"]) || empty($params["prop_id"]))
            $this->failed(trans('msg.prop_id_empty',[],$params["lang"]));

        //$data["field"]          = $request->get("field","created_time");
        //$data["sort"]           = $request->get("sort","desc");

        $list = $propValueRepository->list($params);
        $this->success($list);
    }

    //检验入参
    protected function checkParams($params,$lang,$type="add"){

        if(!in_array($lang,config("app.lang")))
            $this->failed(trans('msg.lang_no_exist',[],$lang));

        if($type == "add")
        {
            if(!isset($params["prop_id"]) || empty($params["prop_id"]))
                $this->failed(trans('msg.prop_id_empty',[],$lang));

            if(!isset($params["prop_value_tc"]) || empty($params["prop_value_tc"]))
                $this->failed(trans('msg.prop_value_empty',[],$lang));

            if(!isset($params["prop_value_en"]) || empty($params["prop_value_en"]))
                $this->failed(trans('msg.prop_value_empty',[],$lang));
        }
        else
            if(!isset($params["prop_value"]) || empty($params["prop_value"]))
                $this->failed(trans('msg.prop_value_empty',[],$lang));
    }
}