<?php
/**
 * 隐私协议控制器
 * @author  lipan
 * @date 2022-12-12
 */
namespace App\Http\Controllers\Admin;
use App\Http\Controllers\BaseController;
use App\Repositories\Business\Item\ProtocolRepository;
use Illuminate\Http\Request;

class ProtocolController extends BaseController{

    //增加隐私政策
    public function add(Request $request, ProtocolRepository $protocolRepository){
        $params = $request->post();
        $lang   = $request->post("lang","tc");

        $this->checkParams($params,$lang);

        $id = $protocolRepository->add($params,$lang);

        $id ? $this->success(trans('msg.operate_success',[],$lang)) :$this->failed(trans('msg.operate_failed',[],$lang));
    }

    //删除隐私政策
    public function del(Request $request, ProtocolRepository $protocolRepository){
        $id     = $request->post("id");
        $lang   = $request->post("lang","tc");
        if(empty($id))
            $this->failed("id不能为空");

        $bool   = $protocolRepository->del($id,$lang);

        $bool ? $this->success(trans('msg.operate_success',[],$lang)) :$this->failed(trans('msg.operate_failed',[],$lang));
    }

    //修改隐私政策
    public function edit(Request $request, ProtocolRepository $protocolRepository){
        $params = $request->post();
        $id     = $request->post("id");
        $lang   = $request->post("lang","tc");

        if(empty($id))
            $this->failed(trans('msg.id_empty',[],$lang));

        $this->checkEditParams($params,$lang);

        $bool   = $protocolRepository->edit($id,$params,$lang);

        $bool ? $this->success(trans('msg.operate_success',[],$lang)) :$this->failed(trans('msg.operate_failed',[],$lang));
    }

    //查询隐私政策
    public function info(Request $request, ProtocolRepository $protocolRepository){

        $lang = $request->get("lang","tc");

        $info = $protocolRepository->info($lang);
        $this->success($info);
    }

    // 操作手冊
    public function operationManualEdit(Request $request, ProtocolRepository $protocolRepository)
    {
        $params = $request->post();
        $lang = $request->get("lang","tc");

        $protocolRepository->editManual($id=1,$request->all(), $lang);

        $this->success(trans('msg.operate_success',[],$lang));
    }

    // 操作手冊查詢
    public function operationManualEditInfo(Request $request, ProtocolRepository $protocolRepository){
        $lang   = $request->get("lang","tc");
        $id     = $request->post("id");
        $operation = $protocolRepository->manual($id=1,$lang);
        $this->success($operation);
    }

    // app 更新進版
    public function appUpdate(Request $request, ProtocolRepository $protocolRepository)
    {
        $params = $request->post();
        $lang = $request->get("lang","tc");

        // $protocolRepository->editManual($id=1,$request->all(), $lang);

        $this->success(trans('msg.operate_success',[],$lang));
    }


    //检验入参
    protected function checkParams($params,$lang){
        if(!in_array($lang,config("app.lang")))
            $this->failed(trans('msg.lang_no_exist',[],$lang));

        if(!isset($params["use_remark"]) || empty($params["use_remark"]))
            $this->failed(trans('msg.use_remark_empty',[],$lang));

        if(!isset($params["protocol_desc"]) || empty($params["protocol_desc"]))
            $this->failed(trans('msg.protocol_desc_empty',[],$lang));

        if(!isset($params["faq"]) || empty($params["faq"]))
            $this->failed(trans('msg.faq_empty',[],$lang));

        if(!isset($params["service"]) || empty($params["service"]))
            $this->failed(trans('msg.service_empty',[],$lang));

        if(!isset($params["app_version"]) || empty($params["app_version"]))
            $this->failed(trans('msg.app_version_empty',[],$lang));
        if(!isset($params["app_url"]) || empty($params["app_url"]))
            $this->failed(trans('msg.app_url_empty',[],$lang));
        if(!isset($params["app_update_time"]) || empty($params["app_update_time"]))
            $this->failed(trans('msg.app_update_time_empty',[],$lang));

    }


    //检验入参
    protected function checkEditParams($params,$lang){
        if(!in_array($lang,config("app.lang")))
            $this->failed(trans('msg.lang_no_exist',[],$lang));

        if(isset($params["use_remark"]) && empty($params["use_remark"]))
            $this->failed(trans('msg.use_remark_empty',[],$lang));

        if(isset($params["protocol_desc"]) && empty($params["protocol_desc"]))
            $this->failed(trans('msg.protocol_desc_empty',[],$lang));

        if(isset($params["faq"]) && empty($params["faq"]))
            $this->failed(trans('msg.faq_empty',[],$lang));

        if(isset($params["service"]) && empty($params["service"]))
            $this->failed(trans('msg.service_empty',[],$lang));

        if(isset($params["app_version"]) && empty($params["app_version"]))
            $this->failed(trans('msg.app_version_empty',[],$lang));
        if(isset($params["app_url"]) && empty($params["app_url"]))
            $this->failed(trans('msg.app_url_empty',[],$lang));
        if(isset($params["app_update_time"]) && empty($params["app_update_time"]))
            $this->failed(trans('msg.app_update_time_empty',[],$lang));


        if( !isset($params["use_remark"]) && !isset($params["protocol_desc"]) && !isset($params["faq"]) && 
            !isset($params["service"]) && !isset($params["is_lian"]) &&
            !isset($params["app_version"]) && !isset($params["app_url"]) && !isset($params["app_update_time"]))
        {
            $this->failed(trans('msg.operate_failed',[],$lang));
        }

    }
}