<?php
/**
 * 店铺控制器
 * @author  lipan
 * @date 2022-12-12
 */
namespace App\Http\Controllers\Admin;
use App\Http\Controllers\BaseController;
use App\Repositories\Business\Item\StoreRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class StoreController extends BaseController{

    //增加
    public function add(Request $request, StoreRepository $storeRepository){
        $params = $request->post();
        $lang   = $request->post("lang","tc");
        
        // 檢查帳號重複
        $storeUser = DB::table('clerk')->where( 'account', $params['account'])->first();
        if($storeUser){
            $this->failed($this->l['account_reapet']);
        }

        $this->checkParams($params,$lang);

        $id = $storeRepository->add($params,$lang);

        $id ? $this->success(trans('msg.operate_success',[],$lang)) :$this->failed(trans('msg.operate_failed',[],$lang));

    }

    //删除
    public function del(Request $request, StoreRepository $storeRepository){
        $id     = $request->post("id");
        $lang   = $request->post("lang","tc");
        if(empty($id))
            $this->failed("id不能为空");

        $bool   = $storeRepository->del($id,$lang);

        $bool ? $this->success(trans('msg.operate_success',[],$lang)) :$this->failed(trans('msg.operate_failed',[],$lang));

    }

    //修改
    public function edit(Request $request, StoreRepository $storeRepository){
        $params = $request->post();
        $id     = $request->post("id");
        $lang   = $request->post("lang","tc");

        if(empty($id))
            $this->failed(trans('msg.id_empty',[],$lang));

        $this->checkParams($params,$lang);

        $bool   = $storeRepository->edit($id,$params,$lang);

        $bool ? $this->success(trans('msg.operate_success',[],$lang)) :$this->failed(trans('msg.operate_failed',[],$lang));

    }


    //设置状态
    public function setStatus(Request $request, StoreRepository $storeRepository){
        $id     = $request->post("id");
        $status = $request->post("status");
        $lang   = $request->post("lang","tc");
        if(empty($id))
            $this->failed(trans('msg.item_id_empty',[],$lang));

        $bool   = $storeRepository->setStatus($id,$status,$lang);

        $bool ? $this->success(trans('msg.operate_success',[],$lang)) :$this->failed(trans('msg.operate_failed',[],$lang));
    }


    //查询
    public function list(Request $request, StoreRepository $storeRepository){

        $params                   = $request->query();
        $params["key"]            = $request->get("key");
        $params["page"]           = $request->get("page");
        $params["page_nums"]      = $request->get("page_nums");
        $params["lang"]           = $request->get("lang","tc");
        //$data["field"]          = $request->get("field","created_time");
        //$data["sort"]           = $request->get("sort","desc");

        $list = $storeRepository->list($params);
        $this->success($list);
    }

    //检验入参
    protected function checkParams($params,$lang){
        if(!in_array($lang,config("app.lang")))
            $this->failed(trans('msg.lang_no_exist',[],$lang));

        if(!isset($params["name"]) || empty($params["name"]))
            $this->failed(trans('msg.sname_empty',[],$lang));
        //if(!isset($params["open_start"]) || empty($params["open_start"]))
            //$this->failed(trans('msg.sopen_start_empty',[],$lang));
        //if(!isset($params["open_end"]) || empty($params["open_end"]))
            //$this->failed(trans('msg.sopen_end_empty',[],$lang));
        if(!isset($params["address"]) || empty($params["address"]))
            $this->failed(trans('msg.address_empty',[],$lang));
        if(!isset($params["latitude"]) || empty($params["latitude"]))
            $this->failed(trans('msg.latitude_empty',[],$lang));
        if(!isset($params["longitude"]) || empty($params["longitude"]))
            $this->failed(trans('msg.longitude_empty',[],$lang));

        if(!isset($params["status"]))
            $this->failed(trans('msg.pstatus_empty',[],$lang));
    }
}