<?php

/**
 * 后台基础控制器
 */
namespace App\Http\Controllers;

use Curl\Curl;
use Exception;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;


header('Access-Control-Allow-Origin:*');
header('Access-Control-Allow-Methods:POST, GET, OPTIONS, PUT, DELETE');
header('Access-Control-Allow-Headers:Origin, X-Requested-With, Content-Type, Accept, token');

class BaseController  extends Controller
{

    private $curl;
    protected $l;
    protected $lang;

    public function __construct(Request $request)
    {
        if("OPTIONS" == $request->method())//过滤掉嗅探请求
            $this->failed("请求方式不合法");
  
        $lang = $request->header("lang");
        $lh = $request->header("lang");
        $lg = $lp = '';
        if(empty($lang)){
            $lg = $request->get("lang");
            $lp = $request->post("lang");
            if(empty($lg) && empty($lp)){
                $lang = 'tc';
            }else{
                if(!empty($lg)){
                    $lang = $lg;
                }
                if(!empty($lp)){
                    $lang = $lp;
                }

            }
        }
            	
        // Log::stack(['daily'])->info("语言变量", ['lang'=>$lang,'lh'=>$lh,'lg'=>$lg,'lp'=>$lp]);    	
        $this->lang = $lang;
        $this->l = config($lang);
    }

    /**
     * 失败响应
     * @param $msg
     * @param int $code
     */
    public function failed($msg="failed",$data = [])
    {
        $data = [
            "msg"   => $msg,
            "code"  => 4000,
            "data"  => $data,
            "time"  => date("Y-m-d H:i:s")
        ];

        throw new HttpResponseException(response()->json($data));
    }

    /**
     * 成功响应
     * @param $data
     * @param int $code
     * @param string $msg
     */
    public function success($data = [],$msg="success")
    {
        $data = [
            "msg"   => $msg,
            "code"  => 2000,
            "data"  => $data,
            "time"  => date("Y-m-d H:i:s")
        ];

        throw new HttpResponseException(response()->json($data));
    }

    /**
     * 抛出异常
     * @param $msg
     * @throws Exception
     */
    public function excption($msg){
        throw new Exception($msg);
    }


    /**
     * 获取结果
     * @param $url
     * @param $post
     * @return mixed
     * @throws Exception
     */
    public function getResult($url,$requestData = NULL,$requestType = "post")
    {
        $data = !empty($requestData) ? $requestData:NULL;

        $this->curl = new Curl();
        $this->curl->setOpt(CURLOPT_SSL_VERIFYPEER, false);
        $this->curl->setOpt(CURLOPT_SSL_VERIFYHOST, false);

        $res    = $requestType == "get" ? $this->curl->get($url, $data) : $this->curl->post($url, $data);

        if ($this->curl->error)
            throw new Exception($this->curl->errorMessage);

        $res = is_object($res) ? $this->object_to_array($res) : json_decode($res, true);

        return $res;
    }

    /**
     * 对象转数组
     * @param $object
     * @return mixed
     */
    public function object_to_array(&$object){
        $object = json_decode(json_encode($object),true);
        return  $object;
    }



    /**
     * 数组转树形结构
     * @param $object
     * @return mixed
     */
    public function tree_shape($arr)
    {
        $data = [];
        foreach ($arr as $v) {
            $data[$v['id']] = $v;
        }
        $newArr = [];
        foreach ($data as $k => $v) {
            if ($v['cid'] > 0) {
                $data[$v['cid']]['children'][] = &$data[$k];
            } else {
                $newArr[] = &$data[$k];
            }
        }
        return $newArr;
    }

    /**
     * 部门数组转树形结构
     * @param $object
     * @return mixed
     */
    public function department_shape($arr)
    {
        $data = [];
        foreach ($arr as $v) {
            $data[$v['id']] = $v;
        }
        $newArr = [];
        foreach ($data as $k => $v) {
            if ($v['pid'] > 0) {
                $data[$v['pid']]['children'][] = &$data[$k];
            } else {
                $newArr[] = &$data[$k];
            }
        }
        return $newArr;
    }

    /**
     * 将多个一维数组合拼成二维数组
     * @param $object
     * @return mixed
     */
    public function array_merge_more($keys, ...$arrs)
    {
        // 检查参数是否正确
        if (!$keys || !is_array($keys) || !$arrs || !is_array($arrs) || count($keys) != count($arrs)) {
            return array();
        }
        // 一维数组中最大长度
        $max_len = 0;
        // 整理数据，把所有一维数组转重新索引
        for ($i = 0, $len = count($arrs); $i < $len; $i++) {
            $arrs[$i] = array_values($arrs[$i]);

            if (count($arrs[$i]) > $max_len) {
                $max_len = count($arrs[$i]);
            }
        }
        // 合拼数据
        $result = array();
        for ($i = 0; $i < $max_len; $i++) {
            $tmp = array();
            foreach ($keys as $k => $v) {
                if (isset($arrs[$k][$i])) {
                    $tmp[$v] = $arrs[$k][$i];
                }
            }
            $result[] = $tmp;
        }
        return $result;
    }

    /**
     * 随机字符串
     *
     * @param $len
     * @param null $chars
     * @return string
     */
    public static function getRandomString($len)
    {
        $chars = "abcdefghijklmnopqrstuvwxyz0123456789";
        mt_srand(10000000*(double)microtime());
        for ($i = 0, $str = '', $lc = strlen($chars)-1; $i < $len; $i++) {
            $str .= $chars[mt_rand(0, $lc)];
        }
        return $str;
    }

    public function exportExcel($expTitle,$expCellName,$expTableData){
        require_once app_path().'/Libraries/phpexcel/PHPExcel.php';
        $xlsTitle = iconv('utf-8', 'gb2312', $expTitle);//文件名称
        $fileName = $expTitle.date('_YmdHis');//or $xlsTitle 文件名称可根据自己情况设定
        $cellNum = count($expCellName);
        $dataNum = count($expTableData);
        //$objPHPExcel = new PHPExcel();//方法一
        $objPHPExcel = new \PHPExcel();//方法二
        $cellName = array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z','AA','AB','AC','AD','AE','AF','AG','AH','AI','AJ','AK','AL','AM','AN','AO','AP','AQ','AR','AS','AT','AU','AV','AW','AX','AY','AZ');
        $objPHPExcel->getActiveSheet(0)->mergeCells('A1:'.$cellName[$cellNum-1].'1');//合并单元格
        $objPHPExcel->setActiveSheetIndex(0)->setCellValue('A1', $expTitle.' '.date('Y-m-d H:i:s'));
        for($i=0;$i<$cellNum;$i++){
            $objPHPExcel->setActiveSheetIndex(0)->setCellValue($cellName[$i].'2', $expCellName[$i][1]);
        }
        // Miscellaneous glyphs, UTF-8
        for($i=0;$i<$dataNum;$i++){
            for($j=0;$j<$cellNum;$j++){
                $objPHPExcel->getActiveSheet(0)->setCellValue($cellName[$j].($i+3), $expTableData[$i][$expCellName[$j][0]]);
            }
        }
        ob_end_clean();//这一步非常关键，用来清除缓冲区防止导出的excel乱码
        header('pragma:public');
        header('Content-type:application/vnd.ms-excel;charset=utf-8;name="'.$xlsTitle.'.xlsx"');
        header("Content-Disposition:attachment;filename=\"$fileName\".xlsx");//"xls"参考下一条备注
        $objWriter = \PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');//"Excel2007"生成2007版本的xlsx，"Excel5"生成2003版本的xls
        $objWriter->save('php://output');
        exit;
    }


}
