<?php
/**
 *  用户端控制器
 * author：徐树彬
 * date ：2022-11-16
 */
namespace App\Http\Controllers\Common;


use App\Http\Controllers\BaseController;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;


class HomeController extends BaseController{

    //首页接口
    public function index(){
        $user = Db::table('user')->where('id',UID)->first(['name','account','level','experience','point']);
        $user->level_exper = Db::table('level')->where('id',$user->level)->value('score');

        $exper = Db::table('level')->where('score','>',$user->experience)->orderBy('id','asc')->first();
        
        $user->level = $exper->id;

        // gc_kevin 調整顯示 level 
        if($user->experience > $user->level_exper){
            Db::table('user')->where('id',UID)->update(['level'=>$exper->id,'update_time'=>date('Y-m-d H:i:s')]);
        }

        $user->level_exper = $exper->score;

        $user->coupon_num = Db::table('user_coupon')->where('uid',UID)->where('status',0)->where('type',1)->count();
        $user->new_message = Db::table('notice')->where('uid',UID)->where('read',0)->where('type',3)->count();   
        if($user->new_message == 0){
            $us = Db::table('user')->where('id',UID)->first(['issend','btime','level']);
            if($us->issend == 1){
                $notice = Db::table('notice')->where('flag',1)->where('level','<=',$us->level)->where('create_time','<',$us->btime)->orderBy('create_time','desc')->get(['id','title_'.$this->lang.' as title','remark_'.$this->lang.' as remark','date','flag','link','create_time','img']); 
            }else{
                $notice = Db::table('notice')->where('flag',1)->where('level','<=',$us->level)->orderBy('create_time','desc')->get(['id','title_'.$this->lang.' as title','remark_'.$this->lang.' as remark','date','flag','link','create_time','img']); 
            }
            $num = 0;
            foreach($notice as &$v){
                $data['uid'] = UID;
                $data['aid'] = $v->id;
                $is = Db::table('arci_log')->where($data)->first();
                if(empty($is)){
                    $num++;
                }
            }
            $user->new_message = $num;
        }
        $is_lian = Db::table('protocol')->where('id',1)->value('is_lian');
        $banner = Db::table('banner')->where('status',0)->where('type',1)->orderBy('sort','desc')->get(['banner','url','type','aid'])->toArray();   
        $project = Db::table('banner')->where('status',0)->where('type',0)->orderBy('sort','desc')->get(['banner as img','url','title_'.$this->lang.' as title'])->toArray();   
        // $project = Db::table('project')->where('status',0)->orderBy('create_time','desc')->limit(6)->get(['id','img','title_'.$this->lang.' as title','sub_title_'.$this->lang.' as sub_title','price','url']);      
        $this->success(['user'=>$user,'banner'=>$banner,'project'=>$project,'is_lian'=>$is_lian]);
    }

    //商户列表接口
    public function storeList(){
        $list = Db::table('store')->where('status',0)->get(['name_'.$this->lang.' as name','open_start','open_end','address','latitude','longitude','id','open_date_range','keyword']);   
        // print_r($list);  
        foreach($list as &$v){
            $v->open_date_range = json_decode($v->open_date_range,true);
        }   
        $this->success($list);
    }

    //文章详情接口
    public function arcicle(){
        $aid = Input::get('id');
        $list = Db::table('arcicle')->where('id',$aid)->first(['id','img','start_time','end_time','title_'.$this->lang.' as title','content_'.$this->lang.' as content']);      
        $data['uid'] = UID;
        $data['aid'] = $aid;
        $is = Db::table('arci_log')->where($data)->first();
        if(empty($is)){
            $data['create_time'] = date('Y-m-d H:i:s');
            Db::table('arci_log')->insert($data);
        }
        $this->success($list);
    }

    //分类列表接口
    public function cateList(){
        $list = Db::table('cate')->where('status',0)->orderBy('sort','desc')->get(['id','name_'.$this->lang.' as name'])->toArray();      
        foreach($list as $k=>$v){
            if(empty($v->name)){
                unset($list[$k]);
            }
        }  
        $list = array_values($list);
        $this->success($list);
    }

    //商品列表接口
    public function shopList(){
        $cid = Input::get('cid');
        $sid = Input::get('sid');
        if(empty($cid))
            $this->failed($this->l['param_incomplete']);

        $list = Db::table('item')->where('status',0)->where('cat_id',$cid)->orderBy('sort','desc')
                    ->get(['cover_url as img','price','tags','title_'.$this->lang.' as title','item_id as id','sub_title_'.$this->lang.' as sub_title','desc_'.$this->lang.' as desc'])->toArray();

        $down = DB::table('shop_good')->where('sid',$sid)->pluck('gid')->toArray();
        foreach($list as $k=>&$v){
            if(in_array($v->id,$down)){
                unset($list[$k]);
            }
            if(empty($v->tags)){
                $v->tags = [];
            }else{
                $v->tags = explode(',',$v->tags);  
            } 
        }
        $list = array_values($list);
        $this->success($list);
    }

    //购物车接口
    public function cart(){
        $sid = Input::get('sid');
        $w['uid'] = UID;
        $w['sid'] = $sid;
        // $w['lang'] = $this->lang;
        $w['status'] = 0;
        $cart = Db::table('user_cart')->where($w)->first(['id','money','num','del_money']);
        $cart = (array)$cart;
        if(empty($cart)){
            $w['create_time'] = $w['update_time'] = date('Y-m-d H:i:s');
            $cart['id'] = Db::table('user_cart')->insertGetId($w);
            $cart['money'] = $cart['num'] = $cart['save'] = $cart['del_money'] = 0;
        }else{
            $list = Db::table('cart_goods')->where('ucid',$cart['id'])->where('status',0)->get(['price','num','del_price'])->toArray();
            $num = $del_money = $money = 0;
            foreach($list as $v){
                $num += $v->num;
                $money += ($v->price*$v->num);
                $del_money += ($v->del_price*$v->num);
            }
            $save = round($del_money - $money,2);
            if($save < 0){
                $cart['save'] = 0;
            }else{
                $cart['save'] = $save;
            }
            
            $cart['money'] = $money;
            $cart['num'] = $num;
            $cart['del_money'] = $money;
            Db::table('user_cart')->where('id',$cart['id'])->update(['money'=>$money,'num'=>$num,'del_money'=>$del_money]);
        }
        $this->success($cart);
    }

    //添加到购物车接口
    public function addToCart(){
        $ucid = Input::get('ucid');
        $gid = Input::get('gid');
        $num = Input::get('num');
        $tag = Input::get('tag');
        $price = Input::get('price');
        $msg = Input::get('msg');
        
        $cart = Db::table('user_cart')->where('id',$ucid)->first();
        $cg['ucid'] = $ucid;
        $cg['gid'] = $gid;
        $cg['tag'] = $tag;
        $cg['status'] = 0;
        $cgoods = Db::table('cart_goods')->where($cg)->first();
        if(empty($cgoods)){
            $good = Db::table('item')->where('item_id',$gid)->first(['cover_url','del_price','title_'.$this->lang.' as title']);
            $del_price = $good->del_price;
            $cg['title'] = $good->title;
            $cg['img'] = $good->cover_url;
            $cg['price'] = $price;
            $cg['del_price'] = $del_price;
            $cg['num'] = $num;
            $cg['msg'] = $msg;
            $cg['create_time'] = $cg['update_time'] = date('Y-m-d H:i:s');
            Db::table('cart_goods')->insert($cg);
        }else{
            Db::table('cart_goods')->where('id',$cgoods->id)->increment('num', $num);
            $del_price = $cgoods->del_price;
        }
        $data['money'] = $cart->money + $price*$num;
        $data['del_money'] = $cart->del_money + $del_price*$num;
        $data['num'] = $cart->num+$num;
        $data['update_time'] = date('Y-m-d H:i:s');
        Db::table('user_cart')->where('id',$ucid)->update($data);    
        $this->success('',$this->l['add_success']);
    }

    //加减购物车商品
    public function editCart(){
        $cgid = Input::get('cgid');
        $ucid = Input::get('ucid');
        // $aos = Input::get('aos');

        $num = Input::get('num');
        $tag = Input::get('tag');
        $price = Input::get('price');
        $msg = Input::get('msg');

        $cgs = Db::table('cart_goods')->where('id',$cgid)->where('ucid',$ucid)->first();

        //先清空购物车
        $ucs = Db::table('user_cart')->where('id',$ucid)->first();
        $data['num'] = $ucs->num - $cgs->num;
        $data['money'] = $ucs->money - $cgs->price*$cgs->num;
        $data['del_money'] = $ucs->del_money - $cgs->del_price*$cgs->num;
        Db::table('user_cart')->where('id',$ucid)->update($data);

        //再加上现有规格到购物车
        $carts['num'] = $num;
        $carts['tag'] = $tag;
        $carts['price'] = $price;
        $carts['msg'] = $msg;
        Db::table('cart_goods')->where('id',$cgid)->update($carts);

        $ucss = Db::table('user_cart')->where('id',$ucid)->first();
        $users['num'] = $ucss->num + $num;
        $users['money'] = $ucss->money + $price*$num;
        $users['del_money'] = $ucss->del_money + $cgs->del_price*$num;
        Db::table('user_cart')->where('id',$ucid)->update($users);


        // if($msg->num == 1 && $aos == 2){
        //     $this->failed($this->l['param_incomplete']);
        // }
        // $uc = Db::table('user_cart')->where('id',$ucid)->first();
        // if($aos == 1){
        //     Db::table('cart_goods')->where('id',$cgid)->where('ucid',$ucid)->increment('num');
        //     $data['num'] = $uc->num + 1;
        //     $data['money'] = $uc->money + $msg->price;
        //     $data['del_money'] = $uc->del_money + $msg->del_price;
        //     Db::table('user_cart')->where('id',$ucid)->update($data);
        // }else if($aos == 2){
        //     Db::table('cart_goods')->where('id',$cgid)->where('ucid',$ucid)->decrement('num');
        //     $data['num'] = $uc->num - 1;
        //     $data['money'] = $uc->money - $msg->price;
        //     $data['del_money'] = $uc->del_money - $msg->del_price;
        //     Db::table('user_cart')->where('id',$ucid)->update($data);
        // }
        $this->success('',$this->l['edit_success']);
    }

    //删除购物车商品
    public function delCart(){
        $ucid = Input::get('ucid');
        $cgid = Input::get('cgid');
        if($cgid == 0){
            Db::table('cart_goods')->where('status',0)->where('ucid',$ucid)->update(['status'=>-1]);
            Db::table('user_cart')->where('id',$ucid)->update(['num'=>0,'money'=>0,'del_money'=>0]);
        }else{
            $msg = Db::table('cart_goods')->where('id',$cgid)->first(['num','price','del_price']);
            Db::table('cart_goods')->where('id',$cgid)->update(['status'=>-1]);
            $uc = Db::table('user_cart')->where('id',$ucid)->first();
            $data['num'] = $uc->num - 1;
            $data['money'] = $uc->money - $msg->price;
            $data['del_money'] = $uc->del_money - $msg->del_price;
            Db::table('user_cart')->where('id',$ucid)->update($data);
        }  
        $this->success('',$this->l['del_success']);
    }

    //购物车列表
    public function cartList(){
        $ucid = Input::get('ucid');
        $list = Db::table('cart_goods')->where('ucid',$ucid)->where('status',0)->get(['id','img','title','price','num','tag','gid','msg']);       
        $this->success($list);
    }

    //推荐列表接口
    public function recommmend(){
        $sid = Input::get('sid');
        $list = Db::table('item')->where('status',0)->where('recommend',1)->orderBy('sort','desc')
                ->get(['cover_url as img','price','title_'.$this->lang.' as title','item_id as id','del_price'])->toArray();
        $down = DB::table('shop_good')->where('sid',$sid)->pluck('gid')->toArray();
        if(count($down) > 0){
            foreach($list as $k=>&$v){
                if(in_array($v->id,$down)){
                    unset($list[$k]);
                }
            }
        }
        $list = array_values($list);
        $this->success($list);
    }

    //购物车结算
    public function cartSettlement(){
        $ucid = Input::get('ucid');
        $cartgids = Input::get('cartgids');
        $cgid = explode(',',$cartgids);
        $resu = [];
        $sid = Db::table('user_cart')->where('id',$ucid)->value('sid');
        $resu['store'] = Db::table('store')->where('id',$sid)->first(['name_'.$this->lang.' as name','id','address','now_order','now_cup']);
        $resu['store']->times = $resu['store']->now_cup*2;
        $num = $money = 0;
        foreach($cgid as $c){
            $msg = Db::table('cart_goods')->where('id',$c)->first(['title','img','num','tag','price']);
            $num += $msg->num;
            $money += $msg->num*$msg->price;
            $resu['goods'][] = $msg;
        }
        $resu['count']['num'] = $num;
        $resu['count']['money'] = $money;      
        $this->success($resu);
    }

    public function oauth2callback(){
        $code = Input::get('code');
        $client_id = '921196734926-f85oibif09j4la4n8mpuq43fppvp1569.apps.googleusercontent.com';
        $client_secret = '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';
        $redirect_uri = 'http://ljx.tenghuiwangxiao.com/oauth2callback';
        $data_tmp1 = array(
            'grant_type'=>'authorization_code',
            'code'=>$code,
            'client_id'=>$client_id,
            'client_secret'=>$client_secret,
            'redirect_uri'=>$redirect_uri,
        );
        Log::stack(['daily'])->info("谷歌前", $data_tmp1);
        $refresh_token_url = 'https://accounts.google.com/o/oauth2/token';
        $results = getResult($refresh_token_url,$data_tmp1);	
        Log::stack(['daily'])->info("谷歌后", $results);    	
        print_r($results);
    }

    //通知列表
    public function noticeList(){
        $type = Input::get('type') ?? 0;
        if($type == 0){
            $this->failed($this->l['param_incomplete']);
        }
        if($type == 3){
            $notice = Db::table('notice')->where('uid',UID)->Where('type',3)->orderBy('create_time','desc')->get(['id','read','title_'.$this->lang.' as title','remark_'.$this->lang.' as remark','date','flag','link','create_time','img']); 
        }else{
            $user = Db::table('user')->where('id',UID)->first(['issend','btime','level']);
            if($user->issend == 1){
                $notice = Db::table('notice')->Where('type',$type)->where('level','<=',$user->level)->where('create_time','<',$user->btime)->orderBy('create_time','desc')->get(['id','title_'.$this->lang.' as title','remark_'.$this->lang.' as remark','date','flag','link','create_time','img']); 
            }else{
                $notice = Db::table('notice')->Where('type',$type)->where('level','<=',$user->level)->orderBy('create_time','desc')->get(['id','title_'.$this->lang.' as title','remark_'.$this->lang.' as remark','date','flag','link','create_time','img']); 
            }
            foreach($notice as &$v){
                $data['uid'] = UID;
                $data['aid'] = $v->id;
                $is = Db::table('arci_log')->where($data)->first();
                if(empty($is)){
                    $v->read = 0;
                }else{
                    $v->read = 1;
                }
            }
        }
        $this->success($notice);
    }

    public function readNotice(){
        $ids = Input::get('ids') ?? 0;
        // $type = Input::get('type') ?? 0;  // 0通知  
        if($ids == 0){
            $this->failed($this->l['param_incomplete']);
        }
        if($ids == -1){
            Db::table('notice')->where('uid',UID)->update(['read'=>1]);
        }else{
            $ids = explode(',',$ids);
            Db::table('notice')->where('uid',UID) ->whereIn('id', $ids)->update(['read'=>1]);
        }
        $this->success('',$this->l['operation_success']);
    }

    public function payCallback(){
        $id = Input::get('id') ?? '';
        if(empty($id)){
            $this->failed($this->l['param_incomplete']);
        }
        $order = Db::table('order')->where('id',$id)->first();
        if(empty($order)){
            $this->failed($this->l['parameter_error']);
        }
        //更新订单表
        $data['pay_time'] = date('Y-m-d H:i:s');
        $data['status'] = 1;
        $md = date('md');
        $count = Db::table('order')->where('code','like',$md.'%')->count();
        $count++;
        $pickcode = $md.$count;
        $data['code'] = $pickcode;
        Db::table('order')->where('id',$id)->update($data);
        //是否有优惠券
        if($order->coupon != 0 && $order->payment_id != null){
            Db::table('user_coupon')->where('id',$order->coupon)->update(['status'=>1,'update_time'=>$data['pay_time']]);
            //通知记录
            $notice['uid'] = $order->uid;
            $notice['create_time'] = date('Y-m-d H:i:s');
            $notice['date'] = date('Y-m-d');
            $notice['flag'] = 3;
            $notice['type'] = 3;
            $uc = Db::table('user_coupon')->where('id',$order->coupon)->first();
            $notice['title_tc'] = '優惠券使用通知';
            $notice['remark_tc'] = '您的  "'.$uc->title_tc.'"已使用';
            $notice['title_en'] = 'Coupon use notice';
            $notice['remark_en'] = 'Your "'.$uc->title_en.'" has been used';
            DB::table('notice')->insert($notice);
        }
        $user = Db::table('user')->where('id',$order->uid)->first();
        // $exper = 5;//支付一次获得
        $moneyper = Db::table('exper')->where('id',11)->value('level');//支付多少钱可以活动一经验
        $exper = floor($order->price/$moneyper);
        $upuser['experience'] = $user->experience+$exper;//经验

        // ------------------------加經驗和點數
        // $exper = Db::table('level')->where('score','>',$user->experience)->orderBy('id','asc')->first();
        
        // $user->level = $exper->id;

        // // gc_kevin 調整顯示 level 
        // if($user->experience > $user->level_exper){
        //     Db::table('user')->where('id',UID)->update(['level'=>$exper->id,'update_time'=>date('Y-m-d H:i:s')]);
        // }

        // $user->level_exper = $exper->score;
        // ------------------------------

        // if($user->level != 10){//10级是最高级
        //     $level = $user->level+1; 
        //     $exper = Db::table('level')->where('id',$level)->value('score');
        //     if($exper >= $upuser['experience']){
        //         $upuser['level'] = $level;
        //     }
        // }

        $moneypoint = Db::table('exper')->where('id',12)->value('level');//支付多少钱可以活动一点数
        $point = floor($order->price/$moneypoint);
        if($point != 0){
            //经验获得通知
            $info['title_tc'] = '支付獲得經驗通知';
            $info['title_en'] = 'Invite to receive experience notification';
            $info['point'] = $exper;
            $info['uid'] = $order->uid;
            $info['create_time'] = date('Y-m-d H:i:s');
            $info['type'] = 1;
            $info['flag'] = 0;
            DB::table('msg')->insert($info);
            $upuser['point'] = $user->point+$point;//点数

            //点数获得通知
            $info1['title_tc'] = '支付獲得點數通知';
            $info1['title_en'] = 'Invite to receive point notification';
            $info1['point'] = $point;
            $info1['uid'] = $order->uid;
            $info1['create_time'] = date('Y-m-d H:i:s');
            $info1['type'] = 0;
            $info1['flag'] = 0;
            DB::table('msg')->insert($info1);

            $notice1['uid'] = $order->uid;
            $notice1['create_time'] = date('Y-m-d H:i:s');
            $notice1['date'] = date('Y-m-d');
            $notice1['flag'] = 7;
            $notice1['type'] = 3;
            $notice1['title_tc'] = '支付獲得點數通知';
            $notice1['remark_tc'] = '獲得'.$point.'點，點數餘額'.$upuser['point'].'點';
            $notice1['title_en'] = 'Pay to get point notification';
            $notice1['remark_en'] = 'Get '.$point.' points and the balance is '.$upuser['point'].' points';
            DB::table('notice')->insert($notice1);
        }
        
        $upuser['ordersum'] = $user->ordersum+1;
        $upuser['paysum'] = $user->paysum+$order->price;
        Db::table('user')->where('id',$order->uid)->update($upuser);
        
        $td['date'] = date('Y-m-d');
        $td['sid'] = $order->sid;
        $any = Db::table('analyze')->where($td)->first();
        if(empty($any)){
            $td['num'] = 1;
            $td['money'] = $order->price;
            Db::table('analyze')->insert($td);
        }else{
            Db::table('analyze')->where($td)->increment('num');
            Db::table('analyze')->where($td)->increment('money',$order->price);
        }
        $this->success('',$this->l['operation_success']);
    }

    public function getNearestStore(){
        $lat1 = Input::get('lat');//纬度
        $lng1 = Input::get('lng');//经度
        //将角度转为弧度 

        // $lat1 = '28.34199';
        // $lng1 = '112.98690';

        $list = Db::table('store')->where('status',0)->get(['id','name_'.$this->lang.' as name','latitude','longitude'])->toArray();
        $s = [];
        foreach($list as &$v){
            $v = (array)$v;
            $lat2 = $v['latitude'];
            $lng2 = $v['longitude'];
            $radLat1=deg2rad($lat1);
            $radLat2=deg2rad($lat2);
            $radLng1=deg2rad($lng1);
            $radLng2=deg2rad($lng2);
            $a=$radLat1-$radLat2;//两纬度之差,纬度<90
            $b=$radLng1-$radLng2;//两经度之差纬度<180
            $v['s']=2*asin(sqrt(pow(sin($a/2),2)+cos($radLat1)*cos($radLat2)*pow(sin($b/2),2)))*6378.137;
            $s[] = $v['s'];
        }
        array_multisort($s,SORT_ASC,$list);
        $this->success($list[0]);
    }

    public function protocol(){
        $list = Db::table('protocol')->where('id',1)->first(['use_remark_'.$this->lang.' as use_remark','protocol_desc_'.$this->lang.' as protocol_desc','service_'.$this->lang.' as service','faq_'.$this->lang.' as faq']);
        $this->success($list);
    }

    //文章列表
    public function arcicleList(){
        $notice = Db::table('arcicle')->where('type',0)->Where('status',0)->orderBy('create_time','desc')->get(['id','title_'.$this->lang.' as title','img','create_time'])->toArray(); 
        foreach($notice as $k=>&$v){
            if(empty($v->title)){
                unset($notice[$k]);
            }
            $data['uid'] = UID;
            $data['aid'] = $v->id;
            $is = Db::table('arci_log')->where($data)->first();
            if(empty($is)){
                $v->read = 0;   
            }else{
                $v->read = 1;
            }
        }
        array_values($notice);
        $this->success($notice);
    }

    public function readarcicle(){
        $ids = Input::get('ids') ?? 0;
        if($ids < 1){
            $this->failed($this->l['param_incomplete']);
        }
        $ids = explode(',',$ids);
        foreach($ids as $v){
            $data['uid'] = UID;
            $data['aid'] = $v;
            $is = Db::table('arci_log')->where($data)->first();
            if(empty($is)){
                $data['create_time'] = date('Y-m-d H:i:s');
                Db::table('arci_log')->insert($data);
            }
        }
        $this->success('',$this->l['operation_success']);
    }

    public function levelist(){
        $level = Db::table('level')->orderBy('id','asc')->get(['id','name_'.$this->lang.' as name','img','score','desc1','desc2'])->toArray(); 
        $this->success($level);
    }

    public function getforid(){
        $id = Input::get('id') ?? 0;
        $item = Db::table('item')->where('item_id',$id)->first(['cover_url as img','price','tags','title_'.$this->lang.' as title','item_id as id','sub_title_'.$this->lang.' as sub_title','desc_'.$this->lang.' as desc']);
        if(empty($item->tags)){
            $item->tags = [];
        }else{
            $item->tags = explode(',',$item->tags);  
        } 
        $this->success($item);
    }

    public function getAppVersion(){
        $app = Db::table('protocol')->first();
        $list = [
            'version' => $app->app_version,
            'url' => $app->app_url,
            'lastUpdateTime' => $app->app_update_time,
        ];

        $this->success($list);

    }
}



//http://bbc.xushubin.com/oauth2callback?code=4/0AWgavdcSyhijQKgYIVEHVtbTqYW0CyV9w7LVbiwxuL66zrbpxhwsAV4vtorfccK3v2qXkA&scope=https://www.googleapis.com/auth/androidpublisher

//https://accounts.google.com/o/oauth2/auth?scope=https://www.googleapis.com/auth/androidpublisher&response_type=code&access_type=offline&redirect_uri=http://bbc.xushubin.com/oauth2callback&client_id=385267466334-bpkaj2ce59oh4ttg05po2emflgckheqe.apps.googleusercontent.com

