<?php
/**
 * 商品控制器
 * author：lippan
 * date ：2022-12-23
 */
namespace App\Http\Controllers\Common;


use App\Http\Controllers\BaseController;
use App\Repositories\Business\Item\ItemRepository;
use App\Repositories\Business\Item\MixedRepository;
use App\Repositories\Business\Item\PropRepository;
use Illuminate\Http\Request;


class ItemController extends BaseController{

    //商品详情
    public function info(Request $request,ItemRepository $itemRepository,PropRepository $propRepository,MixedRepository $mixedRepository){
        $id     = $request->get("item_id");
        $lang   = $request->header("lang","tc");
        if(empty($id))
            $this->failed(trans('msg.item_id_empty',[],$lang));

        $info   = $itemRepository->mobileInfo($id,$lang);


        //此时获取分类的规格以及属性
        if(isset($info->cat_id))
        {

            $propList = $propRepository->propList(["cat_id"=>$info->cat_id,"prop_ids"=>$info->prop_ids,"lang"=>$lang],false);
            $info->specList = $propList["list"];
            $info->freeList = $propList["free_list"];
            $info->is_singel = $propList["is_singel"];

            //此处获取 todo 不是这么获取的
            if(isset($info->mixed_ids) && !empty($info->mixed_ids))
            {
                $res = $mixedRepository->getListByIds($info->mixed_ids,$lang);

                $info->mixedList = $res;
            }
            else
                $info->mixedList = [];

        }


        $this->success($info);
    }

    //获取sku详情
//    public function getSkuInfo(Request $request,ItemRepository $itemRepository){
////        $id         = $request->post("item_id");
////        $propList   = $request->post("prop_list");
////        $lang       = $request->post("lang","tc");
////        if(empty($id))
////            $this->failed(trans('msg.item_id_empty',[],$lang));
////        if(empty($propList))
////            $this->failed(trans('msg.prop_list_empty',[],$lang));
////    }


    //检查输入的键值对
    protected function checkParams($propList,$lang){
        $flag = false;
        foreach($propList as $val)
        {
            if(!isset($val->prop_id) || !isset($val->prop_value_id))
            {
                $flag = true;
                break;
            }
        }

        if($flag)
            $this->failed(trans('msg.prop_id_empty',[],$lang));
    }

}