<?php
/**
 *  订单控制器
 * author：徐树彬
 * date ：2022-12-06
 */
namespace App\Http\Controllers\Common;


use App\Http\Controllers\BaseController;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use App\UserCoupon;


class OrderController extends BaseController{

    //添加订单
    public function addOrder(){
        $user = Db::table('user')->where('id',UID)->first();
        $sid = Input::get('sid');
        $goodid = Input::get('goodsid');
        $remark = Input::get('remark');
        $cou_id = Input::get('cou_id');
        $cou_money = Input::get('cou_money');
        $money = Input::get('money');
        $num = Input::get('num');
        $paytype = Input::get('paytype');
        $payment_id = Input::get('payment_id');
        $data['sid'] = $sid;
        $store =  Db::table('store')->where('id',$sid)->first();
        $data['sname_en'] = $store->name_en;
        $data['sname_tc'] = $store->name_tc;
        $data['uid'] = UID;
        $data['phone'] = $user->account;
        $data['order_mark'] = $remark;
        $data['coupon'] = $cou_id;
        $data['money'] = $money+$cou_money;
        $data['discount'] = $cou_money;
        $data['num'] = $num;
        $data['price'] = $money;
        $data['paytype'] = $paytype;
        $data['create_time'] = date('Y-m-d H:i:s');
        $data['order_no'] = 'LJX'.rand(1000,9999).date('YmdHis').rand(1000,9999);
        $data['payment_id'] = $payment_id;
        if($data['money'] - $data['discount'] <= 0){
            $data['payment_id'] = 'coupon discount';
        }
        $id = Db::table('order')->insertGetId($data);
        if(strpos($goodid,',') !== false){ 
            $cgid = explode(',',$goodid);
            foreach($cgid as $v){
                Db::table('cart_goods')->where('id',$v)->update(['status'=>$id]);
            }
        }else{
            Db::table('cart_goods')->where('id',$goodid)->update(['status'=>$id]);
        }
        $this->success(['id'=>$id],$this->l['add_success']);
    }

    //选择优惠券
    public function couposCgid(){
        $cgids = Input::get('cgids');
        $w['uid'] = UID;
        $w['status'] = 0;
        $w['type'] = 1;
        $today = date('Y-m-d');
        $cou = Db::table('user_coupon')->where('uid',UID)->where('status',1)->where('type',1)->groupBy('cpid')->get([DB::raw('cpid,count(id) as num')])->toArray();
        $cou = array_column($cou,NULL,'cpid');
        $coupos = Db::table('user_coupon')->where($w)->where('start_date','<=',$today)->where('end_date','>=',$today)->get(['title_'.$this->lang.' as title','img','id','cpid','start_date','end_date','ids'])->toArray();
        $cgid = explode(',',$cgids);
        foreach($coupos as $k=>$v){
            if(array_key_exists($v->cpid,$cou)){
                $use_num = Db::table('coupon')->where('status', 0)->where(function ($query) use ($v) {
                    $query->where('usage_type', 'online')
                          ->orWhere('usage_type', 'all');
                })->where('id',$v->cpid)->value('use_num');
                $count = $cou[$v->cpid]->num;
                if($count >= $use_num){
                    unset($coupos[$k]);
                }
            }
            $ids = explode(',',$v->ids);
            $int = array_intersect($cgid,$ids);
            if(empty($int)){
                unset($coupos[$k]);
            }
        }
        $coupos = array_values($coupos);
        $this->success($coupos);
    }
    
    //选择优惠券
    public function selectCoupos(){
        $cgids = Input::get('cgids');
        $id = Input::get('id');
        $m = Input::get('money');
        $coupos = Db::table('user_coupon')->where('id',$id)->first();
        if($coupos->flag == 1){
            $money = $coupos->discount;
        }else{
            $cgid = explode(',',$cgids);
            $ids = explode(',',$coupos->ids);
            $int = array_intersect($cgid,$ids);
            if(count($int) == 1){
                $int = array_values($int);
                $price = Db::table('item')->where('item_id',$int[0])->value('price');
                $money = round($price*$coupos->discount/100,2);
            }else{
                $disc = [];
                foreach($int as $v){
                    $price = Db::table('item')->where('item_id',$v)->value('price');
                    $disc[] = round($price*$coupos->discount/100,2);
                }
                $money = min($disc);
            }
        }
        if($money > $m){
            $money = $m;
        }
        $data['money'] = round($money,2);
        if($this->lang == 'tc'){
            $data['title'] = $coupos->title_tc;
        }else{
            $data['title'] = $coupos->title_en;
        }
        $data['id'] = $id;
        // print_r($data);
        $this->success($data);
    }

    //订单列表
    public function orderList(){
        $list = Db::table('order')->where('uid',UID)->where('status','>',0)->select(['id','sid','code','coupon','pay_time','payment_id','pick_time','status','order_no','sname_'.$this->lang.' as sname','price'])->orderBy('create_time','desc')->get();
        foreach($list as $v){
            $cart_goods = Db::table('cart_goods')->where('status',$v->id)->get(['img','title','num','tag']);
            $v->cart_goods = $cart_goods;
            // 方案優惠券兌換情況
            $v->projectTitle = '';
            if(!$v->payment_id){
                $v->projectTitle = Db::table('project')->where('id',$v->coupon)->first(['title_'.$this->lang.' as title'])->title;
            }
        }
        $this->success($list);
    }

    //订单列表
    public function orderDetail(){
        $id = Input::get('id') ?? 0;
        if($id  == 0){
            $this->failed($this->l['param_incomplete']);
        }
        $order = Db::table('order')->where('id',$id)->first(['id','sid','code','coupon','pay_time','pick_time','status','order_no','order_mark','coupon','num','money','price','payment_id']);
        $order->coupon_name = Db::table('user_coupon')->where('id',$order->coupon)->value('title_'.$this->lang.' as title');
        $order->store = Db::table('store')->where('id',$order->sid)->first(['name_'.$this->lang.' as name','id','address','now_order','now_cup','phone']);
        $order->store->times = $order->store->now_cup*2;
        $order->goods = Db::table('cart_goods')->where('status',$order->id)->get(['img','title','num','tag','price']);
        $order->projectTitle = '';
        if(!isset($order->payment_id)){
            $order->projectTitle = Db::table('project')->where('id',$order->coupon)->first(['title_'.$this->lang.' as title'])->title;
        }
        $this->success($order);
    }
}


// https://accounts.google.com/o/oauth2/auth?scope=https://www.googleapis.com/auth/androidpublisher&response_type=code&access_type=offline&redirect_uri=http://ljx.tenghuiwangxiao.com/oauth2callback&client_id=921196734926-f85oibif09j4la4n8mpuq43fppvp1569.apps.googleusercontent.com