<?php
/**
 *  用户端控制器
 * author：徐树彬
 * date ：2022-11-16
 */
namespace App\Http\Controllers\Common;

use net\authorize\api\contract\v1 as AnetAPI;
use net\authorize\api\controller as AnetController;
use App\Http\Controllers\BaseController;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use net\authorize\api\controller\test\ApiCoreTestBase as ApiCoreTestBase;
use net\authorize\api\contract\v1 AS apiContract;
use net\authorize\api\controller AS apiController;

class PayController{
    public function pay1($intervalLength = 23){
        $merchantAuthentication = new AnetAPI\MerchantAuthenticationType();
        $merchantAuthentication->setName('59HxtGf75Z');
        $merchantAuthentication->setTransactionKey('9Y8336Qa6G7vZpLA');//假的
        
        // Set the transaction's refId
        $refId = 'ref' . time();
    
        // Subscription Type Info
        $subscription = new AnetAPI\ARBSubscriptionType();
        $subscription->setName("Sample Subscription");
    
        $interval = new AnetAPI\PaymentScheduleType\IntervalAType();
        $interval->setLength($intervalLength);
        $interval->setUnit("days");
    
        $paymentSchedule = new AnetAPI\PaymentScheduleType();
        $paymentSchedule->setInterval($interval);
        $paymentSchedule->setStartDate(new \DateTime('2035-12-30'));
        $paymentSchedule->setTotalOccurrences("12");
        $paymentSchedule->setTrialOccurrences("1");
    
        $subscription->setPaymentSchedule($paymentSchedule);
        $subscription->setAmount(rand(1,99999)/12.0*12);
        $subscription->setTrialAmount("0.00");
        
        $creditCard = new AnetAPI\CreditCardType();
        $creditCard->setCardNumber("4111111111111111");
        $creditCard->setExpirationDate("2038-12");
    
        $payment = new AnetAPI\PaymentType();
        $payment->setCreditCard($creditCard);
        $subscription->setPayment($payment);
    
        $order = new AnetAPI\OrderType();
        $order->setInvoiceNumber("1234354");        
        $order->setDescription("Description of the subscription"); 
        $subscription->setOrder($order); 
        
        $billTo = new AnetAPI\NameAndAddressType();
        $billTo->setFirstName("John");
        $billTo->setLastName("Smith");
    
        $subscription->setBillTo($billTo);
    
        $request = new AnetAPI\ARBCreateSubscriptionRequest();
        $request->setmerchantAuthentication($merchantAuthentication);
        $request->setRefId($refId);
        $request->setSubscription($subscription);
        $controller = new AnetController\ARBCreateSubscriptionController($request);
    
        $response = $controller->executeWithApiResponse( \net\authorize\api\constants\ANetEnvironment::PRODUCTION);
        print_r($response);
        if (($response != null) && ($response->getMessages()->getResultCode() == "Ok") ){
            $data['subscriptionId'] = $response->getSubscriptionId();
            $data['subscriptionId'] = $response->getSubscriptionId();
            return $data;
        }else{
            echo "ERROR :  Invalid response\n";
            $errorMessages = $response->getMessages()->getMessage();
            echo "Response : " . $errorMessages[0]->getCode() . "  " .$errorMessages[0]->getText() . "\n";
        }
    }

    public function pay(){
        $amount = Input::get('amount');
        $dataDescriptor = Input::get('dataDescriptor');
        $token = Input::get('token');
        $merchantAuthentication = new apiContract\MerchantAuthenticationType();
        $merchantAuthentication->setName('59HxtGf75Z');
        $merchantAuthentication->setTransactionKey('9Y8336Qa6G7vZpLA');

        $OpaqueData = new apiContract\OpaqueDataType();
        $OpaqueData->setDataDescriptor($dataDescriptor);
        $OpaqueData->setDataValue($token);

        $paymentType = new apiContract\PaymentType();
        $paymentType->setOpaqueData( $OpaqueData);

        //create a transaction
        $transactionRequestType = new apiContract\TransactionRequestType();
        $transactionRequestType->setTransactionType( "authCaptureTransaction"); // TODO Change to Enum
        $transactionRequestType->setAmount( $amount);
        $transactionRequestType->setPayment( $paymentType);

        $request = new apiContract\CreateTransactionRequest();
        $request->setMerchantAuthentication($merchantAuthentication);
        $request->setTransactionRequest( $transactionRequestType);

        $controller = new apiController\CreateTransactionController($request);
        $response = $controller->executeWithApiResponse(\net\authorize\api\constants\ANetEnvironment::PRODUCTION);

        $errorMessages = $response->getMessages()->getMessage();
        $allErrors = $response->getTransactionResponse()->getErrors();
        $responsecode = $response->getTransactionResponse()->getResponseCode();
        if (($response != null) && ($response->getMessages()->getResultCode() == "Ok") ){
            if($responsecode != 1){
                return ['code'=>$allErrors[0]->geterrorCode(),'message'=>$allErrors[0]->geterrorText()];
            }else{
                return ['code'=>'succeffful'];
            }
        }else{
            return ['code'=>$errorMessages[0]->getCode(),'message'=>$errorMessages[0]->getText(),'errcode'=>$allErrors[0]->geterrorCode(),'errmessage'=>$allErrors[0]->geterrorText()];
        }
    }

    protected function getRandomString( $title)
    {
        return sprintf( "%s%s", $title, 0);
    }
}