<?php
/**
 *  短信控制器
 */
namespace App\Http\Controllers\Common;

use App\Http\Controllers\BaseController;
use App\Repositories\Common\SmsRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class SmsController extends BaseController
{

    /**
     * 获取短信
     * @param Request $request
     * @param
     */
    public function getSmsCode(Request $request,SmsRepository $SmsRepository){
        $mobile = $request->post("mobile");
        $areacode = $request->post("areacode") ?? '+86';
        $type = $request->post("type") ?? 0;
        if(empty($mobile))
            $this->failed($this->l['mobile_not_null']);

        if($type == 1){
            $user = Db::table('user')->where('account',$mobile)->first();
            if(!$user)
                $this->success(['code'=>1],$this->l['account_not_exists']);//账户不存在
        }
        $code = rand(pow(10,(4-1)), pow(10,4)-1)."";    
        $param = "{'code':'".$code."'}";
        $send = $SmsRepository->main($areacode.$mobile, $param);
        if (!$send) {
            $this->failed($this->l['send_error']);
            return ;
        }
        $log['address'] = $mobile;
        $log['code'] = $code;
        $log['time'] = time();
        $log['add_time'] = date('Y-m-d H:i:s');

        $is = Db::table('smsmessage_log')->where('address',$mobile)->orderBy('time','desc')->first();
        if(!$is || (time()-$is->time) > 120){
            Db::table('smsmessage_log')->insertgetid($log);
        }
        $this->success(['code'=>0]);
    }


    /**
     * 验证短信
     * @param Request $request
     * @param SmsRepository $smsRepository
     */
    public function checkSms(Request $request)
    {
        $mobile = $request->post("mobile");
        $code   = $request->post("code");
        if(empty($mobile))
            $this->failed($this->l['mobile_not_null']);
        
        if(empty($code))
            $this->failed($this->l['code_not_null']);
        
        $result = Db::table('smsmessage_log')->where('address',$mobile)->where('code',$code)->orderBy('time','desc')->first();
        if(empty($result))
            $this->failed($this->l['code_error']);
        
        $diff = time() - strtotime($result->add_time);
        if($diff > 300)
            $this->failed($this->l['code_timeout']);

        $this->success('',$this->l['check_success']);
    }

}
