<?php

/**
 * 上传控制器
 */
namespace App\Http\Controllers\Common;
use App\Http\Controllers\BaseController;
use App\Libraries\OSS\OssClient;
use App\Helpers\FileUploader;
use File;
use App\Repositories\Admin\DepartRepository;
use App\Repositories\Business\TaskRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use stdClass;
use Illuminate\Support\Facades\Storage;
class UploadController extends  BaseController
{


    private $business       = "business";
    private $business_type  = "business_type";
    private $user           = "user";

    public function index(Request $request) {
        $file = $request->file('file');
        
        if ($file) {
            $originalName = $file->getClientOriginalName();
            $extension = $file->getClientOriginalExtension();
            $newFileName = uniqid() . '.' . $extension;
            $path = $file->storeAs('public/img', $newFileName);
            // $filePath = 'storage/img/' . $newFileName;  
            $filePath = 'img/' . $newFileName;  
            $storedPath = asset($filePath);
            $this->success($storedPath);
        }
        $this->failed('No file uploaded.', 400);
    }
    

    // public function index(){
    //     $key = 'file';

    //     $ossConf["accessKeyId"] = config('serve.accessKeyId');
    //     $ossConf["accessKeySecret"] = config('serve.accessKeySecret');
    //     $ossConf["endpoint"] = config('serve.endpoint');
    //     $ossConf["bucket"] = config('serve.bucket');

    //     $bucket = $ossConf["bucket"];  //云存储的存储盘

    //     if (empty($key))
    //     {
    //         $this->failed('文件上传Key值为空');
    //     }


    //     if (!isset($_FILES[$key]['error']))
    //     {
    //         $this->failed('没有上传任何文件');
    //     }
    //     Log::stack(['daily'])->info("文件上传信息", $_FILES);
    //     if ($_FILES[$key]['error'] != '0')
    //     {
    //         $this->failed('文件上传错误');
    //     }

    //     $file_md5 = md5_file($_FILES[$key]['tmp_name']);
    //     dd($file_md5);

    //     //文件去重复
    //     $item = DB::table("file")->where('md5',"=",$file_md5)->first();
    //     $item = json_decode(json_encode($item),true);
    //     if (!empty($item) && isset($item['path']))
    //     {

    //         //需要解析出文件的url返回
    //         $url = 'https://'.$ossConf["bucket"].'.'.$ossConf["endpoint"].$item["path"].'/'.$item["filename"];
    //         $this->success($url);
    //     }
    //     $ossClient = new OssClient($ossConf['accessKeyId'],$ossConf['accessKeySecret'],$ossConf['endpoint']);

    //     $ret=$this->uploadFileByOss($key,$ossClient, $bucket);
    //     // print_r($ret);
    //     $item = [
    //         'filename'    => $ret['file_name'],
    //         'path'        => "/uploads/ljx".$ret['file_path'],
    //         'file_type'   => $ret['file_type'],
    //         'suffix'      => $ret['suffix'],
    //         'md5'         => $file_md5,
    //         'bucket'      => $bucket,
    //         'client_name' => $ret['client_name'],
    //         'file_size'   => $ret['file_size'],
    //         'create_time' =>date('Y-m-d H:i:s')
    //     ];
    //     $last_id = DB::table("file")->insertGetId($item);

    //     if(!$last_id)
    //     {
    //         $this->failed('保存上传文件数据失败');
    //     }

    //     $url = 'https://'.$ossConf["bucket"].'.'.$ossConf["endpoint"].$item["path"].'/'.$item["filename"];
    //     $this->success($url);
    // }


    //阿里云OSS
    function uploadFileByOss($key,$ossClient, $bucket)
    {

        $uid = 'ljx';

        $file=new FileUploader("");

        $ret=$file->getOssInfo($key);

        $object='uploads/'. $uid . $ret['file_path'].'/'.$ret['file_name'];

        $filePath = $_FILES[$key]['tmp_name'];

        try{
            $ossClient->uploadFile($bucket, $object, $filePath);
            $ret['status']='success';
        } catch(OssException $e) {

            $ret['status']='fail';
            $ret['msg']=$e->getMessage();

            return $ret;
        }
        return $ret;

    }

    /**
     * 上传excel文档
     */
    public function excel(Request $request)
    {
        set_time_limit(0);
        //获取表单上传文件
        $file    = $request->file('file');

        $res = file_get_contents('https://tengface-live-1308721187.file.myqcloud.com/web/config/xiaoyuzhong.json');
        $res = json_decode($res,true);
        $res = array_column($res,'header');
        $header = [];
        // print_r($res);die;
        if($file && $file->isValid())
        {
            require_once app_path().'/Libraries/phpexcel/PHPExcel.php';

            $extension      = $file->getClientOriginalExtension();
            if(!in_array($extension,["xlsx","xls","csv"]))
                $this->failed("文件类型不允许");

            $destinationPath = storage_path('/rundata/excel/');

            // 如果目标目录不存在，则创建之
            if (!file_exists($destinationPath))
                mkdir($destinationPath);

            $filename = "customer_excel_".time();
            // 保存文件到目标目录
            $file->move($destinationPath,$filename);

            $path_file_name = $destinationPath . DIRECTORY_SEPARATOR . $filename;

            $objReader =  $extension == "xlsx" ? \PHPExcel_IOFactory::createReader('Excel2007'):\PHPExcel_IOFactory::createReader('Excel5');

            $obj_PHPExcel =$objReader->load($path_file_name, $encode = 'utf-8');  //加载文件内容,编码utf-8

            $excel_array=$obj_PHPExcel->getsheet(0)->toArray();   //转换为数组格式
            array_shift($excel_array);  //删除第一个数组(标题);
            // print_r($excel_array);die;
            $data = [];
            $i=0;

            foreach($excel_array as $k=>$v){
                $data[$k]['t_id'] = '1686';
                $data[$k]['nick'] = $v[2];
                if(array_key_exists($v[2],$header)){//判断头像昵称数组是否有数据，有就取出来，保证同一个直播间，同一个人头像一样
                    $data[$k]['header'] = $header[$v[2]];
                }else{//没有，就随机出来一个头像，然后绑定好头像昵称
                    $h = array_rand($res,1);
                    $data[$k]['header'] = $res[$h];
                    $header[$v[2]] = $res[$h];
                }
                $time = explode(':',$v[1]);
                $data[$k]['send_time'] = $time[0]*3600+$time[1]*60+$time[2];
                switch($v[3]){
                    case 1 ://+1
                        $data[$k]['content'] = $v[4];
                        $data[$k]['pic_url'] = '';
                        break;
                    case 2 ://送花
                        $data[$k]['content'] = "<span>送给老师的鲜花</span>< img style='width:20px;vertical-align: bottom;' src='https://tengface-live.oss-cn-beijing.aliyuncs.com/web/wx-user/flower/xianhua.png'/>";
                        $data[$k]['pic_url'] = '';
                        break;
                    case 3 ://话术
                        $data[$k]['content'] = $v[4];
                        $data[$k]['pic_url'] = '';
                        break;
                    case 4 ://表情包
                        $data[$k]['pic_url'] = $v[4];
                        $data[$k]['content'] = '';
                        break;
                    case 5 ://图片
                        $data[$k]['pic_url'] = $v[4];
                        $data[$k]['content'] = '';
                        break;
                }
                $data[$k]['create_time'] = date('Y-m-d H:i:s');
                if($v[2] == '助教老师'){
                    $data[$k]['teacher'] = 1;
                }else{
                    $data[$k]['teacher'] = 2;
                }
            }
            Db::table('ds_fake_comment')->insert($data);
            print_r($data);

        }else{
            // 上传失败获取错误信息
            $this->failed($file->getError());
        }
    }


    public function testMsg(TaskRepository $taskRepository)
    {
        $openid = "ohDw0swSCutdnDUfVaUp1q589LgY";

        $data   =  new StdClass();
        $data->name ="李盼";
        $datetime = date("Y-m-d H:i:s");


        $taskRepository->sendMsg($openid,$data,$datetime,"");

        echo "send success";exit;
    }
}
