<?php
/**
 *  前端控制器
 */
namespace App\Http\Controllers\Common;
use App\Http\Controllers\BaseController;

use Illuminate\Support\Facades\Crypt;
use Illuminate\Http\Request;
use Exception;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use App\UserCoupon;

class UserController extends  BaseController{

    /**
     * 用户注册流程
     * author:徐树彬
     * date 2022-11-14
     */
    public function register(){
        $mobile = Input::get('mobile');
        $repass = Input::get('repass');
        $areacode = Input::get('areacode') ?? '86';
        $pass = Input::get('pass');
        $ucode = Input::get('code');
        if(empty($mobile)||empty($repass)||empty($pass))
            $this->failed($this->l['param_incomplete']);
        
        $isuser = Db::table('user')->where('account',$mobile)->first();
        if($isuser){
            $this->success(['code'=>1],$this->l['account_exists']);
        }
        if($pass != $repass)
            $this->failed($this->l['pass_different']);
        
        if(strlen($pass)<8||strlen($pass)>12)
            $this->failed($this->l['enter_8-12_pass']);

        $rule = "/[A-Za-z]+[0-9]+/";   
        $rule1 = "/[0-9]+[A-Za-z]+/";   
        
        $is = preg_match($rule, $pass);
        $is1 = preg_match($rule1, $pass);
        if($is==0&&$is1==0)
            $this->failed($this->l['enter_8-12_pass']);
        
        if(!empty($ucode)){//有邀请码
            $codeuser = DB::table('user')->where(['code'=>$ucode])->first();
            if(empty($codeuser)){
                $this->failed($this->l['invitation_code_error']);
            }
            $data['pid'] = $codeuser->id;
            $upuser['invitation_num'] = $codeuser->invitation_num+1;
            //邀请福利
            $w['type'] =1;
            $w['flag'] =1;//给邀请人
            $msg = DB::table('rule')->where($w)->first();
            if(!empty($msg)){
                $info['point'] = $msg->num;
                $info['uid'] = $data['pid'];
                $info['create_time'] = date('Y-m-d H:i:s');
                switch($msg->msg){
                    case 1:
                        $upuser['point'] = $codeuser->point+$msg->num;
                        $info['type'] = 0;
                        $info['flag'] = 0;
                        $info['title_tc'] = '邀請獲得點數';
                        $info['title_en'] = 'Invite to receive point';
                        DB::table('msg')->insert($info);
                        $notice['uid'] = $data['pid'];
                        $notice['create_time'] = date('Y-m-d H:i:s');
                        $notice['date'] = date('Y-m-d');
                        $notice['flag'] = 7;
                        $notice['type'] = 3;
                        $notice['title_tc'] = '邀請獲得點數通知';
                        $notice['remark_tc'] = '獲得'.$msg->num.'點，點數餘額'.$upuser['point'].'點';
                        $notice['title_en'] = 'Invite to receive point notification';
                        $notice['remark_en'] = 'Get '.$msg->num.' points and the balance is '.$upuser['point'].' points';
                        DB::table('notice')->insert($notice);
                        break;
                    case 2:    
                        $upuser['experience'] = $codeuser->experience+$msg->num;
                        $info['type'] = 1;
                        $info['flag'] = 0;
                        $info['title_tc'] = '邀請獲得经验';
                        $info['title_en'] = 'Invitation to gain experience';
                        DB::table('msg')->insert($info);
                        break;
                    case 3:    
                        $coupon = Db::table('coupon')->where('id',$msg->ids)->first();
                        if(!empty($coupon)){
                       //用户优惠券表添加
                        $uc['uid'] = $data['pid'];
                        $uc['cpid'] = $msg->ids;
                        $uc['title_en'] = $coupon->name_en;
                        $uc['sub_title_en'] = $coupon->sub_title_en;
                        $uc['title_tc'] = $coupon->name_tc;
                        $uc['sub_title_tc'] = $coupon->sub_title_tc;
                        $uc['flag'] = $coupon->type;
                        $uc['start_date'] = $coupon->start_date;
                        $uc['end_date'] = $coupon->end_date;
                        $uc['discount'] = $coupon->discount;
                        $uc['ids'] = $coupon->ids;
                        $uc['img'] = $coupon->img;
                        $uc['type'] = 1;
                        $uc['create_time'] = date('Y-m-d H:i:s');
                        $uc['code'] = rand_str(10);
                        $isuc = DB::table('user_coupon')->where(['code'=>$uc['code']])->first();
                        while(!empty($isuc)){//验证优惠券码不能重复
                            $uc['code'] = rand_str(10);
                            $isuc = DB::table('user')->where(['code'=>$uc['code']])->first();
                        }
                        $ucid = Db::table('user_coupon')->insertGetid($uc);
                         //加优惠券记录记录
                        $msg1['uid']  = $data['pid'];
                        $msg1['type']  = 0;
                        $msg1['point']  = 0;
                        $msg1['create_time']  = date('Y-m-d H:i:s');
                        $msg1['title_en']  = $coupon->name_en;
                        $msg1['title_tc']  = $coupon->name_tc;
                        $msg1['type']  = 2;
                        Db::table('msg')->insert($msg1);
                        //加优惠券到账通知
                        $notice['uid'] = $data['pid'];
                        $notice['title_tc'] = '優惠券到賬通知';
                        $notice['title_en']  = 'Notice of coupon receipt';
                        $notice['type'] = 3;
                        $notice['remark_tc'] = "收到新的優惠券 '".$coupon->name_tc."'";
                        $notice['remark_en']  = "Receive a new coupon '".$coupon->name_en."'";
                        $notice['date'] = date('Y-m-d');
                        $notice['flag'] = 2;
                        $notice['link'] = $ucid;
                        $notice['create_time'] = date('Y-m-d H:i:s');
                        Db::table('notice')->insert($notice);
                        //优惠券表发送数量+1，用户优惠券表加一条数据，记录日志表加数据
                        Db::table('coupon')->where('id',$msg->ids)->increment('send_num');
                        }
                        break;
                }
            }
            Db::table('user')->where('id',$codeuser->id)->update($upuser);
        }    
        $code = rand_str(6);
        $is = DB::table('user')->where(['code'=>$code])->first();
        while(!empty($is)){//验证邀请码不能重复
            $code = rand_str(6);
            $is = DB::table('user')->where(['code'=>$code])->first();
        }
        $data['account'] = $data['name'] = $mobile;
        $data['avatar'] = 'https://tengface-live-user.oss-cn-shenzhen.aliyuncs.com/uploads/ljx/2023/01/07/1673079837717336.png';
        $data['experience'] = 0;
        $data['areacode'] = $areacode;
        $data['pass'] = md5($pass);
        $data['code'] = $code;
        $data['create_time'] = $data['update_time'] = date('Y-m-d H:i:s');
        $data['date'] = date('Y-m-d');
        $uid = Db::table('user')->insertGetId($data);
        if(!empty($ucode)){//有邀请码
            $codeuser = DB::table('user')->where(['code'=>$ucode])->first();
            //邀请福利
            $w['type'] =1;
            $w['flag'] =0;//给自己
            $upuser = [];
            $msg = DB::table('rule')->where($w)->first();
            if(!empty($msg)){
                $info['point'] = $msg->num;
                $info['uid'] = $uid;
                $info['create_time'] = date('Y-m-d H:i:s');
                switch($msg->msg){
                    case 1:
                        $upuser['point'] = $codeuser->point+$msg->num;
                        $info['title_tc'] = '邀請獲得點數';
                        $info['title_en'] = 'Invite to receive point';
                        $info['type'] = 0;
                        $info['flag'] = 0;
                        DB::table('msg')->insert($info);
                        $notice['uid'] = $uid;
                        $notice['create_time'] = date('Y-m-d H:i:s');
                        $notice['date'] = date('Y-m-d');
                        $notice['flag'] = 7;
                        $notice['type'] = 3;
                        $notice['title_tc'] = '邀請獲得點數通知';
                        $notice['remark_tc'] = '獲得'.$msg->num.'點，點數餘額'.$upuser['point'].'點';
                        $notice['title_en'] = 'Invite to receive point notification';
                        $notice['remark_en'] = 'Get '.$msg->num.' points and the balance is '.$upuser['point'].' points';
                        DB::table('notice')->insert($notice);
                        break;
                    case 2:    
                        $upuser['experience'] = $codeuser->experience+$msg->num;
                        $info['title_tc'] = '邀請獲得經驗通知';
                        $info['title_en'] = 'Invite to receive experience notice';
                        $info['type'] = 1;
                        $info['flag'] = 0;
                        DB::table('msg')->insert($info);
                        break;
                    case 3:    
                        $coupon = Db::table('coupon')->where('id',$msg->ids)->first();
                        if(!empty($coupon)){
                       //用户优惠券表添加
                        $uc['uid'] = $uid;
                        $uc['cpid'] = $msg->ids;
                        $uc['title_en'] = $coupon->name_en;
                        $uc['sub_title_en'] = $coupon->sub_title_en;
                        $uc['title_tc'] = $coupon->name_tc;
                        $uc['sub_title_tc'] = $coupon->sub_title_tc;
                        $uc['flag'] = $coupon->flag;
                        $uc['start_date'] = $coupon->start_date;
                        $uc['end_date'] = $coupon->end_date;
                        $uc['discount'] = $coupon->discount;
                        $uc['ids'] = $coupon->ids;
                        $uc['img'] = $coupon->img;
                        $uc['type'] = 1;
                        $uc['create_time'] = date('Y-m-d H:i:s');
                        $uc['code'] = rand_str(10);
                        $isuc = DB::table('user_coupon')->where(['code'=>$uc['code']])->first();
                        while(!empty($isuc)){//验证优惠券码不能重复
                            $uc['code'] = rand_str(10);
                            $isuc = DB::table('user')->where(['code'=>$uc['code']])->first();
                        }
                        $ucid = Db::table('user_coupon')->insertGetid($uc);
                         //加优惠券记录记录
                        $msg1['uid']  = $uid;
                        $msg1['type']  = 0;
                        $msg1['point']  = 0;
                        $msg1['create_time']  = date('Y-m-d H:i:s');
                        $msg1['title_en']  = $coupon->name_en;
                        $msg1['title_tc']  = $coupon->name_tc;
                        $msg1['type']  = 2;
                        Db::table('msg')->insert($msg1);
                        //加优惠券到账通知
                        $notice['uid'] = $uid;
                        $notice['title_tc'] = '優惠券到賬通知';
                        $notice['title_en']  = 'Notice of coupon receipt';
                        $notice['remark_tc'] = "收到新的優惠券 '".$coupon->name_tc."'";
                        $notice['remark_en']  = "Receive a new coupon '".$coupon->name_en."'";
                        $notice['type'] = 3;
                        $notice['date'] = date('Y-m-d');
                        $notice['flag'] = 2;
                        $notice['link'] = $ucid;
                        $notice['create_time'] = date('Y-m-d H:i:s');
                        Db::table('notice')->insert($notice);
                        //优惠券表发送数量+1，用户优惠券表加一条数据，记录日志表加数据
                        Db::table('coupon')->where('id',$msg->ids)->increment('send_num');
                        }
                        break;
                }
            }
            if(!empty($upuser)){
                DB::table('user')->where('id',$uid)->update($upuser);
            }
        }    
        $this->success(['code'=>0]);
    }
   
    /**
     * 绑定邀请码流程
     * author 徐树彬
     * date 2023-04-23
     */
    public function Invite(){
        $code = Input::get('code');
        $user = DB::table('user')->where("id",UID)->first();
        if(!empty($user->pid)){
            $this->failed($this->l['no_repat_invat']);
        }

        $codeuser = DB::table('user')->where(['code'=>$code])->first();

        // gc_kevin 查無此人擋住
        if(!$codeuser){
            $this->failed($this->l['no_user']);
        }

        // gc_kevin 相同 user 擋住
        if($user->code === $codeuser->code){
            $this->failed($this->l['same_user']);
        }

        if(empty($codeuser)){
            $this->failed($this->l['invitation_code_error']);
        }

        $data['pid'] = $codeuser->id;
        // $upuser['invitation_num'] = $codeuser->invitation_num+1;
        //邀请福利
        $w['type'] =1;
        $w['flag'] =1;//给邀请人
        $msg = DB::table('rule')->where($w)->first();
        if(!empty($msg)){
            // $coupon = Db::table('coupon')->where('id',$msg->ids)->first();
            // if(!empty($coupon)){
            $upuser['point'] = $codeuser->point+$msg->num;
            $info['point'] = $msg->num;
            $info['uid'] = $data['pid'];
            $info['create_time'] = date('Y-m-d H:i:s');
            $info['title_tc'] = '邀請獲得點數';
            $info['title_en'] = 'Invite to receive point';
            $info['type'] = 0;
            $info['flag'] = 0;
            DB::table('msg')->insert($info);
            $notice['uid'] = $data['pid'];
            $notice['create_time'] = date('Y-m-d H:i:s');
            $notice['date'] = date('Y-m-d');
            $notice['flag'] = 7;
            $notice['type'] = 3;
            $notice['title_tc'] = '邀請獲得點數通知';
            $notice['remark_tc'] = '獲得'.$msg->num.'點，點數餘額'.$upuser['point'].'點';
            $notice['title_en'] = 'Invite to receive point notification';
            $notice['remark_en'] = 'Get '.$msg->num.' points and the balance is '.$upuser['point'].' points';
            DB::table('notice')->insert($notice);
            // //用户优惠券表添加
            // $uc['uid'] = $data['pid'];
            // $uc['cpid'] = $msg->ids;
            // $uc['title_en'] = $coupon->name_en;
            // $uc['sub_title_en'] = $coupon->sub_title_en;
            // $uc['title_tc'] = $coupon->name_tc;
            // $uc['sub_title_tc'] = $coupon->sub_title_tc;
            // $uc['flag'] = $coupon->type;
            // $uc['start_date'] = $coupon->start_date;
            // $uc['end_date'] = $coupon->end_date;
            // $uc['discount'] = $coupon->discount;
            // $uc['ids'] = $coupon->ids;
            // $uc['img'] = $coupon->img;
            // $uc['type'] = 1;
            // $uc['create_time'] = date('Y-m-d H:i:s');
            // $uc['code'] = rand_str(10);
            // $isuc = DB::table('user_coupon')->where(['code'=>$uc['code']])->first();
            // while(!empty($isuc)){//验证优惠券码不能重复
            //     $uc['code'] = rand_str(10);
            //     $isuc = DB::table('user')->where(['code'=>$uc['code']])->first();
            // }
            // $ucid = Db::table('user_coupon')->insertGetid($uc);
            // //加优惠券记录记录
            // $msg1['uid']  = $data['pid'];
            // $msg1['type']  = 0;
            // $msg1['point']  = 0;
            // $msg1['create_time']  = date('Y-m-d H:i:s');
            // $msg1['title_en']  = $coupon->name_en;
            // $msg1['title_tc']  = $coupon->name_tc;
            // $msg1['type']  = 2;
            // Db::table('msg')->insert($msg1);
            // //加优惠券到账通知
            // $notice['uid'] = $data['pid'];
            // $notice['title_tc'] = '優惠券到賬通知';
            // $notice['title_en']  = 'Notice of coupon receipt';
            // $notice['type'] = 3;
            // $notice['remark_tc'] = "收到新的優惠券 '".$coupon->name_tc."'";
            // $notice['remark_en']  = "Receive a new coupon '".$coupon->name_en."'";
            // $notice['date'] = date('Y-m-d');
            // $notice['flag'] = 2;
            // $notice['link'] = $ucid;
            // $notice['create_time'] = date('Y-m-d H:i:s');
            // Db::table('notice')->insert($notice);
            // //优惠券表发送数量+1，用户优惠券表加一条数据，记录日志表加数据
            // Db::table('coupon')->where('id',$msg->ids)->increment('send_num');
            // }
        }
        Db::table('user')->where('id',$codeuser->id)->update($upuser);
         
            //邀请福利
        $w['type'] =1;
        $w['flag'] =0;//给自己
        $msg = DB::table('rule')->where($w)->first();
        if(!empty($msg)){
            // $coupon = Db::table('coupon')->where('id',$msg->ids)->first();
            // if(!empty($coupon)){
            $info['point'] = $msg->num;
            $info['uid'] = UID;
            $info['create_time'] = date('Y-m-d H:i:s');
            $data['point'] = $user->point+$msg->num;
            $info['title_tc'] = '邀請獲得點數';
            $info['title_en'] = 'Invite to receive point';
            $info['type'] = 0;
            $info['flag'] = 0;
            DB::table('msg')->insert($info);
            $notice['uid'] = UID;
            $notice['create_time'] = date('Y-m-d H:i:s');
            $notice['date'] = date('Y-m-d');
            $notice['flag'] = 7;
            $notice['type'] = 3;
            $notice['title_tc'] = '邀請獲得點數通知';
            $notice['remark_tc'] = '獲得'.$msg->num.'點，點數餘額'.$data['point'].'點';
            $notice['title_en'] = 'Invite to receive point notification';
            $notice['remark_en'] = 'Get '.$msg->num.' points and the balance is '.$data['point'].' points';
            DB::table('notice')->insert($notice);
            //用户优惠券表添加
            // $uc['uid'] = UID;
            // $uc['cpid'] = $msg->ids;
            // $uc['title_en'] = $coupon->name_en;
            // $uc['sub_title_en'] = $coupon->sub_title_en;
            // $uc['title_tc'] = $coupon->name_tc;
            // $uc['sub_title_tc'] = $coupon->sub_title_tc;
            // $uc['flag'] = $coupon->flag;
            // $uc['start_date'] = $coupon->start_date;
            // $uc['end_date'] = $coupon->end_date;
            // $uc['discount'] = $coupon->discount;
            // $uc['ids'] = $coupon->ids;
            // $uc['img'] = $coupon->img;
            // $uc['type'] = 1;
            // $uc['create_time'] = date('Y-m-d H:i:s');
            // $uc['code'] = rand_str(10);
            // $isuc = DB::table('user_coupon')->where(['code'=>$uc['code']])->first();
            // while(!empty($isuc)){//验证优惠券码不能重复
            //     $uc['code'] = rand_str(10);
            //     $isuc = DB::table('user')->where(['code'=>$uc['code']])->first();
            // }
            // $ucid = Db::table('user_coupon')->insertGetid($uc);
            //     //加优惠券记录记录
            // $msg1['uid']  = UID;
            // $msg1['type']  = 0;
            // $msg1['point']  = 0;
            // $msg1['create_time']  = date('Y-m-d H:i:s');
            // $msg1['title_en']  = $coupon->name_en;
            // $msg1['title_tc']  = $coupon->name_tc;
            // $msg1['type']  = 2;
            // Db::table('msg')->insert($msg1);
            // //加优惠券到账通知
            // $notice['uid'] = UID;
            // $notice['title_tc'] = '優惠券到賬通知';
            // $notice['title_en']  = 'Notice of coupon receipt';
            // $notice['remark_tc'] = "收到新的優惠券 '".$coupon->name_tc."'";
            // $notice['remark_en']  = "Receive a new coupon '".$coupon->name_en."'";
            // $notice['type'] = 3;
            // $notice['date'] = date('Y-m-d');
            // $notice['flag'] = 2;
            // $notice['link'] = $ucid;
            // $notice['create_time'] = date('Y-m-d H:i:s');
            // Db::table('notice')->insert($notice);
            // //优惠券表发送数量+1，用户优惠券表加一条数据，记录日志表加数据
            // Db::table('coupon')->where('id',$msg->ids)->increment('send_num');   
            // }
        }
        Db::table('user')->where('id',UID)->update($data);
        $this->success('',$this->l['operation_success']);
    }

    /**
     * 重置密码流程
     * author:徐树彬
     * date 2022-11-14
     */
    public function fogotPass(){
        $mobile = Input::get('mobile');
        $repass = Input::get('repass');
        $areacode = Input::get('areacode') ?? '86';
        $pass = Input::get('pass');
        if(empty($mobile)||empty($repass)||empty($pass))
            $this->failed($this->l['param_incomplete']);
        
        $user = Db::table('user')->where('account',$mobile)->first();
        // if($isuser){
        //     $this->success(['code'=>1]);
        // }
        if($pass != $repass)
            $this->failed($this->l['pass_different']);
        
        if(strlen($pass)<8||strlen($pass)>12)
            $this->failed($this->l['enter_8-12_pass']);

        $rule = "/[A-Za-z]+[0-9]+/";   
        $rule1 = "/[0-9]+[A-Za-z]+/";   
        
        $is = preg_match($rule, $pass);
        $is1 = preg_match($rule1, $pass);
        if($is==0&&$is1==0)
            $this->failed($this->l['enter_8-12_pass']);
        
        $data['pass'] = md5($pass);
        $data['update_time'] = date('Y-m-d H:i:s');
        Db::table('user')->where('id',$user->id)->update($data);
        $this->success(['code'=>0]);
    }

    /**
     * 用户登录流程
     * author:徐树彬
     * date 2022-11-15
     */
    public function login(){
        $mobile = Input::get('mobile');
        $pass = Input::get('pass');
        if(empty($mobile)||empty($pass))
            $this->failed($this->l['param_incomplete']);
        
        $user = Db::table('user')->where('account',$mobile)->first();
        if(!$user)
            $this->success(['code'=>2],$this->l['account_not_exists']);//账户不存在
                
        if($user->status == 1)
            $this->success(['code'=>1],$this->l['account_disabled']);//账户被禁用

        $passmd5 = md5($pass); 
        
        if($passmd5 != $user->pass)
            $this->failed($this->l['pass_error']);
        
        $token_data = [
            'plat'          => 'user',
            'uid'           => $user->id,  //账号id
            'expire'        => time()+3600*24*7,   //登陆有效期：7天
        ];
        $token = Crypt::encrypt($token_data);
        $w['date'] = date('Y-m-d');
        $w['uid'] = $user->id;
        $is = Db::table('login_log')->where($w)->first();
        if(empty($is)){
            $w['create_time'] = date('Y-m-d H:i:s');
            Db::table('login_log')->insert($w);
        }
        $this->success(['code'=>0,'token'=>$token]);
    }

    //验证账号是否存在
    public function checkAccount(){
        $mobile = Input::get('mobile');
        if(empty($mobile))
            $this->failed($this->l['param_incomplete']);

        $user = Db::table('user')->where('account',$mobile)->first();
        if(empty($user)){
            $this->success(['code'=>2],$this->l['account_not_exists']);//账户不存在
        }else{
            if($user->status == 1){
                $this->success(['code'=>1],$this->l['account_disabled']);//账户不存在
            }else{
                $this->success(['code'=>0]);
            }
        }
    }

    public function delUser(){
        $reason = Input::get('reason');
        $user = Db::table('user')->where('id',UID)->update(['is_del' => 1, 'del_text' => $reason ]);
        $this->success(['code' => 0],$this->l['account_delete']);
    }

    //个人中心
    public function home(){
        $user = Db::table('user')->where('id',UID)->first(['id','name','avatar','point','experience','code','level','pid']);    
        if($user->pid == 0){
            $user->pcode = '';
        }else{
            $user->pcode = Db::table('user')->where('id',$user->pid)->value('code');
        }
        $user->level_exper = Db::table('level')->where('id',$user->level)->value('score');

        $exper = Db::table('level')->where('score','>',$user->experience)->orderBy('id','asc')->first();

        $user->level = $exper->id;

        if($user->experience > $user->level_exper){
            Db::table('user')->where('id',UID)->update(['level'=>$exper->id,'update_time'=>date('Y-m-d H:i:s')]);
        }

        $user->level_exper = $exper->score;

        $user->exper = Db::table('level')->where('id',$user->level)->first(['img','name_'.$this->lang.' as name']);
        $user->new_message = Db::table('notice')->where('uid',UID)->where('read',0)->where('type',3)->count();     
        $user->coupon_num = Db::table('user_coupon')->where('uid',UID)->where('status',0)->where('type',1)->count();
        $user->project_num = Db::table('user_coupon')->where('uid',UID)->where('status',0)->where('type',2)->count();
        $user->coupon = Db::table('user_coupon')->where('uid',UID)->where('status',0)->where('type',1)->orderBy('end_date','asc')->limit(3)->get(['id','end_date','title_'.$this->lang.' as title','sub_title_'.$this->lang.' as sub_title']);
        $user->is_lian = Db::table('protocol')->where('id',1)->value('is_lian');
        $this->success($user);
    }

    //个人信息
    public function userInfo(){
        $user = Db::table('user')->where('id',UID)->first(['id','email','name','avatar','account','sex','birthday','areacode','stripe_id']);
        $this->success($user);
    }

     //编辑信息
    public function editUser(){
        $data['email'] = Input::get('email');
        $data['stripe_id'] = Input::get('stripe_id');
        $data['avatar'] = Input::get('avatar');
        $data['name'] = Input::get('name');
        $data['sex'] = Input::get('sex');
        $data['birthday'] = Input::get('birthday');
        Db::table('user')->where('id',UID)->update($data);
        $this->success('',$this->l['edit_success']);
    }

     //兑换码详情
    public function codeMsg(){
        $code = Db::table('user')->where('id',UID)->value('code');
        // $coupon = Db::table('coupon')->where('status',0)->pluck('name_'.$this->lang.' as name','id')->toArray();
        $w['type'] =1;
        $w['flag'] =1;//给邀请人
        $you = DB::table('rule')->where($w)->first(['num','msg','ids']);
        if(empty($you)){
            $one = '';
        }else{
            if(empty($you->num)){
                $one = '';
            }else{
                if($this->lang == 'tc'){
                    $one = '您的朋友將會獲得 '.$you->num.' 點';
                }else{
                    $one = 'Your friends will get '.$you->num.' points ';
                }
            }
            // if(array_key_exists($you->ids,$coupon)){
            //     if($this->lang == 'tc'){
            //         $one = '您的朋友將會獲得 '.$you->num.' 張 '.$coupon[$you->ids];
            //         // $one = '您的朋友將會獲得 '.$you->num.' 張 '.$coupon[$you->ids];
            //     }else{
            //         // $one = 'Your friends will get '.$you->num.' '.$coupon[$you->ids];
            //         $one = 'Your friends will get '.$you->num.' '.$coupon[$you->ids];
            //     }
            // }else{
            //     $one = '';
            // }
        }
        $w['flag'] =0;//给自己
        $me = DB::table('rule')->where($w)->first(['num','msg','ids']);  
        if(empty($you)){
            $two = '';
        }else{
            if(empty($me->num)){
                $two = '';
            }else{
                if($this->lang == 'tc'){
                    $two = '您將會獲得 '.$me->num.' 點';
                }else{
                    $two = 'Your will get '.$me->num.' points ';
                }
            }
            // if(array_key_exists($me->ids,$coupon)){        
            //     if($this->lang == 'tc'){
            //         $two = '您將獲得 '.$me->num.' 張 '.$coupon[$me->ids];
            //         // $two = '您將獲得 '.$me->num.' 張 '.$coupon[$me->ids];
            //     }else{
            //         // $two = 'You will also get '.$me->num.' '.$coupon[$me->ids];
            //         $two = 'You will also get '.$me->num.' '.$coupon[$me->ids];
            //     }
            // }else{
            //     $two = '';
            // }
        }
        $this->success(compact('code','one','two'));
    }

    //编辑手机号
    public function editAccount(){
        $data['account'] = Input::get('mobile');
        $user = Db::table('user')->where($data)->first();
        if(!empty($user)){
            $this->failed($this->l['mobile_exists']);
        }
        $data['areacode'] = Input::get('areacode');
        Db::table('user')->where('id',UID)->update($data);
        $this->success('',$this->l['edit_success']);
    }

    //点数商城
    public function pointShop(){
        $level = Db::table('user')->where('id',UID)->value('level');
        $data['point'] = Db::table('user')->where('id',UID)->value('point');
        $data['shop'] = Db::table('coupon')->where('is_point',1)->where('status',0)->where('level','<=',$level)->get(['id','img','name_'.$this->lang.' as name','price','flag','end_date']);
        if(!empty($data['shop'])){
            $today = date('Y-m-d');
            $data['shop'] = json_decode(json_encode($data['shop']));
            // print_r($data['shop']);
            foreach($data['shop'] as $k=>&$v){
                if($v->flag == 1 && $v->end_date < $today){
                    unset($data['shop'][$k]);
                    continue;
                }
            }
            $data['shop'] = array_values($data['shop']);
        }
        $this->success($data);
    }

    //优惠券详情
    public function coupon(){
        $cou_id = Input::get('cou_id');
        if(empty($cou_id))
            $this->failed($this->l['param_incomplete']);

        $msg = Db::table('coupon')->where('id',$cou_id)->first(['id','name_'.$this->lang.' as name','sub_title_'.$this->lang.' as sub_title','img','flag','term_validity','start_date','end_date','type','discount','price','remark','ids','condition']);
        $ids = explode(',',$msg->ids);
        $n = count($ids);
        if(empty($msg->remark)){
            $msg->remark = '';
        }
        if($n == 1){
            $msg->goods = Db::table('item')->where('item_id',$ids[0])->value('title_'.$this->lang.' as title');
        }else{
            $disc = [];
            foreach($ids as $v){
                $disc[] = Db::table('item')->where('item_id',$v)->value('title_'.$this->lang.' as title');
            }
            $msg->goods = implode(',',$disc);
        }
        $this->success($msg);
    }

    //兑换优惠券
    public function exchange(){
        $cou_id = Input::get('cou_id');
        if(empty($cou_id))
            $this->failed($this->l['param_incomplete']);

        $point = Db::table('user')->where('id',UID)->value('point');
        $coupon = Db::table('coupon')->where('id',$cou_id)->first();

        // 限制兌換
        if($coupon->send_num){
            // 篩選是優惠劵的
            $sendCouponTotal = $userCoupon = Db::table('user_coupon')->where('type', 1)->where('cpid', $cou_id)->count();
            if( $sendCouponTotal >= $coupon->send_num){
                $this->failed($this->l['coupon_full']);
            }
        }

        $today = date('Y-m-d');
        if($coupon->flag == 1 && $coupon->end_date < $today){
            $this->failed($this->l['coupon_expired']);
        }
        if($coupon->price>$point){
            $this->failed($this->l['point_insufficient']);
        }
        //用户点数减
        Db::table('user')->where('id',UID)->decrement('point',$coupon->price);
        //用户优惠券表添加
        $data['uid'] = UID;
        $data['cpid'] = $cou_id;
        $data['title_en'] = $coupon->name_en;
        $data['sub_title_en'] = $coupon->sub_title_en;
        $data['title_tc'] = $coupon->name_tc;
        $data['sub_title_tc'] = $coupon->sub_title_tc;
        $data['flag'] = $coupon->type;
        $data['start_date'] = $coupon->start_date;
        $data['end_date'] = $coupon->end_date;
        $data['discount'] = $coupon->discount;
        $data['ids'] = $coupon->ids;
        $data['img'] = $coupon->img;
        $data['type'] = 1;
        $data['create_time'] = date('Y-m-d H:i:s');
        $data['code'] = rand_str(10);
        $isuc = DB::table('user_coupon')->where(['code'=>$data['code']])->first();
        while(!empty($isuc)){//验证优惠券码不能重复
            $data['code'] = rand_str(10);
            $isuc = DB::table('user')->where(['code'=>$data['code']])->first();
        }
        $ucid = Db::table('user_coupon')->insertGetid($data);
        //加积分兑换记录
        $msg1['uid']  = UID;
        $msg1['title_tc'] = '積分兌換';
        $msg1['title_en']  = 'Redemption of points';
        $msg1['flag']  = 1;
        $msg1['type']  = 0;
        $msg1['point']  = $point;
        $msg1['create_time']  = date('Y-m-d H:i:s');
        Db::table('msg')->insert($msg1);
        //加优惠券兑换记录
        $msg1['title_en']  = $coupon->name_en;
        $msg1['title_tc'] = $coupon->name_tc;
        $msg1['type']  = 2;
        Db::table('msg')->insert($msg1);
        //加优惠券到账通知
        $notice['uid'] = UID;
        $notice['title_tc'] = '優惠券到賬通知';
        $notice['title_en']  = 'Notice of coupon receipt';
        $notice['type'] = 3;
        $notice['date'] = date('Y-m-d');
        $notice['flag'] = 2;
        $notice['link'] = $ucid;
        $notice['remark_tc'] = "收到新的優惠券 '".$coupon->name_tc."'";
        $notice['remark_en']  = "Receive a new coupon '".$coupon->name_en."'";
        $notice['create_time'] = date('Y-m-d H:i:s');
        Db::table('notice')->insert($notice);
        //优惠券表发送数量+1，用户优惠券表加一条数据，记录日志表加数据
        // Db::table('coupon')->where('id',$cou_id)->increment('send_num');
        $this->success('',$this->l['add_success']);
    }

    //兑换记录点数明细
    public function pointMsg(){
        $type = Input::get('type') ?? 1;
        if($type  == 1){
            $this->failed($this->l['param_incomplete']);
        }
        $list = Db::table('msg')->where('uid',UID)->where('type',$type)->get(['id','title_'.$this->lang.' as title','remark_'.$this->lang.' as remark','create_time','point','flag']);
        $this->success($list);
    }

    //用户兑换码方案列表
    public function userCoupon(){
        $type = Input::get('type') ?? 0;
        $status = Input::get('status') ?? 0;
        if($type  == 0){
            $this->failed($this->l['param_incomplete']);
        }
        $today = date('Y-m-d H:i:s');
        $table = Db::table('user_coupon')->where('uid',UID)->where('type',$type)->where('status',0)->get();
        if(count($table) != 0){
            foreach($table as $v){
                if($v->end_date < $today){//过期优惠券置为过期
                    Db::table('user_coupon')->where('id',$v->id)->update(['status'=>2]);
                }
            }
        }
        $w['uid'] = UID;
        $w['type'] = $type;
        if($status != -1){
            $w['status'] = $status;
        }
        $list = Db::table('user_coupon')->where($w)->get(['status','cpid','id','img','start_date','end_date','flag','discount','code','title_'.$this->lang.' as title','sub_title_'.$this->lang.' as sub_title']);

        if($type == 1 && $status == 0){
            foreach($list as &$v){
                $table = Db::table('coupon')->where('id',$v->cpid)->where('status', 0);
                $v->price = $table->value('price');
                $v->usage_type = $table->value('usage_type');
            }
        }
        $this->success($list);
    }

    public function ucmsg(){
        $id = Input::get('id') ?? 0;
        if($id  == 0){
            $this->failed($this->l['param_incomplete']);
        }
        $uc = Db::table('user_coupon')->where('id',$id)->first(['cpid','start_date','end_date','img','code','title_'.$this->lang.' as title','sub_title_'.$this->lang.' as sub_title']);

        $table = Db::table('coupon')->where('id',$uc->cpid);
        $remark = $table->value('remark');
        $price = $table->value('price');
        $usage_type = $table->value('usage_type');
        $uc->price = $price;
        $uc->usage_type = $usage_type;
        if(empty($remark)){
            $uc->remark = '';
        }else{
            $uc->remark = $remark;
        }
        $this->success($uc);
    }

    //订阅方案列表
    public function subscribeList(){
        $level = Db::table('user')->where('id', UID)->value('level');
        $list = Db::table('project')->where('status',0)->where('level','<=',$level)->orderBy('create_time','desc')->get(['id','img','title_'.$this->lang.' as title','sub_title_'.$this->lang.' as sub_title','price']);
        $this->success($list);
    }

    //方案详情
    public function subscribeDetail(){
        $su_id = Input::get('su_id') ?? 0;
        $uc_id = Input::get('uc_id') ?? 0;
        if($su_id  == 0){
            $this->failed($this->l['param_incomplete']);
        }
        $list = Db::table('project')->where('id',$su_id)->first(['id','img','title_'.$this->lang.' as title','sub_title_'.$this->lang.' as sub_title','descript_'.$this->lang.' as descript','price','cups','series_'.$this->lang.' as series','condition','start_date','end_date','ids','activity_stime','activity_etime','status']);
        if(empty($list)){
            $this->failed($this->l['parameter_error']);
        }
        if($list->status == 2){
            $this->failed($this->l['plan_expired']);
        }
        $ids = explode(',',$list->ids);
        // print_r($ids);
        if(count($ids) > 0){
            $resu = '';
            foreach($ids as $v){
                $name = Db::table('item')->where('item_id',$v)->value('title_'.$this->lang.' as title');
                $resu .= $name.',';
            }
            $list->goods = rtrim($resu,','); 
        }
        $uc = Db::table('user_coupon')->where('id',$uc_id)->first();
        if(empty($uc)){
            $list->now_cup = 0;
            $list->code = '';
        }else{
            $list->now_cup = $uc->discount;
            $list->code = $uc->code;
        }
        $this->success($list);
    }

    //方案使用记录
    public function projectMsg(){
        $su_id = Input::get('su_id') ?? 0;
        if($su_id  == 0){
            $this->failed($this->l['param_incomplete']);
        }
        $list = Db::table('project_msg')->where('pid',$su_id)->where('uid',UID)->get(['id','type','use_cup','surplus_cup','create_time','title_'.$this->lang.' as title','sname_'.$this->lang.' as sname']);
        $this->success($list);
    }

    //方案购买
    public function projectBuy(){
        $pid = Input::get('pid') ?? 0;
        
        $payment_id = Input::get('payment_id')??'';
        $price = Input::get('price')??0;

        if($pid  == 0){
            $this->failed($this->l['param_incomplete']);
        }
        $project = Db::table('project')->where('id',$pid)->first();
        if(empty($project)){
            $this->failed($this->l['parameter_error']);
        }
        $uc['uid'] = UID;  
        $uc['cpid'] = $project->id;
        $uc['title_tc'] = $project->title_tc;
        $uc['sub_title_tc'] = $project->sub_title_tc;
        $uc['title_en'] = $project->title_en;
        $uc['sub_title_en'] = $project->sub_title_en;
        $uc['img'] = $project->img;
        $uc['start_date'] = $project->start_date;
        $uc['end_date'] = $project->end_date;
        $uc['create_time'] = $uc['update_time'] = date('Y-m-d H:i:s');
        $uc['type'] = 2;
        $uc['flag'] = 3;
        $uc['discount'] = $project->cups;
        $uc['code'] = rand_str(10);
        $isuc = DB::table('user_coupon')->where(['code'=>$uc['code']])->first();
        while(!empty($isuc)){//验证优惠券码不能重复
            $uc['code'] = rand_str(10);
            $isuc = DB::table('user')->where(['code'=>$uc['code']])->first();
        }
        $pid = Db::table('user')->where('id', UID)->value('pid');
        if(!empty($pid) && !empty($project->score)){//有父级id且方案配置赠送点数不为0
            Db::table('user')->where('id',$pid)->increment('point',$project->score);
            $point = Db::table('user')->where('id',$pid)->value('point');
            $info['point'] = $project->score;
            $info['uid'] = $pid;
            $info['create_time'] = date('Y-m-d H:i:s');
            $info['title_tc'] = '下级购买獲得點數';
            $info['title_en'] = 'Buy to receive point';
            $info['type'] = 0;
            $info['flag'] = 0;
            DB::table('msg')->insert($info);
            $notice['uid'] = $pid;
            $notice['create_time'] = date('Y-m-d H:i:s');
            $notice['date'] = date('Y-m-d');
            $notice['flag'] = 7;
            $notice['type'] = 3;
            $notice['title_tc'] = '下级购买獲得點數';
            $notice['remark_tc'] = '獲得'.$project->score.'點，點數餘額'.$point.'點';
            $notice['title_en'] = 'Buy to receive point notification';
            $notice['remark_en'] = 'Get '.$project->score.' points and the balance is '.$point.' points';
            DB::table('notice')->insert($notice);
        }
        
        // 2023-09-18 gc_kevin 存入方案資料表
        $user = Db::table('user')->where('id',UID)->first();
        $projectOrder = [
            'user_id' => UID,
            'phone' => $user->account,
            'project_id' => $project->id,
            'order_no' => 'LJXPO'.date('YmdHis').Str::uuid(),
            'price' => $project->price,
            'payment_id' => $payment_id,
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s'),
        ];
        $projectOrderID = DB::table('project_order')->insertGetid($projectOrder);

        $ucid = Db::table('user_coupon')->insertGetid($uc);
        $pm['pid'] = $project->id;
        $pm['uid'] = UID;
        $pm['type'] = 1;
        $pm['use_cup'] = $project->cups;
        $pm['surplus_cup'] = $project->cups;
        $pm['title_tc'] = '購買獲得杯數';
        $pm['title_en'] = 'buy cups';
        $pm['create_time'] = date('Y-m-d H:i:s');

        DB::table('project_order')->where('id', $projectOrderID)->update(['coupon_id' => $ucid]);

        Db::table('project_msg')->insertGetid($pm);
        $this->success('',$this->l['operation_success']);
    }

    public function isSend(){
        $is = Input::get('is') ?? -1;
        if($is  == -1){
            $this->failed($this->l['param_incomplete']);
        }
        if($is == 0){
            $time = '';
        }else{
            $time = date('Y-m-d H:i:s');
        }
        Db::table('user')->where('id',UID)->update(['issend'=>$is,'btime'=>$time]);
        $this->success('',$this->l['operation_success']);
    }
}
