<?php

/**
 * 店员端订单列表
 */
namespace App\Http\Controllers\Shop;

use App\Http\Controllers\BaseController;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Log;
use App\UserCoupon;
use Illuminate\Http\Request;


class ShopController extends BaseController{
    
    //订单列表
    public function orderList(){
        $status = Input::get('status') ?? -1;
        $w['sid'] = UID;
        if($status == -1){
            $w[] = ['status','>',0];
        }else{
            $w['status'] = $status;
        }
        $list = Db::table('order')->where($w)->orderBy('create_time','desc')->get(['id','uid','num','code', 'coupon','pick_time','finish_time','status','order_mark','phone','create_time','payment_id']);
        foreach($list as $v){
            $data = Db::table('cart_goods')->where('status',$v->id)->get(['title','tag', 'num']);
            $v->cart_goods = $data;
            $v->short_phone = substr($v->phone, -4);
            $v->areacode = Db::table('user')->where('id', $v->uid)->first()->areacode;
            if($v->status == 1){
                if($this->lang == 'tc'){
                    $v->stu_name = '待出餐';
                }else{
                    $v->stu_name = 'to be served';
                }
                $store = Db::table('store')->where('id',UID)->first(['now_order','now_cup']);
                $store->times = $store->now_cup*2;
                $v->store = $store;
            }else if($v->status == 2){
                if($this->lang == 'tc'){
                    $v->stu_name = '待取餐';
                }else{
                    $v->stu_name = 'pending meal';
                }
            }else if($v->status == 3){
                if($this->lang == 'tc'){
                    $v->stu_name = '已完成';
                }else{
                    $v->stu_name = 'completed';
                }
            }else if($v->status == 9){
                if($this->lang == 'tc'){
                    $v->stu_name = '退款';
                }else{
                    $v->stu_name = 'refund';
                }
            }
            // 方案優惠券兌換情況
            $v->projectTitle = '';
            if(!isset($v->payment_id)){
                $v->projectTitle = Db::table('project')->where('id',$v->coupon)->first(['title_'.$this->lang.' as title'])->title;
            }
        }
        $this->success($list);
    }
    
    //立即出餐
    public function shopFinish(){
        $oid = Input::get('oid') ?? 0;
        if($oid == 0){
            $this->failed($this->l['param_incomplete']);
        }
        $order = Db::table('order')->where('id',$oid)->first();
        if(empty($order)){
            $this->failed($this->l['parameter_error']);
        }
        if($order->status != 1){
            $this->failed($this->l['order_error']);
        }
        $data['status'] = 2;
        $data['finish_time'] = date('Y-m-d H:i:s');
        Db::table('order')->where('id',$oid)->update($data);
        $store = Db::table('store')->where('id',UID)->first();
        $up['now_order'] = $store->now_order-1;
        if($up['now_order'] < 0){
            $up['now_order'] = 0;
        }
        $up['now_cup'] = $store->now_cup-$order->num;
        if($up['now_cup'] < 0){
            $up['now_cup'] = 0;
        }
        Db::table('store')->where('id',UID)->update($up);
        $operlog['oid'] = $oid;
        $operlog['oper_id'] = UUID;
        $operlog['status'] = 1;
        $operlog['time'] = date('Y-m-d H:i:s');
        Db::table('operation_log')->insert($operlog);
        $this->success('',$this->l['operation_success']);
    }
    
    //立即核销
    public function userFinish(){
        $oid = Input::get('oid') ?? 0;
        if($oid == 0){
            $this->failed($this->l['param_incomplete']);
        }
        $order = Db::table('order')->where('id',$oid)->first();
        if(empty($order)){
            $this->failed($this->l['parameter_error']);
        }
        if($order->status != 2){
            $this->failed($this->l['meal_not_ready']);//当前餐未准备好
        }
        $data['status'] = 3;
        $data['pick_time'] = date('Y-m-d H:i:s');
        Db::table('order')->where('id',$oid)->update($data);
        $operlog['oid'] = $oid;
        $operlog['oper_id'] = UUID;
        $operlog['status'] = 2;
        $operlog['time'] = date('Y-m-d H:i:s');
        Db::table('operation_log')->insert($operlog);
        $this->success('',$this->l['operation_success']);
    }
    
    //根据核销码获取订单信息
    public function getOrderFromCode(){
        $order_no = Input::get('order_no') ?? 0;
        if(empty($order_no)){
            $this->failed($this->l['param_incomplete']);
        }
        $id = Db::table('order')->where('order_no',$order_no)->value('id');
        if(empty($id)){
            $this->failed($this->l['parameter_error']);
        }
        $data = Db::table('cart_goods')->where('status',$id)->get(['title','tag']);
        $this->success(compact('data','id'));
    }
    
    //根据核销码获取累积点数
    public function getPointFromCode(){
        $code = Input::get('code') ?? 0;
        $point = Input::get('point') ?? 0;
        if(empty($code)||empty($point)){
            $this->failed($this->l['param_incomplete']);
        }
        $user = Db::table('user')->where('code',$code)->first();
        if(empty($user)){
            $this->failed($this->l['parameter_error']);
        }
        Db::table('user')->where('id',$user->id)->increment('point',$point);
        $info['point'] = $point;
        $info['uid'] = $user->id;
        $info['create_time'] = date('Y-m-d H:i:s');
        $info['title_tc'] = '累積獲得點數通知';
        $info['title_en'] = 'Accumulate points notification';
        $info['type'] = 0;
        $info['flag'] = 0;
        DB::table('msg')->insert($info);
        $notice['uid'] = $user->id;
        $notice['create_time'] = date('Y-m-d H:i:s');
        $notice['date'] = date('Y-m-d');
        $notice['flag'] = 7;
        $notice['type'] = 3;
        $upoint = $user->point+$point;
        $notice['title_tc'] = '累積獲得點數通知';
        $notice['remark_tc'] = '獲得'.$point.'點，點數餘額'.$upoint.'點';
        $notice['title_en'] = 'Accumulate points notification';
        $notice['remark_en'] = 'Get '.$point.' points and the balance is '.$upoint.' points';
        DB::table('notice')->insert($notice);
        $this->success('',$this->l['operation_success']);
    }
    
    //核销方案码生成订单
    public function createOrderFromProject(Request $request){
        $code = Input::get('code') ?? 0;
        $cups = Input::get('cups') ?? 0;
        $items = Input::get('items');
        if(empty($code)||empty($cups)){
            $this->failed($this->l['param_incomplete']);
        }
        $user = Db::table('user_coupon')->where('code',$code)->first();
        if($user->status === 9){
            $this->failed($this->l['is_refund']);
        }
        if(empty($user)){
            $this->failed($this->l['parameter_error']);
        }
        if($user->discount < $cups){
            $this->failed($this->l['insufficient_cups']);
        }
        //通知记录
        $notice['uid'] = $user->uid;
        $notice['create_time'] = date('Y-m-d H:i:s');
        $notice['date'] = date('Y-m-d');
        $notice['flag'] = 5;
        $notice['type'] = 3;
        $nowcups = $user->discount-$cups;
        $notice['title_tc'] = '方案使用通知';
        $notice['remark_tc'] = '您的  "'.$user->title_tc.'"剛剛消費了'.$cups.'杯，剩餘'.$nowcups.'杯';
        $notice['title_en'] = 'Scheme Use Notice';
        $notice['remark_en'] = 'Your "'.$user->title_en.'" Just consumed '.$cups.' cups, '.$nowcups.' cups left';
        //杯数记录
        $msg['uid'] = $user->uid;
        $msg['create_time'] = date('Y-m-d H:i:s');
        $msg['pid'] = $user->id;
        $msg['sid'] = UID;
        $store =  Db::table('store')->where('id',UID)->first();
        $msg['sname_en'] = $store->name_en;
        $msg['sname_tc'] = $store->name_tc;
        $msg['title_tc'] = '線上訂單核銷';
        $msg['title_en'] = 'Online order write off';
        $msg['use_cup'] = $cups;
        $msg['surplus_cup'] = $nowcups;
        Db::table('project_msg')->insert($msg);
        //扣除杯数
        Db::table('user_coupon')->where('id',$user->id)->decrement('discount',$cups);
        //添加订单
        $md = date('md');
        $count = Db::table('order')->where('code','like',$md.'%')->count();
        $count++;
        $pickcode = $md.$count;
        $order['uid'] = $user->uid;
        $order['sid'] = UID;
        $order['phone'] = Db::table('user')->where('id',$user->uid)->value('account');
        $order['sname_en'] = $store->name_en;
        $order['sname_tc'] = $store->name_tc;
        $order['money'] = 0;
        $order['price'] = 0;
        $order['status'] = 1;
        $order['num'] = $cups;
        $order['code'] = $pickcode;
        $order['create_time'] = $order['pay_time'] = date('Y-m-d H:i:s');
        $order['order_no'] = 'LJX'.rand(1000,9999).date('YmdHis').rand(1000,9999);
        $order['coupon'] = $user->cpid;
        $id = Db::table('order')->insertGetId($order);
        $notice['link'] = $id;

        // 加入購物車
        foreach ($items as $item) {
            $img = DB::table('item')->where('item_id', $item['gid'])->first()->cover_url;

            $cartGoods = [
                'ucid' => $user->uid,
                'gid' => $item['gid'],
                'img' => $img,
                'title' => $item['title'],
                'num' => $item['num'],
                'status' => $id
            ];
            DB::table('cart_goods')->insert($cartGoods);
        }
        
        DB::table('notice')->insert($notice);
        //编辑店铺最新信息
        Db::table('store')->where('id',UID)->increment('now_order');
        Db::table('store')->where('id',UID)->increment('now_cup',$cups);
        $operlog['oid'] = $id;
        $operlog['oper_id'] = UUID;
        $operlog['status'] = 3;
        $operlog['time'] = date('Y-m-d H:i:s');
        Db::table('operation_log')->insert($operlog);
        Db::table('user')->where('id',$user->uid)->increment('ordersum');
        //添加订单分析日志
        $td['date'] = date('Y-m-d');
        $td['sid'] = UID;
        $any = Db::table('analyze')->where($td)->first();
        if(empty($any)){
            $td['num'] = 1;
            Db::table('analyze')->insert($td);
        }else{
            Db::table('analyze')->where($td)->increment('num');
        }

        $this->success('',$this->l['operation_success']);

    }
    
    //店铺给与用户优惠券
    public function getCouponFromStore(){
        $code = Input::get('code') ?? 0;
        $couid = Input::get('couid') ?? 0;
        if(empty($code)||empty($couid)){
            $this->failed($this->l['param_incomplete']);
        }

        $coupon = Db::table('coupon')->where('id',$couid)->first();

        // 限制兌換
        if($coupon->send_num){
            // 篩選是優惠劵的
            $sendCouponTotal = $userCoupon = Db::table('user_coupon')->where('type', 1)->where('cpid', $couid)->count();
            if( $sendCouponTotal >= $coupon->send_num){
                $this->failed($this->l['coupon_full']);
            }
        }

        //用户优惠券表添加
        if(empty($coupon)){
            $this->failed($this->l['parameter_error']);
        }
        $user = Db::table('user')->where('code',$code)->first();
        $data['uid'] = $user->id;
        $data['cpid'] = $couid;
        $data['title_en'] = $coupon->name_en;
        $data['sub_title_en'] = $coupon->sub_title_en;
        $data['title_tc'] = $coupon->name_tc;
        $data['sub_title_tc'] = $coupon->sub_title_tc;
        $data['flag'] = $coupon->type;
        $data['start_date'] = $coupon->start_date;
        $data['end_date'] = $coupon->end_date;
        $data['discount'] = $coupon->discount;
        $data['ids'] = $coupon->ids;
        $data['img'] = $coupon->img;
        $data['type'] = 1;
        $data['create_time'] = date('Y-m-d H:i:s');
        $data['code'] = rand_str(10);
        $isuc = DB::table('user_coupon')->where(['code'=>$data['code']])->first();
        while(!empty($isuc)){//验证优惠券码不能重复
            $data['code'] = rand_str(10);
            $isuc = DB::table('user')->where(['code'=>$data['code']])->first();
        }
        $ucid = Db::table('user_coupon')->insertGetid($data);
        $msg1['uid']  = $user->id;
        $msg1['flag']  = $couid;
        $msg1['point']  = 0;
        $msg1['create_time']  = date('Y-m-d H:i:s');
        //加优惠券兑换记录
        $msg1['title_en']  = $coupon->name_en;
        $msg1['title_tc']  = $coupon->name_tc;
        $msg1['type']  = 2;
        Db::table('msg')->insert($msg1);
        //加优惠券到账通知
        $notice['uid'] = $user->id;
        $notice['title_tc'] = '優惠券到賬通知';
        $notice['title_en']  = 'Notice of coupon receipt';
        $notice['type'] = 3;
        $notice['date'] = date('Y-m-d');
        $notice['flag'] = 2;
        $notice['remark_tc'] = "收到新的優惠券 '".$coupon->name_tc."'";
        $notice['remark_en']  = "Receive a new coupon '".$coupon->name_en."'";
        $notice['create_time'] = date('Y-m-d H:i:s');
        $notice['link'] = $ucid;
        DB::table('notice')->insert($notice);
        //优惠券表发送数量+1，用户优惠券表加一条数据，记录日志表加数据
        // Db::table('coupon')->where('id',$couid)->increment('send_num');
        $this->success('',$this->l['operation_success']);
    }
   
    //核销优惠码
    public function writeOffCoupon(){
        $code = Input::get('code') ?? 0;
        $user = Db::table('user_coupon')->where('code',$code)->first();
        $storeId = UID;

        if(empty($user)){
            $this->failed($this->l['parameter_error']);
        }
        if($user->status != 0){
            $this->failed($this->l['coupon_error']);//优惠券已过期或已核销
        }

        // $userCoupon = Db::table('user_coupon')->where('status', 1)->where('type',1)->where('cpid',$coupon->id)->count();

        // 擋住優惠券使用
        // $coupon = Db::table('coupon')->where('id',$user->cpid)->first();
        // $use_num = $coupon->send_num;
        // $cou = Db::table('user_coupon')->where('type',1)->where('cpid',$coupon->id)->count();

        // if($cou >= $use_num){
        //     $this->failed($this->l['coupon_limit']);
        // }

        // 優惠券只能在核銷的店家使用
        $writeOffStores = Db::table('coupon')->where('id', $user->cpid)->first()->store_write_off;
        $writeOffStores = json_decode($writeOffStores);

        if (!in_array( $storeId, $writeOffStores )) {
            $this->failed($this->l['coupon_error']);
        }

        $notice['create_time'] = date('Y-m-d H:i:s');
        Db::table('user_coupon')->where('id',$user->id)->update(['status'=>1,'store_id'=>UID,'update_time'=>$notice['create_time']]);
        //通知记录
        $notice['uid'] = $user->uid;
        $notice['date'] = date('Y-m-d');
        $notice['flag'] = 3;
        $notice['type'] = 3;
        $notice['title_tc'] = '優惠券核銷通知';
        $notice['remark_tc'] = '您的  "'.$user->title_tc.'"已使用';
        $notice['title_en'] = 'Notice of coupon verification';
        $notice['remark_en'] = 'Your "'.$user->title_en.'" has been used';
        DB::table('notice')->insert($notice);
        $this->success('',$this->l['operation_success']);
    }

    public function checkProjectList($code)
    {
        $userCoupon = UserCoupon::where('type', 2)->where('code', $code)->first();

        if(!$userCoupon){
            $this->failed($this->l['coupon_error']);
        }

        $goods = $userCoupon->project;

        $goodsIDs = explode(',', $goods->ids);

        $list = Db::table('item')->whereIn('item_id',$goodsIDs)->select(['item_id as id', 'title_'.$this->lang.' as title'])->get();

        $this->success($list);

    }
    
}