<?php

/**
 * 店员
 * author:徐树彬
 * date 2022-12-13
 */
namespace App\Http\Controllers\Shop;

use Illuminate\Support\Facades\Crypt;
use App\Http\Controllers\BaseController;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Log;

class UserController extends BaseController{

    public function clerklogin(){
        $account = Input::get('account');
        $pass = Input::get('pass');
        if(empty($account)||empty($pass))
            $this->failed($this->l['param_incomplete']);
        
        $user = Db::table('clerk')->where('account',$account)->first();
        if(!$user)
            $this->failed($this->l['account_not_exists']);//账户不存在
                
        if($user->status == 1)
            $this->failed($this->l['account_disabled']);//账户被禁用
        
        if($user->sid == 0)
            $this->failed($this->l['login_error']);//账户被禁用
        
        $passmd5 = md5($pass);    
        if($passmd5 != $user->pass)
            $this->failed($this->l['pass_error']);
        
        $token_data = [
            'plat'          => 'shop',
            'uid'       => $user->id,  //账号id
            'expire'        => time()+3600*24*7,   //登陆有效期：7天
        ];
        $token = Crypt::encrypt($token_data);
        $store = Db::table('store')->where('id',$user->sid)->value('name_'.$this->lang);
        $this->success(['code'=>0,'token'=>$token,'name'=>$user->name,'store'=>$store]);
    }

    public function couponList(){
        $UID = strval(UID);
        $coupon = Db::table('coupon')->where('is_point', 2)->where('status',0)->whereJsonContains('store', [$UID])->orderBy('create_time','desc')->get(['id','name_'.$this->lang.' as name','img','start_date','end_date']);
        $this->success($coupon);
    }
}
