<?php

/**
 * 店长 
 * author:徐树彬
 * date 2022-12-20
 */
namespace App\Http\Controllers\Web;

use Illuminate\Support\Facades\Crypt;
use App\Http\Controllers\BaseController;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Log;
use Illuminate\Http\Request;

class UserController extends BaseController{

    public function adminlogin(){
        $account = Input::get('account');
        $pass = Input::get('pass');
        if(empty($account)||empty($pass))
            $this->failed($this->l['param_incomplete']);
        
        $user = Db::table('clerk')->where('account',$account)->where('status',0)->first();

        if(!$user) $this->failed($this->l['account_not_exists']); //账户不存在

        if($user->status == 1) $this->failed($this->l['account_disabled']); //账户被禁用
        
        // if($user->type == 9) $this->failed($this->l['login_error']); //账户被禁用
                
        $passmd5 = md5($pass);    

        if($passmd5 != $user->pass)
            $this->failed($this->l['pass_error']);
        
        $token_data = [
            'plat'          => 'web',
            'uid'       => $user->id,  //账号id
            'expire'        => time()+3600*24*7,   //登陆有效期：7天
        ];
        $token = Crypt::encrypt($token_data);
        $store = Db::table('store')->where('id',$user->sid)->value('name_'.$this->lang);
        if(empty($store)){
            $this->failed($this->l['store_error']);
        }
        $this->success(['code'=>0,'token'=>$token,'name'=>$user->name,'store'=>$store]);
    }

    //订单列表
    public function orderList(){
        $status = Input::get('status') ?? -1;
        $w['sid'] = UID;
        if($status != -1){
            $w['status'] = $status;
        }else{
            $w[] = ['status','>',0];
        }
        $start_date = Input::get('start_date');
        $end_date = Input::get('end_date');
        if(!empty($start_date) && !empty($end_date)){
            $w[] = ['create_time','>',$start_date];
            $w[] = ['create_time','<',$end_date];
        }
        $list = Db::table('order')->where($w)->orderBy('create_time','desc')->get(['id','coupon','num','code','pick_time','pay_time','status','order_mark','phone','payment_id']);

        foreach($list as $v){
            $data = Db::table('cart_goods')->where('status',$v->id)->get(['title','tag','num']);

            if(!$v->payment_id){
                $project = DB::table('project')->find($v->coupon);
                foreach ($data as $good) {
                    $good->tag = $project->{'title_' . $this->lang};
                }
            }

            $v->cart_goods = $data;
            if($this->lang == 'tc'){
                if($v->status == 0){
                    $v->stu_name = '未支付';
                }else if($v->status == 1){
                    $v->stu_name = '待出餐';
                }else if($v->status == 2){
                    $v->stu_name = '待取餐';
                }else if($v->status == 3){
                    $v->stu_name = '已完成';
                }else if($v->status == 9){
                    $v->stu_name = '退款';
                }
            }else{
                if($v->status == 0){
                    $v->stu_name = 'Unpaid';
                }else if($v->status == 1){
                    $v->stu_name = 'waiting for meal';
                }else if($v->status == 2){
                    $v->stu_name = 'pending meal';
                }else if($v->status == 3){
                    $v->stu_name = 'completed';
                }else if($v->status == 9){
                    $v->stu_name = 'refund';
                }
            }
        }
        $this->success($list);
    }
    
    public function editUser(){
        $id = Input::get('id') ?? 0;
        $account = Input::get('account') ?? '';
        $name = Input::get('name') ?? '';
        $pass = Input::get('pass') ?? '';

        $haveUser = Db::table('clerk')->where('account',$account)->first() ? true : false;

        if($haveUser){
            $this->failed($this->l['account_reapet']); // 帳號重複
        }

        if(empty($account)){
            $this->failed($this->l['parameter_error']);
        }
        $data['account'] = $account;
        $data['name'] = $name;
        if(!empty($pass)){
            $data['pass'] = md5($pass);
        }
        $data['type'] = 1;
        $data['sid'] = UID;
        $data['create_time'] = date('Y-m-d H:i:s');
        if($id == 0){
            Log::stack(['daily'])->info("S_swever", $_SERVER);
            Log::stack(['daily'])->info("员工表新增日志", $data);
            Db::table('clerk')->insert($data);
        }else{
            Db::table('clerk')->where('id',$id)->update($data);
        }
        $this->success('',$this->l['operation_success']);
    }
    
    
    public function userList(){
        $w['status'] = 0;
        $w['type'] = 1;
        $w['sid'] = UID;
        $list = Db::table('clerk')->where($w)->get(['id','name','create_time','account']);
        $this->success($list); 
    }
    
    
    public function delUser(){
        $id = Input::get('id') ?? 0;
        Db::table('clerk')->where('id',$id)->update(['status'=>1]);
        $this->success('',$this->l['del_success']);
    }

    public function analyze(){
        $start_date   = Input::get("start_date");
        $end_date   = Input::get("end_date");
        if(!empty($start_date) && !empty($end_date)){
            $w[] = ['date','<',$end_date];
            $w[] = ['date','>',$start_date];
        }
        $list = Db::table('analyze')->where('sid',UID)->get();
        $date = Db::table('analyze')->where('sid',UID)->orderBy('date','asc')->value('date');
        if(empty($date)){
            $this->success([]); 
        }
        if(!empty($start_date) && !empty($end_date)){
            $d = strtotime($start_date);
            $diff = (strtotime($end_date)-strtotime($start_date))/86400;
        }else{
            $today = date('Y-m-d');
            $diff = (strtotime($today)-strtotime($date))/86400;
            $d = strtotime($date);
        }
        $list = $list->groupBy('date')->toArray();
        $resu = [];
        for($i=0;$i<=$diff;$i++){
            $di = date('Y-m-d',$d+$i*86400);
            if(array_key_exists($di,$list)){
                $msg['num'] = $list[$di][0]->num;
                $msg['money'] = $list[$di][0]->money;
            }else{
                $msg['num'] = 0;
                $msg['money'] = 0; 
            }
            $resu[$di] = $msg;
        }
        $this->success($resu); 
    }
    
    public function pushMsg(){
        $title = Input::get('title');
        $type = Input::get('type') ?? 1;
        $content = Input::get('content');
        $data['create_time'] = date('Y-m-d H:i:s');
        $lang = Input::get('lang') ?? 'tc';
        $level = Input::get('level') ?? '0';
        $notice['uid'] = 0;
        $img = Input::get('img');
        $end_time = Input::get('end_time');
        $start_time = Input::get('start_time');
        $data['end_time'] = $end_time;
        $data['img'] = $img;
        $data['start_time'] = $start_time;
        $notice['img'] = $img;
        if($lang == 'tc'){
            $data['title_tc'] = $title;
            $data['content_tc'] = $content;
            $notice['title_tc'] = $title;
        }else{
            $notice['title_en'] = $title;
            $data['title_en'] = $title;
            $data['content_en'] = $content;
        }
        $data['type'] = 1;
        $id = Db::table('arcicle')->insertGetid($data);
        $notice['type'] = $type;
        $notice['date'] = date('Y-m-d');
        $notice['flag'] = 1;
        $notice['link'] = $id;
        $notice['level'] = $level;
        $notice['create_time'] = date('Y-m-d H:i:s');
        Db::table('notice')->insert($notice);
        $this->success('',$this->l['operation_success']);
    }

    public function goodsList(Request $request){
        $params                   = $request->query();
        $params["page"]           = $request->get("page");
        $params["page_nums"]      = $request->get("page_nums");
        $params["lang"]           = $request->get("lang","tc");

        $page       = !empty($params['page'])       ? (int)$params['page']:1;
        $page_nums  = !empty($params['page_nums'])  ? (int)$params['page_nums']:10;
        $offset     = ($page-1) * $page_nums;

        $field = isset($params["field"]) ? $params["field"] : "create_time";
        $sort  = isset($params["sort"]) ? $params["sort"] : "desc";
        $where[] = ["status","=",0];
        $data["lang"] = $params["lang"];

        $count = DB::table('item')->where($where)->count();

        if(empty($count))
            return ["count"=>0,"list"=>[],"lang"=>$params["lang"]];

        $list = DB::table('item')->where($where)->orderby($field,$sort)->offset($offset)->limit($page_nums)
            ->get(["item_id","title_".$params["lang"]." as title","sub_title_".$params["lang"]." as sub_title","cover_url","images","del_price","price","status","desc_".$params["lang"]." as desc","store","recommend","tags","sort","update_time","create_time"])->toArray();

        $down = DB::table('shop_good')->where('sid',UID)->pluck('gid')->toArray();
        if(count($down) > 0){
            foreach($list as &$v){
                if(in_array($v->item_id,$down)){
                    $v->status = 1;
                }
            }
        }

        $data["list"] = $list;
        $data["count"] = $count;
        $this->success($data);
    }

    public function gooduod(){
        $id = Input::get('id');
        $type = Input::get('type') ?? 1;
        $w['sid'] = UID;
        $w['gid'] = $id;
        $msg = DB::table('shop_good')->where($w)->first();
        if($type ==1){
            if(empty($msg)){
                DB::table('shop_good')->insert($w);
            }
        }else if($type ==2){
            if(!empty($msg)){
                DB::table('shop_good')->delete($msg->id);
            }
        }
        $this->success('',$this->l['operation_success']);
    }
}
