<?php
/**
 * Created by PhpStorm.
 * User: lippan
 * Date: 2019/4/15
 * Time: 下午2:24
 */

namespace App\Http\Middleware;
use Closure;
use Illuminate\Contracts\Encryption\DecryptException;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redis;

class CheckAdminToken{

    use \App\Helpers\ApiResponse;
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {

        if("OPTIONS" == $request->method())//过滤掉嗅探请求
            $this->failed("请求方式不合法");

        $htoken = $request->header("token");
        $gtoken = $request->get("token");
        $ptoken = $request->post("token");
        if(empty($htoken) && empty($gtoken) && empty($gtoken))
            $this->failed("请先登录！",3000);
        
        if(!empty($htoken))
            $token = $htoken;  

        if(!empty($gtoken))
            $token = $gtoken;  

        if(!empty($ptoken))
            $token = $ptoken;  

        try
        {
            $params = Crypt::decrypt($token);
        }
        catch(DecryptException $e)//捕获异常信息
        {
            $this->failed($e->getMessage(),3000);
        };
        
        if(!isset($params["uid"]) || empty($params["uid"]))
            $this->failed("用户令牌有误",3000);

        if($params["plat"] != "admin")
            $this->failed("令牌有误",3000);

        //判断是否过期
        if(time() > $params['expire'])
            $this->failed("token已过期！",3000);

        $user = [
            'user_id'       => $params["uid"],
        ];
        
        define("UID", $params["uid"]);//当前商户id
        $request->attributes->add($user);

        return $next($request);
    }

    /**
     * 检测是否使用手机访问
     * @access public
     * @return bool
     */
    public function isMobile()
    {
        if (isset($_SERVER['HTTP_VIA']) && stristr($_SERVER['HTTP_VIA'], "wap")) {
            return true;
        } elseif (isset($_SERVER['HTTP_ACCEPT']) && strpos(strtoupper($_SERVER['HTTP_ACCEPT']), "VND.WAP.WML")) {
            return true;
        } elseif (isset($_SERVER['HTTP_X_WAP_PROFILE']) || isset($_SERVER['HTTP_PROFILE'])) {
            return true;
        } elseif (isset($_SERVER['HTTP_USER_AGENT']) && preg_match('/(blackberry|configuration\/cldc|hp |hp-|htc |htc_|htc-|iemobile|kindle|midp|mmp|motorola|mobile|nokia|opera mini|opera |Googlebot-Mobile|YahooSeeker\/M1A1-R2D2|android|iphone|ipod|mobi|palm|palmos|pocket|portalmmm|ppc;|smartphone|sonyericsson|sqh|spv|symbian|treo|up.browser|up.link|vodafone|windows ce|xda |xda_)/i', $_SERVER['HTTP_USER_AGENT'])) {
            return true;
        } else {
            return false;
        }
    }
}