<?php

namespace App\Listens;

use Workerman\Lib\Timer;

class WorkermanTimers
{

    /**
     * 服务进程启动时
     * @param $businessWorker
     */
    public static function onWorkerStart($businessWorker)
    {
        // 拿到当前进程的id编号.
        $workid = $businessWorker->id;
        // 获取所有定时器任务配置.
        $timedTask = config('timers');
        if (is_array($timedTask)) {
            // 循环检测任务绑定.
            foreach ($timedTask as $key => $value) {
                // 绑定任务进程.
                if ($value['worker_id'] == $workid) {
                    Timer::add($value['time'], $value['func']);
                }
            }
        }

    }

    /**
     * 服务进程结束时
     * @param $client_id
     */
    public static function onClose($client_id)
    {
    }

}
