<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    /**
     * This namespace is applied to your controller routes.
     *
     * In addition, it is set as the URL generator's root namespace.
     *
     * @var string
     */
    protected $namespace = 'App\Http\Controllers';

    /**
     * Define your route model bindings, pattern filters, etc.
     *
     * @return void
     */
    public function boot()
    {
        //

        parent::boot();
    }

    /**
     * Define the routes for the application.
     *
     * @return void
     */
    public function map()
    {
        // 统一处理域名跨域问题
        if (isset($_SERVER['HTTP_ORIGIN'])){
            $url = $_SERVER['HTTP_ORIGIN'];
        }else{
            $url = "*";
        }
        header("Access-Control-Allow-Credentials:true");
        header('Access-Control-Allow-Origin:'.$url);
        header('Access-Control-Allow-Headers: token');

        $this->mapWebRoutes();

        $this->mapAdminRoutes();//平台端路由

        $this->mapShopRoutes();//店铺端路由

        $this->mapCommonRoutes();//公共调用路由
    
    }

    /**
     * Define the "web" routes for the application.
     *
     * These routes all receive session state, CSRF protection, etc.
     *
     * @return void
     */
    protected function mapWebRoutes()
    {
        Route::middleware('web')
             ->namespace($this->namespace)
             ->group(base_path('routes/web.php'));
    }

    //平台端路由
    protected function mapAdminRoutes()
    {
        Route::namespace($this->namespace)
            ->group(base_path('routes/admin.php'));
    }

    //店铺端路由
    protected function mapShopRoutes()
    {
        Route::namespace($this->namespace)
            ->group(base_path('routes/shop.php'));
    }


    //公共调用
    protected function mapCommonRoutes()
    {
        Route::namespace($this->namespace)
            ->group(base_path('routes/common.php'));
    }

}
