<?php

/**
 *  管理员账号资源
 */
namespace App\Repositories\Business\Account;

use App\Repositories\Common\SmsRepository;
use Illuminate\Support\Facades\DB;
use Exception;
use Illuminate\Support\Facades\Hash;
use stdClass;

class AdminRepository
{
    use \App\Helpers\ApiResponse;

    protected $admin;//平台管理员用户表

    public function __construct()
    {
        $this->admin     = config("db_table.admin");
    }


    /**
     * 登陆
     * @param $account
     * @param $password
     * @return object
     */
    public function login($params,$loginType)
    {
        if($loginType == "1")
            $user = $this->normalLogin($params["name"],$params["pass"]);
        if($loginType == "2")
            $user = $this->smsLogin($params["name"],$params["code"]);
            
        return $user;
    }

    /**
     * 注册
     * @param $params
     */
    public function regist($params){

    }

    /**
     * 短信验证码登陆
     * @param  $mobile,$code
     * @return object
     */
    public function smsLogin($mobile,$code)
    {
        $result = Db::table('emailmessage_log')->where('address',$mobile)->orderBy('time','desc')->first();
        if(empty($result))//验证码和手机号码不匹配
            $this->failed("验证码未发送，请重新发送验证码！");

        if(time()-$result->time > 300){//超过五分钟，超时
            $this->failed("该验证码已超时，请重新发送验证码！");
        }

        if($result->code != $code){//验证码错误
            $this->failed("验证码错误，请重新提交验证码！");
        } 
        $user = $this->getAccount($mobile);

        return $user;
    }



    //普通登陆业务(不带权限)
    protected function normalLogin($account,$password)
    {

        $user = $this->getAccount($account);
        if(empty($user))
            $this->failed("账号不存在,请联系管理员");

        //验证密码
        if (!Hash::check($password.$user->salt, $user->pass))
            $this->failed('账号或密码错误');

        return $user;
    }


    /**
     * 获取用户信息
     * @param $account
     * @return mixed
     */
    protected function getAccount($account)
    {
        $where = [
            "tel"    => $account,
            "is"        =>0
        ];

        $user = DB::table('staff')->where($where)->first();

        return $user ? $user:null;
    }


    //携带权限返回
    protected function authLogin($account)
    {
        $where = [
            "a.mobile"    => $account,
        ];

        $user = DB::table($this->user." as a")
            ->leftJoin($this->depart." as b","a.depart_id","=","b.depart_id")
            ->where($where)
            ->first(["a.*","b.level"]);

        if(empty($user))
            $this->failed("账号不存在,请联系管理员");

        return $user;
    }
}