<?php

/**
 *  会员账号资源
 */
namespace App\Repositories\Business\Account;

use App\Libraries\Wx\WxApi;
use App\Repositories\Common\SmsRepository;
use Exception;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class MemberRepository
{
    use \App\Helpers\ApiResponse;
    private $member_user;//普通用户表
    private $wechat_user;//微信用户表

    //初始化需要用到的表名称
    public function __construct()
    {
        $this->member_user      = 'user';
        $this->wechat_user      = config("db_table.wechat_user");
    }

    /**
     * 登陆
     * @param $params
     * @param $loginType
     * @return mixed
     */
    public function login($params,$loginType)
    {
        $user = null;
        $params["flag"] = $params["flag"]??0;
        $params["invitation"] = $params["invitation"]??'';
        if($loginType == "1")
            $user = $this->accountLogin($params["name"],$params["flag"],$params["invitation"]);
        if($loginType == "2")
            $user = $this->smsLogin($params["name"],$params["code"],$params["flag"],$params["invitation"]);
        if($loginType == "wechat")
            $user = $this->wechatLogin($params["code"]);

        return $user;
    }


    /**
     * 注册
     * @param $params
     * @return array
     */
    public function regist($params)
    {
        $user = $this->getAccount($params["name"]);
        if(!empty($user))
            $this->failed("该用户名已经注册了");

        $bycode = [];    
        if(isset($params['code']) && $params['code'] != ''){
            $bycode = $this->getAccountByBindId($params["code"]);
            if(empty($bycode))
                $this->failed("该邀请码已失效，请重新复制链接！");
        }    
        $user = $this->addRegistUser($params,$bycode);

        return $user;
    }


    /**
     * 按绑定信息获取账号
     * @return  mixed
     */
    public function getAccountByBindId($code)
    {
        $where = [
            "code"      => $code,
            "is"        =>0
        ];

        $user = DB::table($this->member_user)->where($where)->first();

        if(!empty($user))
            $user->account_type = "account";

        return $user ? $user:null;
    }


    /**
     * 短信验证码登陆
     * @param  $mobile,$code
     * @return object
     */
    public function smsLogin($mobile,$code,$flag,$incode)
    {
        $result = Db::table('emailmessage_log')->where('address',$mobile)->orderBy('time','desc')->first();
        if(empty($result))//验证码和手机号码不匹配
            $this->failed("验证码未发送，请重新发送验证码！");

        if(time()-$result->time > 300){//超过五分钟，超时
            $this->failed("该验证码已超时，请重新发送验证码！");
        }

        if($result->code != $code){//验证码错误
            $this->failed("验证码错误，请重新提交验证码！");
        } 

        $user = $this->getAccount($mobile);
        if(empty($user)){//第一次登陆，写入数据
            $time = date("Y-m-d H:i:s");
            $salt = rand_str(6);
            $study_no = rand(pow(10,(4-1)), pow(10,4)-1).date('md');
            $user = [
                "name"              => $mobile,
                "nickname"          => '学友_'.$study_no,
                'avatar'            => 'https://kzschool.oss-cn-beijing.aliyuncs.com/3ea6beec64369c2642b92c6726f1epng.png',
                "tel"               => $mobile,
                "salt"              => $salt,
                "code"              => $salt,
                "study_no"          => $study_no,
                "pass"              => Hash::make('123456'.$salt),//手机登录默认密码123456
                "last_login_time"   => $time,
                "last_login_ip"     => $_SERVER["REMOTE_ADDR"],
                "add_time"          => $time
            ];
            $isb = DB::table($this->member_user)->where(['study_no'=>$study_no,'is'=>0])->first();
            while(!empty($isb)){//验证学号不能重复
                $study_no = rand(pow(10,(4-1)), pow(10,4)-1).date('md');
                $user['study_no'] = $study_no;
                $isb = DB::table($this->member_user)->where(['study_no'=>$study_no,'is'=>0])->first();
            }
            $is = DB::table($this->member_user)->where(['code'=>$salt,'is'=>0])->first();
            while(!empty($is)){//验证邀请码不能重复
                $code = rand_str(6);
                $user['code'] = $code;
                $is = DB::table($this->member_user)->where(['code'=>$code,'is'=>0])->first();
            }
            DB::beginTransaction();
            if($flag == 1){//如果有邀请码就写入相关信息
                $bycode = $this->getAccountByBindId($incode);
                if(empty($bycode))
                    $this->failed("该邀请码已失效，请重新复制链接！");

                $user['par_id'] = $bycode->id;
                $user['flag'] = 1;
                $coin = DB::table('set_rules')->where(['type'=>0,'flag'=>1])->value('coins');
                $par['all_coins'] =  $bycode->all_coins+$coin;
                $par['study_coins'] =  $bycode->study_coins+$coin;
                $par['invitation'] = $bycode->invitation+1;
                $up = Db::table($this->member_user)->where('id',$bycode->id)->update($par);//更新上级邀请人信息
                if($up < 1){
                    $this->failed("更新邀请人信息失败，请重试！");
                    DB::rollBack();
                }
                $log['uid'] = $bycode->id;
                $log['type'] = 0;
                $log['from'] = 2;
                $log['remark'] = '邀请新用户获得学币'.$coin.'枚';
                $log['coins'] = $coin;
                $log['add_time'] = date('Y-m-d H:i:s');
                $uc = Db::table('user_coins')->insertGetId($log);
                if($uc < 1){
                    $this->failed("学币信息写入失败，请重试！");
                    DB::rollBack();
                }
            }
            if($flag == 2){//如果有渠道码就写入相关信息
                $bycode = Db::table('channel')->where('code',$incode)->where('is',0)->first();
                if(empty($bycode))
                    $this->failed("该渠道码已失效，请重新复制链接！");

                $user['par_id'] = $bycode->id;
                $user['flag'] = 2;
                $par['relation'] = $bycode->relation+1;
                $up = Db::table('channel')->where('id',$bycode->id)->update($par);//更新上级邀请人信息
                if($up < 1){
                    $this->failed("更新渠道信息失败，请重试！");
                    DB::rollBack();
                }
                $today = date('Y-m-d');
                $cmid = Db::table('channel_msg')->where('chid',$bycode->id)->where('date',$today)->value('id');
                if($cmid != ''){
                    Db::table('channel_msg')->where('id',$cmid)->increment('relation');
                }else{
                    $cm['chid'] = $bycode->id;
                    $cm['date'] = $today;
                    $cm['relation'] = 1;
                    Db::table('channel_msg')->insert($cm);
                }
            }
            
            if($flag == 3){//如果有分销码就写入相关信息
                $bycode = Db::table('user_distribution')->where('c_code',$incode)->where('is',0)->first();
                if(empty($bycode))
                    $this->failed("该分销码已失效，请重新复制链接！");

                $user['par_id'] = $bycode->id;
                $user['flag'] = 3;
                $par['relation'] = $bycode->relation+1;
                $up = Db::table('user_distribution')->where('id',$bycode->id)->update($par);//更新上级邀请人信息
                if($up < 1){
                    $this->failed("更新分销信息失败，请重试！");
                    DB::rollBack();
                }
            }
            $userId = DB::table($this->member_user)->insertGetId($user);
            $user['id'] = $userId;
            if($userId < 1){
                $this->failed("注册人信息写入失败，请重试！");
                DB::rollBack();
            }
            if($flag == 1){
                Db::table('user_coins')->where('id',$uc)->update(['cover_id'=>$userId]);
            }
            DB::commit();
            $user['status'] = 0;
            $user=(Object)$user;
        }
        
        if($flag == 3){
            //插入分销信息
            $bycode = Db::table('user_distribution')->where('c_code',$incode)->where('is',0)->first();
            if(empty($bycode))
                $this->failed("该分销码已失效，请重新复制链接！");

            if($bycode->uid != $user->id){     
                $udl['udid'] = $bycode->id;
                $udl['uid'] = $user->id;
                $udl['cid'] = $bycode->cid;
                $udl['add_time'] = date('Y-m-d H:i:s');
                $udl['commission'] = $bycode->commission;
                $isu = DB::table('user_distribution_log')->insert($udl);
                if(!$isu){
                    $this->failed("插入分销信息失败，请重试！");
                }
            }
        }
        return $user;
    }

    //普通登陆业务(不带权限)
    protected function accountLogin($mobile,$flag,$incode)
    {

        $user = $this->getAccount($mobile);
       
        if(empty($user)){//第一次登陆，写入数据
            $time = date("Y-m-d H:i:s");
            $salt = rand_str(6);
            $study_no = rand(pow(10,(4-1)), pow(10,4)-1).date('md');
            $user = [
                "name"              => $mobile,
                'avatar'            => 'https://kzschool.oss-cn-beijing.aliyuncs.com/3ea6beec64369c2642b92c6726f1epng.png',
                "tel"               => $mobile,
                "salt"              => $salt,
                "code"              => $salt,
                "study_no"          => $study_no,
                "nickname"          => '学友_'.$study_no,
                "pass"              => Hash::make('123456'.$salt),//手机登录默认密码123456
                "last_login_time"   => $time,
                "last_login_ip"     => $_SERVER["REMOTE_ADDR"],
                "add_time"          => $time
            ];
            $isb = DB::table($this->member_user)->where(['study_no'=>$study_no,'is'=>0])->first();
            while(!empty($isb)){//验证学号不能重复
                $study_no = rand(pow(10,(4-1)), pow(10,4)-1).date('md');
                $data['study_no'] = $study_no;
                $isb = DB::table($this->member_user)->where(['study_no'=>$study_no,'is'=>0])->first();
            }
            $is = DB::table($this->member_user)->where(['code'=>$salt,'is'=>0])->first();
            while(!empty($is)){//验证邀请码不能重复
                $code = rand_str(6);
                $user['code'] = $code;
                $is = DB::table($this->member_user)->where(['code'=>$code,'is'=>0])->first();
            }
            DB::beginTransaction();
            if($flag == 1){//如果有邀请码就写入相关信息
                $bycode = $this->getAccountByBindId($incode);
                if(empty($bycode))
                    $this->failed("该邀请码已失效，请重新复制链接！");

                $user['par_id'] = $bycode->id;
                $user['flag'] = 1;
                $coin = DB::table('set_rules')->where(['type'=>0,'flag'=>1])->value('coins');
                $par['all_coins'] =  $bycode->all_coins+$coin;
                $par['study_coins'] =  $bycode->study_coins+$coin;
                $par['invitation'] = $bycode->invitation+1;
                $up = Db::table($this->member_user)->where('id',$bycode->id)->update($par);//更新上级邀请人信息
                if($up < 1){
                    $this->failed("更新邀请人信息失败，请重试！");
                    DB::rollBack();
                }
                $log['uid'] = $bycode->id;
                $log['type'] = 0;
                $log['from'] = 2;
                $log['remark'] = '邀请新用户获得学币'.$coin.'枚';
                $log['coins'] = $coin;
                $log['add_time'] = date('Y-m-d H:i:s');
                $uc = Db::table('user_coins')->insertGetId($log);
                if($uc < 1){
                    $this->failed("学币信息写入失败，请重试！");
                    DB::rollBack();
                }
            }
            if($flag == 2){//如果有渠道码就写入相关信息
                $bycode = Db::table('channel')->where('code',$incode)->first();
                if(empty($bycode))
                    $this->failed("该渠道码已失效，请重新复制链接！");

                $user['par_id'] = $bycode->id;
                $user['flag'] = 2;
                $par['relation'] = $bycode->relation+1;
                $up = Db::table('channel')->where('id',$bycode->id)->update($par);//更新上级邀请人信息
                if($up < 1){
                    $this->failed("更新渠道信息失败，请重试！");
                    DB::rollBack();
                }
                $today = date('Y-m-d');
                $cmid = Db::table('channel_msg')->where('chid',$bycode->id)->where('date',$today)->value('id');
                if($cmid != ''){
                    Db::table('channel_msg')->where('id',$cmid)->increment('relation');
                }else{
                    $cm['chid'] = $bycode->id;
                    $cm['date'] = $today;
                    $cm['relation'] = 1;
                    Db::table('channel_msg')->insert($cm);
                }
            }
            
            if($flag == 3){//如果有分销码就写入相关信息
                $bycode = Db::table('user_distribution')->where('c_code',$incode)->where('is',0)->first();
                if(empty($bycode))
                    $this->failed("该分销码已失效，请重新复制链接！");

                $user['par_id'] = $bycode->id;
                $user['flag'] = 3;
                $par['relation'] = $bycode->relation+1;
                $up = Db::table('user_distribution')->where('id',$bycode->id)->update($par);//更新上级邀请人信息
                if($up < 1){
                    $this->failed("更新分销信息失败，请重试！");
                    DB::rollBack();
                }
            }
            $userId = DB::table($this->member_user)->insertGetId($user);
            $user['id'] = $userId;
            if($userId < 1){
                $this->failed("注册人信息写入失败，请重试！");
                DB::rollBack();
            }
            if($flag == 1){
                Db::table('user_coins')->where('id',$uc)->update(['cover_id'=>$userId]);
            }
            DB::commit();
            $user['status'] = 0;
            $user=(Object)$user;
        }
        
        if($flag == 3){
            //插入分销信息
            $bycode = Db::table('user_distribution')->where('c_code',$incode)->where('is',0)->first();
            if(empty($bycode))
                $this->failed("该分销码已失效，请重新复制链接！");

            if($bycode->uid != $user->id){        
                $udl['udid'] = $bycode->id;
                $udl['uid'] = $user->id;
                $udl['cid'] = $bycode->cid;
                $udl['add_time'] = date('Y-m-d H:i:s');
                $udl['commission'] = $bycode->commission;
                $isu = DB::table('user_distribution_log')->insert($udl);
                if(!$isu){
                    $this->failed("插入分销信息失败，请重试！");
                    DB::rollBack();
                }
            }
        }
        return $user;
    }


    //普通登陆业务(不带权限)
    protected function wechatLogin($code)
    {
        $wechatRepos = new WechatRepository();
        $user = $wechatRepos->login($code);

        return $user;
    }


    /**
     * 获取用户信息
     * @param $account
     * @return mixed
     */
    protected function getAccount($account)
    {
        $where = [
            "name"    => $account,
            "is"        =>0
        ];

        $user = DB::table($this->member_user)->where($where)->first();

        if(!empty($user))
            $user->account_type = "name";

        return $user ? $user:null;
    }


    //添加注册用户
    protected function addRegistUser($params,$bycode)
    {
        //随机产生一个盐
        $time = date("Y-m-d H:i:s");
        $salt = rand_str(6);
        $study_no = rand(pow(10,(4-1)), pow(10,4)-1).date('md');
        $data = [
            "name"              => $params["name"],
            "nikename"          => $params["name"],
            "salt"              => $salt,
            "code"              => $salt,
            "study_no"          => $study_no,
            "pass"              => Hash::make($params['pass'].$salt),
            "last_login_time"   => $time,
            "last_login_ip"     => $_SERVER["REMOTE_ADDR"],
            "add_time"          => $time
        ];
        $is = DB::table($this->member_user)->where(['study_no'=>$study_no,'is'=>0])->first();
        while(!empty($is)){//验证学号不能重复
            $study_no = rand(pow(10,(4-1)), pow(10,4)-1).date('md');
            $data['study_no'] = $study_no;
            $is = DB::table($this->member_user)->where(['study_no'=>$study_no,'is'=>0])->first();
        }
        $isc = DB::table($this->member_user)->where(['code'=>$salt,'is'=>0])->first();
        while(!empty($isc)){//验证邀请码不能重复
            $code = rand_str(6);
            $data['code'] = $code;
            $isc = DB::table($this->member_user)->where(['code'=>$code,'is'=>0])->first();
        }
        DB::beginTransaction();
        if(!empty($bycode)){//如果有邀请码就写入相关信息
            $data['par_id'] = $bycode->id;
            $coin = DB::table('set_rules')->where(['type'=>0,'flag'=>1])->value('coins');
            $par['all_coins'] =  $bycode->all_coins+$coin;
            $par['study_coins'] =  $bycode->study_coins+$coin;
            $par['invitation'] = $bycode->invitation+1;
            $up = Db::table($this->member_user)->where('id',$bycode->id)->update($par);//更新上级邀请人信息
            if($up < 1){
                $this->failed("更新邀请人信息失败，请重试！");
                DB::rollBack();
            }
            $log['uid'] = $bycode->id;
            $log['type'] = 0;
            $log['from'] = 2;
            $log['remark'] = '邀请新用户获得学币'.$coin.'枚';
            $log['coins'] = $coin;
            $log['add_time'] = date('Y-m-d H:i:s');
            $uc = Db::table('user_coins')->insertGetId($log);
            if($uc < 1){
                $this->failed("学币信息写入失败，请重试！");
                DB::rollBack();
            }
        }
        $userId = DB::table($this->member_user)->insertGetId($data);

        $data["user_id"] = $userId;
        if($userId < 1){
            $this->failed("注册人信息写入失败，请重试！");
            DB::rollBack();
        }
        if($flag == 1){
            Db::table('user_coins')->where('id',$uc)->update(['cover_id'=>$userId]);
        }
        DB::commit();
        return $userId > 0 ? $data:null;
    }


}