<?php

/**
 *  商家管理员账号资源
 */
namespace App\Repositories\Business\Account;

use App\Libraries\Crm;
use App\Libraries\Sap\Sap;
use App\Repositories\Common\SmsRepository;
use Illuminate\Support\Facades\DB;
use Exception;
use Illuminate\Support\Facades\Hash;
use stdClass;

class ShopRepository
{
    use \App\Helpers\ApiResponse;

    protected $shop_admin;//店铺管理员用户表

    public function __construct(){
        $this->shop_admin     = config("db_table.shop_admin");
    }


    /**
     * 登陆
     * @param $account
     * @param $password
     * @return object
     */
    public function login($account,$password)
    {
        //普通登陆返回
        $user = $this->normalLogin($account,$password);
        //携带权限返回
        //$user = $this->authLogin($account,$password)

        return $user;
    }


    /**
     * 注册
     * @param $params
     */
    public function regist($params)
    {

    }


    /**
     * 短信验证码登陆
     * @param  $mobile,$code
     * @return object
     */
    public function smsLogin($mobile,$code)
    {
        $smsRepository = new SmsRepository();
        $type = "login";
        $result = $smsRepository->checkSms($mobile,$code,$type);
        if(empty($result))
            $this->failed("验证码不正确");

        $user = $this->getAccount($mobile);

        //如果登陆成功，则废弃掉原验证码
        $smsRepository->setUsed($mobile,$code,$type);

        return $user;
    }



    //普通登陆业务(不带权限)
    protected function normalLogin($account,$password)
    {

        $user = $this->getAccount($account);
        if(empty($user))
            $this->failed("账号不存在,请联系管理员");

        //验证密码
        if (!Hash::check($password, $user->login_password))
            $this->failed('账号或密码错误');

        return $user;
    }


    /**
     * 获取用户信息
     * @param $account
     * @return mixed
     */
    protected function getAccount($account)
    {
        $where = [
            "login_account"    => $account,
        ];

        $user = DB::table($this->shop_admin)->where($where)->first();

        return $user ? $user:null;
    }


    //携带权限返回
    protected function authLogin($account)
    {
        $where = [
            "a.mobile"    => $account,
        ];

        $user = DB::table($this->user." as a")
            ->leftJoin($this->depart." as b","a.depart_id","=","b.depart_id")
            ->where($where)
            ->first(["a.*","b.level"]);

        if(empty($user))
            $this->failed("账号不存在,请联系管理员");

        return $user;
    }
}