<?php

/**
 * 导出资源
 */
namespace App\Repositories\Business;

class ExportRepository
{
    use \App\Helpers\ApiResponse;

    public function __construct(){

    }


    //客户列表
    public function export($data,$sheet_title,$prefix,$column_num,$first_row_title,$column_name)
    {
        if($column_num > 26)
            $this->failed("列数超过26,请联系管理员");

        require_once app_path().'/Libraries/phpexcel/PHPExcel.php';
        //防止请求超时
        set_time_limit(0);
        $obj = new \PHPExcel();
        // 设置当前sheet
        $obj->setActiveSheetIndex(0);
        // 设置当前sheet的名称
        $obj->getActiveSheet()->setTitle($sheet_title);
        // 文件名和文件类型
        $fileName = $prefix."_".date("Y-m-d-His");
        $fileType = "xlsx";

        // 列标
        $alpArr = config("app.alphabet");

        // 填充第一行数据
        for($i=0;$i<$column_num;$i++)
        {
            $obj->getActiveSheet()->setCellValue($alpArr[$i] .  '1', $first_row_title[$i]);
        }


        // 填充第n(n>=2, n∈N*)行数据
        foreach ($data as $i => $val) {

            for($j=0;$j<$column_num;$j++)
            {
                $obj->getActiveSheet()->setCellValue($alpArr[$j] . ($i + 2), $val->{$column_name[$j]}, \PHPExcel_Cell_DataType::TYPE_STRING);//将其设置为文本格式
            }
        }

        // 导出
        ob_clean();
        if ($fileType == 'xls') {
            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="' . $fileName . '.xls');
            header('Cache-Control: max-age=1');
            $objWriter = new \PHPExcel_Writer_Excel5($obj);
            $objWriter->save('php://output');
            exit;
        } elseif ($fileType == 'xlsx') {
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="' . $fileName . '.xlsx');
            header('Cache-Control: max-age=1');
            $objWriter = \PHPExcel_IOFactory::createWriter($obj, 'Excel2007');
            $objWriter->save('php://output');
            exit;
        }
    }


}