<?php

/**
 * 文章
 */
namespace App\Repositories\Business\Item;

use Illuminate\Support\Facades\DB;

class ArticleRepository
{
    use \App\Helpers\ApiResponse;

    private $table = "arcicle";

    //增加文章
    public function add($params,$lang){
        $data = [
            "title_$lang"           => $params["title"],
            "sub_title_$lang"       => $params["sub_title"],
            "content_$lang"         => $params["content"],
            "img"                   => $params["img"],
            "create_time"           => date("Y-m-d H:i:s")
        ];

        isset($params["start_time"]) && !empty($params["start_time"]) && $data["start_time"] = $params["start_time"];
        isset($params["end_time"]) && !empty($params["end_time"]) && $data["end_time"] = $params["end_time"];

        $itemId = DB::table($this->table)->insertGetId($data);

        return $itemId;
    }

    //删除文章
    public function del($id,$lang){
        $row  = DB::table($this->table)->where("id",$id)->first();
        if(empty($row))
            $this->failed(trans('msg.operate_error',[],$lang));

        $bool = DB::table($this->table)->where("id",$id)->update(["status"=>2]);

        return $bool;
    }

    //修改文章
    public function edit($id,$params,$lang){

        $row  = DB::table($this->table)->where("id",$id)->first();
        if(empty($row))
            $this->failed(trans('msg.operate_error',[],$lang));

        $data = [];

        isset($params["title"]) && !empty($params["title"]) && $data["title_$lang"] = $params["title"];
        isset($params["sub_title"]) && !empty($params["sub_title"]) && $data["sub_title_$lang"] = $params["sub_title"];
        isset($params["content"]) && !empty($params["content"]) && $data["content_$lang"] = $params["content"];
        isset($params["img"]) && !empty($params["img"]) && $data["img"] = $params["img"];

        isset($params["start_time"]) && !empty($params["start_time"]) && $data["start_time"] = $params["start_time"];
        isset($params["end_time"]) && !empty($params["end_time"]) && $data["end_time"] = $params["end_time"];

        if(empty($data))
            return true;

        $bool = DB::table($this->table)->where("id",$id)->update($data);

        return $bool;
    }

    //查询文章
    public function list($params,$needCount = true){
        $page       = !empty($params['page'])       ? (int)$params['page']:1;
        $page_nums  = !empty($params['page_nums'])  ? (int)$params['page_nums']:10;
        $offset     = ($page-1) * $page_nums;

        $field = isset($params["field"]) ? $params["field"]:"create_time";
        $sort  = isset($params["sort"]) ? $params["sort"]:"desc";

        $where[] = ["status","!=",2];
        $where[] = ["type","=",0];
        $data["lang"] = $params["lang"];

        if($needCount)
        {
            $count = DB::table($this->table)
                ->where($where)
                ->count();

            if(empty($count))
                return ["count"=>0,"list"=>[],"lang"=>$params["lang"]];

            $data["count"] = $count;
        }

        $fields = ["id","title_".$params["lang"]." as title","sub_title_".$params["lang"]." as sub_title","content_".$params["lang"]." as content","img","start_time","end_time"];

        $list = DB::table($this->table)
            ->where($where)
            ->orderby($field,$sort)
            ->offset($offset)
            ->limit($page_nums)
            ->get($fields);

        $data["list"] = $list;


        return $data;
    }


    //组合列表
    protected function modifyList($list){
        return $list;
    }
}