<?php

/**
 * banner
 */
namespace App\Repositories\Business\Item;

use Illuminate\Support\Facades\DB;

class BannerRepository
{
    use \App\Helpers\ApiResponse;

    private $table = "banner";

    //增加商品
    public function add($params,$lang){
        $data = [
            "banner"        => $params["banner"],
            "sort"          => isset($params["sort"]) ? $params["sort"]:0,
            "type"          => $params["type"],
            "create_time"   => date("Y-m-d H:i:s")
        ];
        $data["title_".$lang]    = $params["title"];

        if($params["type"] == 1)
            $data["aid"] = $params["aid"];

        isset($params["url"]) && !empty($params["url"]) && $data["url"] = $params["url"];

        $itemId = DB::table($this->table)->insertGetId($data);

        return $itemId;
    }

    //删除商品
    public function del($id,$lang){
        $row  = DB::table($this->table)->where("id",$id)->first();
        if(empty($row))
            $this->failed(trans('msg.operate_error',[],$lang));

        $bool = DB::table($this->table)->where("id",$id)->update(["status"=>2]);

        return $bool;
    }

    //修改商品
    public function edit($id,$params,$lang){

        $row  = DB::table($this->table)->where("id",$id)->first();
        if(empty($row))
            $this->failed(trans('msg.operate_error',[],$lang));

        $data = [];

        $data["title_".$lang]    = $params["title"];
        isset($params["banner"]) && !empty($params["banner"]) && $data["banner"] = $params["banner"];
        isset($params["url"]) && !empty($params["url"]) && $data["url"] = $params["url"];
        isset($params["sort"]) && !empty($params["sort"]) && $data["sort"] = $params["sort"];

        isset($params["type"]) && $data["type"] = $params["type"];

        if($params["type"] == 1)
            $data["aid"] = $params["aid"];

        if(empty($data))
            return true;

        $data["update_time"] = date("Y-m-d H:i:s");

        $bool = DB::table($this->table)->where("id",$id)->update($data);

        return $bool;
    }

    //查询商品
    public function list($params,$needCount = true){
        $page       = !empty($params['page'])       ? (int)$params['page']:1;
        $page_nums  = !empty($params['page_nums'])  ? (int)$params['page_nums']:10;
        $offset     = ($page-1) * $page_nums;

        $field = isset($params["field"]) ? $params["field"]:"create_time";
        $sort  = isset($params["sort"]) ? $params["sort"]:"desc";

        $where[] = ["status","!=",2];
        $where["type"] = $params["type"];
        $data["lang"] = $params["lang"];

        if($needCount)
        {
            $count = DB::table($this->table)
                ->where($where)
                ->count();

            if(empty($count))
                return ["count"=>0,"list"=>[],"lang"=>$params["lang"]];

            $data["count"] = $count;
        }

        $list = DB::table($this->table)
            ->where($where)
            ->orderby($field,$sort)
            ->offset($offset)
            ->limit($page_nums)
            ->get(["*"]);

        $data["list"] = $list;


        return $data;
    }


    //组合列表
    protected function modifyList($list){
        return $list;
    }
}