<?php

/**
 * 分类
 */
namespace App\Repositories\Business\Item;

use Illuminate\Support\Facades\DB;

class CategoryRepository
{
    use \App\Helpers\ApiResponse;

    private $table = "cate";

    //增加分类
    public function add($params,$lang){
        $data = [
            "name_".$lang   => $params["name"],
            "sort"          => isset($params["sort"]) ? $params["sort"]:0,
            "create_time"   => date("Y-m-d H:i:s")
        ];
        $itemId = DB::table($this->table)->insertGetId($data);

        return $itemId;
    }

    //删除分类
    public function del($id,$lang){
        $row  = DB::table($this->table)->where("id",$id)->first();
        if(empty($row))
            $this->failed(trans('msg.operate_error',[],$lang));

        $bool = DB::table($this->table)->where("id",$id)->update(["status"=>2]);

        return $bool;
    }

    //修改分类
    public function edit($id,$params,$lang){

        $row  = DB::table($this->table)->where("id",$id)->first();
        if(empty($row))
            $this->failed(trans('msg.operate_error',[],$lang));

        $data = [];

        isset($params["name"]) && !empty($params["name"]) && $data["name_".$lang] = $params["name"];
        isset($params["sort"]) && !empty($params["sort"]) && $data["sort"] = $params["sort"];

        if(empty($data))
            return true;

        $data["update_time"] = date("Y-m-d H:i:s");

        $bool = DB::table($this->table)->where("id",$id)->update($data);

        return $bool;
    }

    //查询分类
    public function list($params,$needCount = true){
        $page       = !empty($params['page'])       ? (int)$params['page']:1;
        $page_nums  = !empty($params['page_nums'])  ? (int)$params['page_nums']:10;
        $offset     = ($page-1) * $page_nums;

        $field = isset($params["field"]) ? $params["field"]:"create_time";
        $sort  = isset($params["sort"]) ? $params["sort"]:"desc";

        $where[] = ["status","!=",2];
        $data["lang"] = $params["lang"];

        if($needCount)
        {
            $count = DB::table($this->table)
                ->where($where)
                ->count();

            if(empty($count))
                return ["count"=>0,"list"=>[],"lang"=>$params["lang"]];

            $data["count"] = $count;
        }

        $list = DB::table($this->table)
            ->where($where)
            ->orderby($field,$sort)
            ->offset($offset)
            ->limit($page_nums)
            ->get(["name_".$data["lang"]." as name","sort","create_time","status","id"]);

        $data["list"] = $list;


        return $data;
    }


    //组合列表
    protected function modifyList($list){
        return $list;
    }
}