<?php

/**
 * 优惠券
 */
namespace App\Repositories\Business\Item;

use Illuminate\Support\Facades\DB;
use App\Coupon;
use App\UserCoupon;

class CouponRepository
{
    use \App\Helpers\ApiResponse;

    private $table = "coupon";

    //增加优惠券
    public function add($params,$lang){
        $coupon = new Coupon();
        $data = [
            "name_".$lang   => $params["name"],//优惠券名称
            "img"           => $params["img"],
            "ids"           => $params["ids"],
            "send_num"      => $params["send_num"],
            "start_date"    => $params["start_date"],
            "end_date"      => $params["end_date"],
            "discount"      => $params["discount"],
            "price"         => $params["price"],
            "status"        => $params["status"],
            "use_num"       => $params["use_num"]??1,
            "level"         => $params["level"],
            "is_point"      => $params["is_point"],
            "type"          => $params["type"],
            "remark"        => isset($params["remark"]) ? $params["remark"] :'',
            "create_time"   => date("Y-m-d H:i:s")
        ];
        isset($params["type"])  && $data["type"] = $params["type"];
        isset($params["store_ids"]) && !empty($params["store_ids"]) && $data["store_ids"] = $params["store_ids"];
        isset($params["condition"]) && !empty($params["condition"]) && $data["condition"] = $params["condition"];
        isset($params["cate_ids"]) && !empty($params["cate_ids"]) && $data["cate_ids"] = json_encode($params["cate_ids"]);
        isset($params["store"]) && !empty($params["store"]) && $data["store"] = json_encode($params["store"]);
        isset($params["store_write_off"]) && !empty($params["store_write_off"]) && $data["store_write_off"] = json_encode($params["store_write_off"]);
        isset($params["sub_title"]) && !empty($params["sub_title"]) && $data["sub_title_".$lang] = $params["sub_title"];

        if(!empty($params["usage_type"])){
            $data["usage_type"] = $coupon->transUseageCase($params["usage_type"]);
        }else{
            $data["usage_type"] = null;
        }

        $itemId = DB::table($this->table)->insertGetId($data);

        return $itemId;
    }

    //删除优惠券
    public function del($id,$lang){
        $row  = DB::table($this->table)->where("id",$id)->first();
        if(empty($row))
            $this->failed(trans('msg.operate_error',[],$lang));

        $bool = DB::table($this->table)->where("id",$id)->update(["status"=>2]);

        return $bool;
    }

    //修改优惠券
    public function edit($id,$params,$lang){
        $coupon = new Coupon();
        $cid = $id;
        $row  = DB::table($this->table)->where("id",$id)->first();
        if(empty($row))
            $this->failed(trans('msg.operate_error',[],$lang));
        $data = [];

        isset($params["name"]) && !empty($params["name"]) && $data["name_".$lang] = $params["name"];
        isset($params["sub_title"]) && !empty($params["sub_title"]) && $data["sub_title_".$lang] = $params["sub_title"];
        isset($params["img"]) && !empty($params["img"]) && $data["img"] = $params["img"];
        isset($params["ids"]) && !empty($params["ids"]) && $data["ids"] = $params["ids"];
        isset($params["send_num"]) && !empty($params["send_num"]) && $data["send_num"] = $params["send_num"];
        isset($params["start_date"]) && !empty($params["start_date"]) && $data["start_date"] = $params["start_date"];
        isset($params["end_date"]) && !empty($params["end_date"]) && $data["end_date"] = $params["end_date"];
        isset($params["discount"]) && !empty($params["discount"]) && $data["discount"] = $params["discount"];
        isset($params["price"])  && $data["price"] = $params["price"];
        isset($params["type"])  && $data["type"] = $params["type"];
        isset($params["status"])  && $data["status"] = $params["status"];
        isset($params["use_num"])  && $data["use_num"] = $params["use_num"];
        isset($params["level"])  && $data["level"] = $params["level"];
        isset($params["is_point"])  && $data["is_point"] = $params["is_point"];
        isset($params["remark"]) && !empty($params["remark"]) && $data["remark"] = $params["remark"];
        isset($params["store"]) ? $data["store"] = $params["store"] : $data["store"] = null;
        isset($params["store_write_off"]) ? $data["store_write_off"] = $params["store_write_off"] : $data["store_write_off"] = null;
        isset($params["cate_ids"]) ? $data["cate_ids"] = $params["cate_ids"] : $data["cate_ids"] = null;
        isset($params["condition"]) && !empty($params["condition"]) && $data["condition"] = $params["condition"];
        if(!empty($params["usage_type"])){
            $data["usage_type"] = $coupon->transUseageCase($params["usage_type"]);
        }else{
            $data["usage_type"] = null;
        }

        if(empty($data))
            return true;

        $data["update_time"] = date("Y-m-d H:i:s");

        $bool = DB::table($this->table)->where("id",$id)->update($data);

        // DB::table('user_coupon')->where("cid",$cid)->update(['status' => 3])

        return $bool;
    }

    //查询优惠券
    public function list($params,$needCount = true){
        $page       = !empty($params['page'])       ? (int)$params['page']:1;
        $page_nums  = !empty($params['page_nums'])  ? (int)$params['page_nums']:10;
        $offset     = ($page-1) * $page_nums;

        $field = isset($params["field"]) ? $params["field"] : "create_time";
        $sort  = isset($params["sort"]) ? $params["sort"]: "desc";

        $where[] = ["status","!=",2];
        $data["lang"] = $params["lang"];

        if($needCount)
        {
            $count = DB::table($this->table)
                ->where($where)
                ->count();

            if(empty($count))
                return ["count"=>0,"list"=>[],"lang"=>$params["lang"]];

            $data["count"] = $count;
        }

        $list = Coupon::where($where)
                ->orderBy($field, $sort)
                ->select([
                    'id',
                    "name_{$params['lang']} as name",
                    "sub_title_{$params['lang']} as sub_title",
                    'img',
                    'ids',
                    'cate_ids',
                    'send_num',
                    'start_date',
                    'end_date',
                    'status',
                    'discount',
                    'price',
                    'remark',
                    'type',
                    'store',
                    'store_write_off',
                    'condition',
                    'is_point',
                    'use_num',
                    'level',
                    'usage_type'
                ])->offset($offset)
                ->limit($page_nums)
                ->withCount([
                    'userCoupon as total_user_coupons_count',
                    'userCoupon as user_coupons_count' => function ($query) {
                        $query->where('status', 1);
                    }
                ])
                ->get();

        $data["list"] = $list;
        return $data;
    }


    //组合列表
    protected function modifyList($list){
        return $list;
    }
}