<?php

/**
 * 商品sku资源
 */
namespace App\Repositories\Business\Item;

use Illuminate\Support\Facades\DB;

class ItemRepository
{
    use \App\Helpers\ApiResponse;

    private $table = "item";
    private $table_sku      = "sku";
    private $table_prop     = "prop";


    //增加商品 默认中文
    public function add($params,$lang = "tc"){
        $data = [
            "title_".$lang      => $params["title"],
            "sub_title_".$lang  => $params["sub_title"],
            "cat_id"            => $params["cat_id"],
            "cover_url"         => $params["cover_url"],
            "images"            => $params["images"],//todo 此处图片如何处理
            "del_price"         => $params["del_price"],//原价
            "price"             => $params["price"],
            "status"            => $params["status"],//sku状态
            "desc_".$lang       => $params["desc"],
            //"shop_id"         => $params["shop_id"],
            "recommend"         => $params["recommend"],
            "tags"              => $params["tags"],
            "sort"              => $params["sort"],
            "create_time"       => date("Y-m-d H:i:s"),
        ];

        //此处需要添加一个 按商品 可选则的配料列表
        isset($params["mixed_ids"]) && !empty($params["mixed_ids"]) && $data["mixed_ids"] = $params["mixed_ids"];


        $skuRepos = new SkuRepository();
        if(!isset($params["skuList"]) || empty($params["skuList"]))
            $this->failed(trans('msg.skulist_no_exist',[],$lang));
        //商品总库存
        $store    = $skuRepos->getSkuTotalStore($params["skuList"]);
        $data["store"] = $store;

        $itemId = DB::table($this->table)->insertGetId($data);

        $skuRepos   = new SkuRepository();
        $bdata      = $skuRepos->getSkuData($params,$itemId,$lang);
        $bool       = $skuRepos->addBatchSku($bdata);

        return $itemId;
    }

    //删除商品
    public function del($id,$lang){
        $row = DB::table($this->table)->where("item_id",$id)->first();
        if(empty($row))
            $this->failed(trans('msg.operate_error',[],$lang));

        $bool = DB::table("item")->where("item_id",$id)->update(["status"=>2]);

        return $bool;
    }

    //修改商品
    public function edit($id,$params,$lang){

        $row = DB::table($this->table)->where("item_id",$id)->first();
        if(empty($row))
            $this->failed(trans('msg.operate_error',[],$lang));

        //此处校验商品上下架状态 如果为上架状态则需下架才能编辑
        //if($row->status == 0 || $row->status == 2)//上架状态
            //$this->failed(trans('msg.item_no_edit',[],$lang));

        $data = [];
        isset($params["title"])  &&  $data["title_".$lang]      = $params["title"];
        isset($params["sub_title"])  &&  $data["sub_title_".$lang]    = $params["sub_title"];
        isset($params["cat_id"])  &&  $data["cat_id"]           = $params["cat_id"];
        isset($params["cover_url"])  &&  $data["cover_url"]     = $params["cover_url"];
        isset($params["images"])  &&  $data["images"]           = $params["images"];//todo 多图是数组还是拼接字符串
        isset($params["del_price"])  &&  $data["del_price"]     = $params["del_price"];
        isset($params["price"])  &&  $data["price"]             = $params["price"];
        isset($params["status"])  &&  $data["status"]           = $params["status"];
        isset($params["desc"])  &&  $data["desc_".$lang]        = $params["desc"];
        isset($params["recommend"])  &&  $data["recommend"]     = $params["recommend"];
        isset($params["tags"])  &&  $data["tags"]               = $params["tags"];
        isset($params["sort"])  &&  $data["sort"]               = $params["sort"];

        if(empty($params['tags'])){
            $data["tags"] = '';
        }
        //此处需要添加一个 按商品 可选则的配料列表
        isset($params["mixed_ids"]) && $data["mixed_ids"] = $params["mixed_ids"];

        //if(empty($data))//此时若没有修改
            //return true;

        $skuRepos = new SkuRepository();

        //商品总库存
        $store    = $skuRepos->getSkuTotalStore($params["skuList"]);
        $data["store"] = $store;

        //商品sku数据
        $skuData  = $skuRepos->getSkuData($params,$id,$lang);

        try {
            DB::transaction(function () use ($id,$data,$skuData) {
                //先删除原有sku记录
                DB::table($this->table_sku)->where("item_id",$id)->delete();
                //item_sku表   单品为一条记录   多规格为多条记录
                DB::table($this->table_sku)->insert($skuData);
                DB::table($this->table)->where("item_id",$id)->update($data);
            });
        }
        catch (\Illuminate\Database\QueryException $ex)
        {
            $this->failed("编辑商品失败:".$ex->getMessage());
        }


        return true;
    }


    //设置商品状态 上下架
    public function setStatus($id,$status,$lang){
        $row = DB::table($this->table)->where("item_id",$id)->first();
        if(empty($row))
            $this->failed(trans('msg.operate_error',[],$lang));

        $bool = DB::table($this->table)->where("item_id",$id)->update(["status" => $status]);

        return $bool;
    }


    //查询商品
    public function list($params,$needCount = true){
        $page       = !empty($params['page'])       ? (int)$params['page']:1;
        $page_nums  = !empty($params['page_nums'])  ? (int)$params['page_nums']:10;
        $offset     = ($page-1) * $page_nums;

        $cid = isset($params["cid"]) ? $params["cid"] : null;
        $field = isset($params["field"]) ? $params["field"] : "create_time";
        $field = isset($params["field"]) ? $params["field"] : "create_time";
        $sort  = isset($params["sort"]) ? $params["sort"] : "desc";

        $where[] = ["status","!=",2];
        // if(!empty($cid)){
        //     $where[] = ["cat_id","=",$cid];
        // }
        $data["lang"] = $params["lang"];

        if($needCount)
        {
            $count = DB::table($this->table)->where($where);
            if(!empty($cid)){
                $count = $count->whereIn('cat_id',$cid);
            }
            $count = $count->count();

            if(empty($count))
                return ["count"=>0,"list"=>[],"lang"=>$params["lang"]];

            $data["count"] = $count;
        }

        $list = DB::table($this->table)->where($where);
        if(!empty($cid)){
            $list = $list->whereIn('cat_id',$cid);
        }
        $list = $list->orderby($field,$sort)
            ->offset($offset)
            ->limit($page_nums)
            ->get(["item_id","title_".$params["lang"]." as title","sub_title_".$params["lang"]." as sub_title","cat_id","cover_url","images","del_price","price","status","desc_".$params["lang"]." as desc","store","recommend","tags","sort","update_time","create_time","mixed_ids"]);
            foreach ($list as $item) {
                $item->cover_url = asset($item->cover_url);
                $item->images = asset($item->images);
            }
            
        $data["list"] = $list;
       
        return $data;
    }


    //查询商品详情
    public function info($id,$lang){
        $row = DB::table($this->table)->where("item_id",$id)->first();
        if(empty($row))
            $this->failed(trans('msg.operate_error',[],$lang));

        $title      = "title_".$lang;
        $sub_title  = "sub_title_".$lang;
        $desc       = "desc_".$lang;

        $row->title     = $row->$title;
        $row->sub_title = $row->$sub_title;
        $row->desc      = $row->$desc;

        //获取所有sku列表
        $skuRepos = new SkuRepository();
        $skuList  = $skuRepos->list(["item_id" => $id,"lang" => $lang],false);

        $row->skuList = $skuList;
        $row->lang    = $lang;

        return $row;
    }


    //手机端详情
    public function mobileInfo($id,$lang){
        $row = DB::table($this->table)->where("item_id",$id)->first();
        if(empty($row))
            $this->failed(trans('msg.operate_error',[],$lang));

        $title      = "title_".$lang;
        $sub_title  = "sub_title_".$lang;
        $desc       = "desc_".$lang;

        $row->title     = $row->$title;
        $row->sub_title = $row->$sub_title;
        $row->desc      = $row->$desc;

        //此处处理图片
        if(!empty($row->images))
        {
            if(strpos($row->images,",") !== false)
                $row->images = explode(",",$row->images);
            else
                $row->images = [$row->images];
        }


        unset($row->title_en,$row->title_tc,$row->title_cn,$row->sub_title_cn,$row->desc_cn,$row->sub_title_en,$row->sub_title_tc,$row->desc_en,$row->desc_tc);

        //获取所有sku列表
        $skuRepos = new SkuRepository();
        $skuList  = $skuRepos->mobileList(["item_id" => $id,"lang" => $lang],false);

        $row->prop_ids= $skuList["prop_ids"];
        $row->skuList = $skuList["list"];

        return $row;
    }


    //检查skuList
    public function checkSkuList($cat_id,$params){
        //需要选取的规格数量
        $count = DB::table($this->table_prop)->where("cat_id",$cat_id)->where("status",0)->count();
        $flag = true;
        //规格数量不相等
        foreach($params as $value)
        {
            if(count($value["props"]) != $count)//未选择所有的sku规格选项
            {
                $flag = false;
                break;
            }
            //判断一下 价格库存是否为空
            if(empty($value["price"]))
                $this->failed(trans('msg.price_empty',[],$lang="tc"));
            //验证价格格式
            $this->checkMoney($value["price"]);
            //验证原价价格格式
            $this->checkMoney($value["del_price"]);

            if(empty($value["del_price"]))
                $this->failed(trans('msg.del_price_empty',[],$lang="tc"));
            // if(empty($value["store"]))
                // $this->failed(trans('msg.store_empty',[],$lang="tc"));


        }
        return $flag;
    }


    protected function checkMoney($money){
        //验证金额格式
        $price = 100 * $money;  //仍然是浮点型

        if($price <= 0 || strstr($price,'.'))
            $this->failed("金额格式有误");
    }

    //组合列表
    protected function modifyList($list){
        return $list;
    }
}