<?php

/**
 * 配料
 */
namespace App\Repositories\Business\Item;

use Illuminate\Support\Facades\DB;

class MixedRepository
{
    use \App\Helpers\ApiResponse;

    private $table = "mixed";

    //增加配料
    public function add($params,$lang){
        $data = [
            "title_tc"              => $params["title_tc"],
            "title_en"              => $params["title_en"],
            "price"                 => $params["price"],
            "status"                => 0,
            "create_time"           => date("Y-m-d H:i:s")
        ];
        
        $itemId = DB::table($this->table)->insertGetId($data);

        return $itemId;
    }

    //删除配料
    public function del($id,$lang){
        $row  = DB::table($this->table)->where("id",$id)->first();
        if(empty($row))
            $this->failed(trans('msg.operate_error',[],$lang));

        $bool = DB::table($this->table)->where("id",$id)->update(["status"=>2]);

        return $bool;
    }

    //修改配料
    public function edit($id,$params,$lang){

        $row  = DB::table($this->table)->where("id",$id)->first();
        if(empty($row))
            $this->failed(trans('msg.operate_error',[],$lang));

        $data = [];

        isset($params["title"]) && !empty($params["title"]) && $data["title_$lang"] = $params["title"];
        isset($params["price"]) && !empty($params["price"]) && $data["price"] = $params["price"];


        if(empty($data))
            return true;

        $bool = DB::table($this->table)->where("id",$id)->update($data);

        return $bool;
    }

    //查询配料
    public function list($params,$needCount = true){
        $page       = !empty($params['page'])       ? (int)$params['page']:1;
        $page_nums  = !empty($params['page_nums'])  ? (int)$params['page_nums']:10;
        $offset     = ($page-1) * $page_nums;

        $field = isset($params["field"]) ? $params["field"]:"create_time";
        $sort  = isset($params["sort"]) ? $params["sort"]:"desc";

        $where[] = ["status","!=",2];
        $data["lang"] = $params["lang"];

        if($needCount)
        {
            $count = DB::table($this->table)
                ->where($where)
                ->count();

            if(empty($count))
                return ["count"=>0,"list"=>[],"lang"=>$params["lang"]];

            $data["count"] = $count;
        }

        $fields = ["id","title_".$params["lang"]." as title","price","status","create_time"];

        $list = DB::table($this->table)
            ->where($where)
            ->orderby($field,$sort)
            ->offset($offset)
            ->limit($page_nums)
            ->get($fields);

        $data["list"] = $list;


        return $data;
    }


    /**
     * 通过id获取列表
     */
    public function getListByIds($ids,$lang){
        if(empty($ids))
            return null;

        $idArr = [];
        if(strpos($ids,",")!==false)
        {
            $idArr = explode(",",$ids);
        }
        else
        {
            $idArr = [$ids];
        }

        $fields = ["id","title_".$lang." as title","price","status","create_time"];

        $list = DB::table($this->table)
            ->whereIn("id",$idArr)
            ->get($fields);

        return $list;
    }


    //组合列表
    protected function modifyList($list){
        return $list;
    }
}