<?php

/**
 * 方案资源
 */
namespace App\Repositories\Business\Item;

use Illuminate\Support\Facades\DB;

class ProjectRepository
{
    use \App\Helpers\ApiResponse;

    private $table = "project";

    //增加方案
    public function add($params,$lang){
        $data = [
            "title_".$lang         => $params["title"],
            "sub_title_".$lang     => $params["sub_title"],
            "price"         => $params["price"],
            "img"           => $params["img"],
            "cups"          => $params["cups"],
            "ids"           => $params["ids"],
            "level"         => $params["level"],
            "series_".$lang => $params["series"],
            "status"        => $params["status"],
            "create_time"   => date("Y-m-d H:i:s")
        ];

        isset($params["end_date"]) && !empty($params["end_date"]) && $data["end_date"] = $params["end_date"];
        isset($params["condition"]) && !empty($params["condition"]) && $data["condition"] = $params["condition"];
        isset($params["myscore"]) && !empty($params["myscore"]) && $data["myscore"] = $params["myscore"];
        isset($params["start_date"]) && !empty($params["start_date"]) && $data["start_date"] = $params["start_date"];
        isset($params["score"]) && !empty($params["score"]) && $data["score"] = $params["score"];
        isset($params["url"]) && !empty($params["url"]) && $data["url"] = $params["url"];
        isset($params["cate_id"]) && !empty($params["cate_id"]) && $data["cate_id"] = $params["cate_id"];
        isset($params["descript"]) && !empty($params["descript"]) && $data["descript_".$lang] = $params["descript"];
        isset($params["activity_stime"]) && !empty($params["activity_stime"]) && $data["activity_stime"] = $params["activity_stime"];
        isset($params["activity_etime"]) && !empty($params["activity_etime"]) && $data["activity_etime"] = $params["activity_etime"];


        $itemId = DB::table($this->table)->insertGetId($data);

        return $itemId;
    }

    //删除方案
    public function del($id,$lang){
        $row  = DB::table($this->table)->where("id",$id)->first();
        if(empty($row))
            $this->failed(trans('msg.operate_error',[],$lang));

        $bool = DB::table($this->table)->where("id",$id)->update(["status"=>2]);

        return $bool;
    }

    //修改方案
    public function edit($id,$params,$lang){

        $row  = DB::table($this->table)->where("id",$id)->first();
        if(empty($row))
            $this->failed(trans('msg.operate_error',[],$lang));

        $data = [];

        isset($params["title"]) && !empty($params["title"]) && $data["title_".$lang] = $params["title"];
        isset($params["sub_title"]) && !empty($params["sub_title"]) && $data["sub_title_".$lang] = $params["sub_title"];
        isset($params["price"]) && !empty($params["price"]) && $data["price"] = $params["price"];
        isset($params["img"]) && !empty($params["img"]) && $data["img"] = $params["img"];
        isset($params["cups"]) && !empty($params["cups"]) && $data["cups"] = $params["cups"];
        isset($params["ids"]) && !empty($params["ids"]) && $data["ids"] = $params["ids"];
        isset($params["series"]) && !empty($params["series"]) && $data["series_".$lang] = $params["series"];
        isset($params["condition"]) && !empty($params["condition"]) && $data["condition"] = $params["condition"];
        isset($params["start_date"]) && !empty($params["start_date"]) && $data["start_date"] = $params["start_date"];
        isset($params["end_date"]) && !empty($params["end_date"]) && $data["end_date"] = $params["end_date"];
        isset($params["status"]) && $data["status"] = $params["status"];
        isset($params["level"]) && $data["level"] = $params["level"];
        isset($params["score"]) && $data["score"] = $params["score"];
        isset($params["myscore"]) && $data["myscore"] = $params["myscore"];

        isset($params["url"]) && !empty($params["url"]) && $data["url"] = $params["url"];
        isset($params["cate_id"]) && !empty($params["cate_id"]) && $data["cate_id"] = $params["cate_id"];
        isset($params["descript"]) && !empty($params["descript"]) && $data["descript_".$lang] = $params["descript"];
        isset($params["activity_stime"]) && !empty($params["activity_stime"]) && $data["activity_stime"] = $params["activity_stime"];
        isset($params["activity_etime"]) && !empty($params["activity_etime"]) && $data["activity_etime"] = $params["activity_etime"];


        if(empty($data))
            return true;

        $data["update_time"] = date("Y-m-d H:i:s");

        $bool = DB::table($this->table)->where("id",$id)->update($data);

        return $bool;
    }

    //查询方案
    public function list($params,$needCount = true){
        $page       = !empty($params['page'])       ? (int)$params['page']:1;
        $page_nums  = !empty($params['page_nums'])  ? (int)$params['page_nums']:10;
        $offset     = ($page-1) * $page_nums;

        $field = isset($params["field"]) ? $params["field"]:"create_time";
        $sort  = isset($params["sort"]) ? $params["sort"]:"desc";

        $where[] = ["status","!=",2];
        $data["lang"] = $params["lang"];

        if($needCount)
        {
            $count = DB::table($this->table)
                ->where($where)
                ->count();

            if(empty($count))
                return ["count"=>0,"list"=>[],"lang"=>$params["lang"]];

            $data["count"] = $count;
        }

        $list = DB::table($this->table)
            ->where($where)
            ->orderby($field,$sort)
            ->offset($offset)
            ->limit($page_nums)
            ->get(["id","title_".$params["lang"]." as title","sub_title_".$params["lang"]." as sub_title","price","img","cups","ids","series_".$params["lang"]." as series","condition","start_date","end_date","status","descript_".$params["lang"]." as descript","url","cate_id","activity_stime","activity_etime","level",'score','myscore']);

        $data["list"] = $list;


        return $data;
    }


    //组合列表
    protected function modifyList($list){
        return $list;
    }
}