<?php

/**
 * 商品属性资源
 */
namespace App\Repositories\Business\Item;

use Illuminate\Support\Facades\DB;

class PropRepository
{
    use \App\Helpers\ApiResponse;

    private $table = "prop";
    private $table_prop_value = "prop_value";

    //增加
    public function add($params,$lang){
        $data = [
            "cat_id"                => $params["cat_id"],
            //"shop_id"             => $params["shop_id"],
            "prop_name_tc"          => $params["prop_name_tc"],
            "prop_name_en"          => $params["prop_name_en"],
            "sort"                  => isset($params["sort"]) ? (int)$params["sort"] : 0,
            "update_time"           => date("Y-m-d H:i:s")
        ];
        isset($params["is_free"]) && !empty($params["is_free"]) && $data["is_free"] = 1;

        $id = DB::table($this->table)->insertGetId($data);

        return $id;
    }

    //删除
    public function del($id,$lang){

        $row = DB::table($this->table)->where("prop_id",$id)->first();
        if(empty($row))
            $this->failed(trans('msg.operate_error',[],$lang));

        $bool = DB::table($this->table)->where("prop_id",$id)->update(["status" => 1]);

        return $bool;
    }

    //修改
    public function edit($id,$params,$lang){

        $row = DB::table($this->table)->where("prop_id",$id)->first();
        if(empty($row))
            $this->failed(trans('msg.operate_error',[],$lang));

        $data = [
            "update_time" => date("Y-m-d H:i:s")
        ];
        isset($params["cat_id"]) && !empty($params["cat_id"]) && $data["cat_id"] = $params["cat_id"];
        isset($params["prop_name"]) && !empty($params["prop_name"]) && $data["prop_name_".$lang] = $params["prop_name"];
        isset($params["sort"]) && !empty($params["sort"]) && $data["sort"] = $params["sort"];
        //isset($params["is_free"]) && !empty($params["is_free"]) && $data["is_free"] = 1; 此属性不能修改

        if(empty($data))
            return true;

        $bool = DB::table($this->table)->where("prop_id",$id)->update($data);

        return $bool;
    }

    //查询
    public function list($params,$needCount = true){
        $page       = !empty($params['page'])       ? (int)$params['page']:1;
        $page_nums  = !empty($params['page_nums'])  ? (int)$params['page_nums']:10;
        $offset     = ($page-1) * $page_nums;

//        $field = $params["field"];
//        $sort  = $params["sort"];

        $where[] = ["status","=",0];

        isset($params["shop_id"]) && !empty($params["shop_id"]) && $where["shop_id"] = $params["shop_id"];
        isset($params["cat_id"]) && !empty($params["cat_id"]) && $where["cat_id"] = $params["cat_id"];
        isset($params["prop_id"]) && !empty($params["prop_id"]) && $where["prop_id"] = $params["prop_id"];

        $data["lang"] = $params["lang"];
        if($needCount)
        {
            $count = DB::table("prop")
                ->where($where)
                ->count();

            if(empty($count))
                return ["count"=>0,"list"=>[],"lang"=>$params["lang"]];

            $data["count"] = $count;
        }

        $list = DB::table("prop")
            ->where($where)
            //->orderby($field,$sort)
            ->offset($offset)
            ->limit($page_nums)
            ->get(["prop_id","cat_id","sort","update_time","is_free","prop_name_".$params["lang"]." as prop_name"]);

        //此处解析不同种类的属性值
        $hasPriceList = [];
        $freeList = [];
        if($list->isNotEmpty())
        {
            foreach($list as $val){
                if($val->is_free){
                    $freeList[] = $val;
                }
                else
                    $hasPriceList[] = $val;
            }
        }

        //var_dump($hasPriceList);exit;
        $data["list"] = $this->modifyList($hasPriceList,$params["lang"]);
        $data["free_list"] = $this->modifyFreeList($freeList,$params["lang"]);//此处单独指出 免费属性与属性值


        return $data;
    }


    //按当前的skuId 来找到所有的 propId 用来展示
    public function mobileList($params,$needCount = true){

        $where = [];

        isset($params["cat_id"]) && !empty($params["cat_id"]) && $where["cat_id"] = $params["cat_id"];
        isset($params["prop_id"]) && !empty($params["prop_id"]) && $where["prop_id"] = $params["prop_id"];

        $list = DB::table("prop")
            ->where($where)
            ->orderBy("prop_id","asc")
            ->get(["prop_id","cat_id","sort","prop_name_".$params["lang"]." as title"]);

        $data["list"] = $this->modifyList($list,$params["lang"]);

        return $data;
    }


    public function propList($params,$needCount = true){
        $where = [];

        isset($params["cat_id"]) && !empty($params["cat_id"]) && $where[] = ["cat_id","=",$params["cat_id"]];
        //isset($params["prop_id"]) && !empty($params["prop_id"]) && $where["prop_id"] = $params["prop_id"];

        $list = DB::table("prop")
            ->where($where)
            ->whereIn("prop_id",$params["prop_ids"])
            ->orderBy("prop_id","asc")
            ->get(["prop_id","cat_id","sort","is_free","prop_name_".$params["lang"]." as title"]);


        //此处解析不同种类的属性值
        $hasPriceList = [];
        $freeList = [];
        if($list->isNotEmpty())
        {
            foreach($list as $val){
                if($val->is_free){
                    $freeList[] = $val;
                }
                else
                    $hasPriceList[] = $val;
            }
        }

        $data["is_singel"] = 0;
        if(empty($hasPriceList))
        {
            $data["list"] = [];
            $data["is_singel"] = 1;
        }
        else
            $data["list"] = $this->modifyList($hasPriceList,$params["lang"]);

        $data["free_list"] = $this->modifyFreeList($freeList,$params["lang"]);//此处单独指出 免费属性与属性值


        return $data;
    }


    //组合列表
    protected function modifyList($list,$lang){

        //查询每个规格的 属性列表
        foreach($list as &$val)
        {
            $nlist = DB::table($this->table_prop_value)
                ->where("prop_id",$val->prop_id)
                ->orderBy("prop_value_id","asc")
                ->orderBy("sort","asc")
                ->get(["prop_id","prop_value_id","image","prop_value_".$lang." as prop_value","sort"]);
            $val->list = $nlist->isEmpty() ? [] : $nlist;
        }

        return $list;
    }


    protected function modifyFreeList($list,$lang){
        //查询每个规格的 属性列表
        foreach($list as &$val)
        {
            $nlist = DB::table($this->table_prop_value)
                ->where("prop_id",$val->prop_id)
                ->orderBy("prop_value_id","asc")
                ->orderBy("sort","asc")
                ->get(["prop_id","prop_value_id","image","prop_value_".$lang." as prop_value","sort"]);
            $val->list = $nlist->isEmpty() ? [] : $nlist;
        }

        return $list;
    }
}