<?php

/**
 * 商品属性值资源
 */
namespace App\Repositories\Business\Item;

use Illuminate\Support\Facades\DB;

class PropValueRepository
{
    use \App\Helpers\ApiResponse;

    private $table = "prop_value";

    //增加（？？此处需要批量处理）
    public function add($params,$lang){
        $data = [
            "prop_id"               => $params["prop_id"],
            "prop_value_tc"         => $params["prop_value_tc"],
            "prop_value_en"         => $params["prop_value_en"],
            "sort"                  => isset($params["sort"]) ? $params["sort"]:0,
        ];

        isset($params["image"]) && !empty($params["image"]) && $data["image"] = $params["image"];

        $id = DB::table($this->table)->insertGetId($data);

        return $id;
    }

    //删除
    public function del($id,$lang){

        $row = DB::table($this->table)->where("prop_value_id",$id)->first();
        if(empty($row))
            $this->failed(trans('msg.operate_error',[],$lang));

        $bool = DB::table($this->table)->where("prop_value_id",$id)->delete();

        return $bool;
    }

    //修改（？？此处需要批量处理）
    public function edit($id,$params,$lang){

        $row = DB::table($this->table)->where("prop_value_id",$id)->first();
        if(empty($row))
            $this->failed(trans('msg.operate_error',[],$lang));

        $data = [];

        isset($params["prop_id"]) && !empty($params["prop_id"]) && $data["prop_id"] = $params["prop_id"];
        isset($params["prop_value"]) && !empty($params["prop_value"]) && $data["prop_value_".$lang] = $params["prop_value"];
        isset($params["sort"]) && !empty($params["sort"]) && $data["sort"] = $params["sort"];
        isset($params["image"]) && !empty($params["image"]) && $data["image"] = $params["image"];

        if(empty($data))
            return true;

        $bool = DB::table($this->table)->where("prop_value_id",$id)->update($data);

        return $bool;
    }

    //查询
    public function list($params,$needCount = true){
        $page       = !empty($params['page'])       ? (int)$params['page']:1;
        $page_nums  = !empty($params['page_nums'])  ? (int)$params['page_nums']:10;
        $offset     = ($page-1) * $page_nums;

//        $field = $params["field"];
//        $sort  = $params["sort"];

        $where = [];

        isset($params["prop_id"]) && !empty($params["prop_id"]) && $where[] = ["prop_id", "=", $params["prop_id"]];

        $data["lang"] = $params["lang"];
        if($needCount)
        {
            $count = DB::table($this->table)
                ->where($where)
                ->count();

            if(empty($count))
                return ["count"=>0,"list"=>[],"lang"=>$params["lang"]];

            $data["count"] = $count;
        }

        $list = DB::table($this->table)
            ->where($where)
            //->orderby($field,$sort)
            ->offset($offset)
            ->limit($page_nums)
            ->get(["prop_value_id","image","prop_id","prop_value_".$params["lang"]." as prop_value","sort"]);

        $data["list"] = $list;


        return $data;
    }


    //组合列表
    protected function modifyList($list){
        return $list;
    }
}