<?php

/**
 * 隐私政策
 */
namespace App\Repositories\Business\Item;

use Illuminate\Support\Facades\DB;

class ProtocolRepository
{
    use \App\Helpers\ApiResponse;

    private $table = "protocol";

    //增加隐私政策
    public function add($params,$lang){
        $data = [
            "use_remark_$lang"             => $params["use_remark"],
            "protocol_desc_$lang"          => $params["protocol_desc"],
            "faq_$lang"                    => $params["faq"],
            "service_$lang"                => $params["service"],
            "app_version"                  => $params["app_version"],
            "app_url"                      => $params["app_url"],
            "app_update_time"              => $params["app_update_time"],
            "create_time"                  => date("Y-m-d H:i:s")
        ];

        $row  = DB::table($this->table)->where("id",">",0)->first();
        if(!empty($row))
            $this->failed(trans('msg.operate_error',[],$lang));

        $itemId = DB::table($this->table)->insertGetId($data);

        return $itemId;
    }

    //删除隐私政策
    public function del($id,$lang){
        $row  = DB::table($this->table)->where("id",$id)->first();
        if(empty($row))
            $this->failed(trans('msg.operate_error',[],$lang));

        $bool = DB::table($this->table)->where("id",$id)->delete();

        return $bool;
    }

    //修改隐私政策
    public function edit($id,$params,$lang){

        $fields = ["use_remark_".$lang." as use_remark","protocol_desc_".$lang." as protocol_desc","faq_".$lang." as faq","service_".$lang." as service","id","create_time","app_version","app_url","app_update_time"];
        $row  = DB::table($this->table)->where("id",$id)->first($fields);
        if(empty($row))
            $this->failed(trans('msg.operate_error',[],$lang));

        $data = [];

        isset($params["is_lian"]) &&  $data["is_lian"] = $params["is_lian"];

        isset($params["use_remark"]) && !empty($params["use_remark"]) && $data["use_remark_".$lang] = $params["use_remark"];
        isset($params["protocol_desc"]) && !empty($params["protocol_desc"]) && $data["protocol_desc_".$lang] = $params["protocol_desc"];
        isset($params["faq"]) && !empty($params["faq"]) && $data["faq_".$lang] = $params["faq"];
        isset($params["service"]) && !empty($params["service"]) && $data["service_".$lang] = $params["service"];


        isset($params["app_version"]) && $data["app_version"] = $params["app_version"];
        isset($params["app_url"]) && $data["app_url"] = $params["app_url"];
        isset($params["app_update_time"]) && $data["app_update_time"] = $params["app_update_time"];


        if(isset($params["use_remark"]) && !empty(isset($params["use_remark"])) && $params["use_remark"] == $row->use_remark)
            return true;

        if(isset($params["protocol_desc"]) && !empty(isset($params["protocol_desc"])) && $params["protocol_desc"] == $row->protocol_desc)
            return true;

        if(isset($params["faq"]) && !empty(isset($params["faq"])) && $params["faq"] == $row->faq)
            return true;

        if(isset($params["service"]) && !empty(isset($params["service"])) && $params["service"] == $row->service)
            return true;

        if(empty($data))
            return true;

        //$data["update_time"] = date("Y-m-d H:i:s");

        $bool = DB::table($this->table)->where("id",$id)->update($data);

        return $bool;
    }


    //查询隐私政策
    public function info($lang){
        $fields = ["use_remark_".$lang." as use_remark","protocol_desc_".$lang." as protocol_desc","faq_".$lang." as faq","service_".$lang." as service","id","create_time","is_lian","app_version","app_url","app_update_time"];
        $row    = DB::table($this->table)->where("id",">",0)->first($fields);

        return $row;
    }

    // 編輯操作手冊
    public function editManual($id,$params,$lang){
        $bool = DB::table($this->table)->where('id', $id)->update([ 'operation_manual_'.$lang => $params['manual'] ]);
        return $bool;
    }

    // 查詢操作手冊
    public function manual($id,$lang){
        return DB::table($this->table)->where('id', $id)->select("operation_manual_{$lang} as operation_manual")->first();
    }


}