<?php

/**
 * 商品资源
 */
namespace App\Repositories\Business\Item;

use Illuminate\Support\Facades\DB;

class SkuRepository
{
    use \App\Helpers\ApiResponse;

    private $table = "sku";
    private $prop  = "prop";
    private $propValue = "prop_value";

    //增加
    public function add($params){
        $data = [
            "item_id"   => $params["item_id"],
            "title"     => $params["title"],
            "price"     => $params["price"],
            "spec_key"  => $params["spec_key"],
            "spec_info" => $params["spec_info"],
            //"status"    => $params["status"],//sku状态
            //"shop_id"   => $params["shop_id"],
            "sku_images"=> $params["sku_images"],//todo 此处图片如何处理
            "cat_id"    => $params["cat_id"],
        ];
        $id = DB::table($this->table)->insertGetId($data);

        return $id;
    }

    //删除
    public function del($id){
        $bool = DB::table("item")->delete($id);

        return $bool;
    }

    //修改
    public function edit($id,$params){
        $data = [
            
        ];
        $bool = DB::table("item")->where("item_id",$id)->update($data);

        return $bool;
    }

    //查询
    public function list($params,$needCount = true){
        $page       = !empty($params['page'])       ? (int)$params['page']:1;
        $page_nums  = !empty($params['page_nums'])  ? (int)$params['page_nums']:10;
        $offset     = ($page-1) * $page_nums;

        $field = isset($params["field"]) ? $params["field"] : "sku_id";
        $sort  = isset($params["sort"]) ? $params["sort"] : "asc";

        $where = [];

        isset($params["item_id"]) && !empty($params["item_id"]) && $where[] = ["item_id","=",$params["item_id"]];

        $data["lang"] = $params["lang"];

        if($needCount)
        {
            $count = DB::table($this->table)
                ->where($where)
                ->count();

            if(empty($count))
                return ["count"=>0,"list"=>[],"lang"=>$params["lang"]];

            $data["count"] = $count;
        }

        $list = DB::table($this->table)
            ->where($where)
            ->orderby($field,$sort)
            ->offset($offset)
            ->limit($page_nums)
            ->get(["*"]);

        $data["list"] = $list;


        return $data;
    }



    //查询
    public function mobileList($params,$needCount = true){
        $page       = !empty($params['page'])       ? (int)$params['page']:1;
        $page_nums  = !empty($params['page_nums'])  ? (int)$params['page_nums']:10;
        $offset     = ($page-1) * $page_nums;

        $field = isset($params["field"]) ? $params["field"] : "sku_id";
        $sort  = isset($params["sort"]) ? $params["sort"] : "asc";

        $where = [];

        isset($params["item_id"]) && !empty($params["item_id"]) && $where[] = ["item_id","=",$params["item_id"]];

        //$data["lang"] = $params["lang"];

        if($needCount)
        {
            $count = DB::table($this->table)
                ->where($where)
                ->count();

            if(empty($count))
                return ["count"=>0,"list"=>[],"lang"=>$params["lang"]];

            $data["count"] = $count;
        }

        $list = DB::table($this->table)
            ->where($where)
            ->orderby($field,$sort)
            ->offset($offset)
            ->limit($page_nums)
            ->get(["sku_id","spec_key","del_price","price","store"]);

        //此处解析一下sku规格属性，并获取历史存在的propId
        $propIds = [];

        foreach($list as &$val){
            $tempList = json_decode($val->spec_key,true);
            foreach($tempList as $temp)
            {
                $val->specs[] =  (int)$temp["prop_value_id"];
                $propIds[] = (int)$temp["prop_id"];
            }
            unset($val->spec_key);
        }


        $data["list"] = $list;
        $data["prop_ids"] = array_unique($propIds);


        return $data;
    }



    //批量添加sku
    public function addBatchSku($params){

        $bool = DB::table($this->table)->insert($params);

        return $bool;
    }



    /**
     * 获取sku数据
     * @param $params
     * @param $itemId
     * @return array
     */
    public function getSkuData($params,$itemId,$lang)
    {
        $sku = [];

        //获取最新的skuId值
        $row = DB::table($this->table)->orderBy("sku_id","desc")->first(['sku_id']);
        $skuId  = isset($row->sku_id) ? $row->sku_id : 1;

        $time = time();

        //商品多规格
        foreach($params["skuList"] as $key=>$val)
        {

//            "skuList": [{
//                    "props":[{
//                        "prop_id": "1",
//                        "prop_value_id":"11"
//                    }, {
//                        "prop_id": "2",
//                        "prop_value_id":"22"
//                    }],
//                    "price":100,
//                    "del_price":200,
//                    "store": 10,
//                },{
//                    "props":[{
//                        "prop_id": "1",
//                        "prop_value_id":"12"
//                    }, {
//                        "prop_id": "2",
//                        "prop_value_id":"22"
//                    }],
//                    "price":100,
//                    "del_price":200,
//                    "store": 10,
//                }
//            ]

            //此处需要拼接 props: [{prop_id : prop_value_id},{prop_id : prop_value_id}]

            $json = json_encode($val["props"],JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE);

            $spec_info = $this->getSkuInfo($val["props"],$lang);
            if(!array_key_exists('store',$val)){
                $val['store'] = 0;
            }
            $sku[] = [
                "sku_id"        => $skuId+$key+1,
                "item_id"       => $itemId,
                //"title"         => $val["title"],
                "store"         => $val['store'],//sku 库存
                "del_price"     => $val['del_price'],//原价
                "price"         => $val['price'],
                //"shop_id"       => $shopId,
                "cat_id"        => $params["cat_id"],
                "spec_key"      => $json, //属性值id
                "spec_desc"     => $spec_info,//属性与属性值 拼接后的名称字符串
                //"status"        => $params["status"], //sku状态
                //"create_time"   => date("Y-m-d H:i:s",$time),
            ];
        }

        return $sku;
    }


    //获取sku库存总和
    public function getSkuTotalStore($skuList){
        $totalStore = 0;
        //商品多规格
        foreach($skuList as $key=>$val)
        {
            if(array_key_exists('store',$val)){
                $totalStore = $totalStore + $val['store'];
            } 
            
        }

        return $totalStore;
    }


    //根据商品id删除sku
    public function delSkuByItemId($id){
        $bool = DB::table($this->table)->where("item_id",$id)->delete();

        return $bool;
    }


    //获取sku详细信息
    protected function getSkuInfo($propArr,$lang)
    {
        if(empty($propArr))
            return;

        $propStr = "";
        foreach($propArr as $key => $val)//按顺序
        {
            if($val["prop_id"] && $val["prop_value_id"])
            {
                $propName    = DB::table($this->prop)->where("prop_id",$val["prop_id"])->value("prop_name_".$lang);
                $propValue   = DB::table($this->propValue)->where("prop_value_id",$val["prop_value_id"])->value("prop_value_".$lang);
                $propStr     = $propStr ? $propStr.";".$propName.":".$propValue : $propName.":".$propValue;
            }
        }

        return $propStr;
    }
}