<?php

/**
 * sso设定
 */
namespace App\Repositories\Business\Item;

use Illuminate\Support\Facades\DB;

class SsoRepository
{
    use \App\Helpers\ApiResponse;

    private $table = "sso";

    //增加
    public function add($params,$lang){
        $data = [
            "link"          => $params["link"],
            "create_time"   => date("Y-m-d H:i:s")
        ];

        $row  = DB::table($this->table)->where("id",">",0)->first();
        if(!empty($row))
            $this->failed(trans('msg.operate_error',[],$lang));

        $itemId = DB::table($this->table)->insertGetId($data);

        return $itemId;
    }

    //删除
    public function del($id,$lang){
        $row  = DB::table($this->table)->where("id",$id)->first();
        if(empty($row))
            $this->failed(trans('msg.operate_error',[],$lang));

        $bool = DB::table($this->table)->where("id",$id)->delete();

        return $bool;
    }

    //修改
    public function edit($id,$params,$lang){

        $row  = DB::table($this->table)->where("id",$id)->first();
        if(empty($row))
            $this->failed(trans('msg.operate_error',[],$lang));

        $data = [];

        isset($params["link"]) && !empty($params["link"]) && $data["link"] = $params["link"];

        if(empty($data))
            return true;

        $data["update_time"] = date("Y-m-d H:i:s");

        $bool = DB::table($this->table)->where("id",$id)->update($data);

        return $bool;
    }

    //查询
    public function info(){
        $row  = DB::table($this->table)->where("id",">",0)->first();
        return $row;
    }
}