<?php

/**
 * 店铺资源
 */
namespace App\Repositories\Business\Item;

use Illuminate\Support\Facades\DB;

class StoreRepository
{
    use \App\Helpers\ApiResponse;

    private $table = "store";
    private $table_shop_admin = "clerk";

    //增加店铺
    public function add($params,$lang){

        $data = [
            "name_".$lang   => $params["name"],
            //"open_start"    => $params["open_start"],
            //"open_end"      => $params["open_end"],
            "open_date_range"=> json_encode($params["open_date_range"]),
            "address"       => $params["address"],
            "phone"         => $params["phone"],
            "latitude"      => $params["latitude"],
            "longitude"     => $params["longitude"],
            "status"        => $params["status"],
            "keyword"        => $params["keyword"],
            "create_time"   => date("Y-m-d H:i:s")
        ];
        $storeId = DB::table($this->table)->insertGetId($data);
        
        //此处附带增加一个 店铺管理员
        $bool = false;
        if(!empty($storeId))
        {
            $data = [
                "name"          => 'store_main_accound',
                "sid"           => $storeId,
                "pass"          => isset($params["password"]) ? md5($params["password"]) : md5(123456),
                "create_time"   => date("Y-m-d H:i:s"),
                "account"       => $params["account"],
                "type"          => 2,//默认为店长
            ];
            $bool = DB::table($this->table_shop_admin)->insert($data);
        }

        return $bool ? $storeId : 0;
    }

    //删除店铺
    public function del($id,$lang){
        $row  = DB::table($this->table)->where("id",$id)->first();
        if(empty($row))
            $this->failed(trans('msg.operate_error',[],$lang));

        $bool = DB::table($this->table)->where("id",$id)->update(["status"=>2]);

        return $bool;
    }

    //修改店铺
    public function edit($id,$params,$lang){
        $row  = DB::table($this->table)->where("id",$id)->first();
        if(empty($row))
            $this->failed(trans('msg.operate_error',[],$lang));

        $data = [];

        isset($params["name"]) && !empty($params["name"]) && $data["name_".$lang] = $params["name"];
        isset($params["open_start"]) && !empty($params["open_start"]) && $data["open_start"] = $params["open_start"];
        isset($params["open_end"]) && !empty($params["open_end"]) && $data["open_end"] = $params["open_end"];
        isset($params["open_date_range"]) && !empty($params["open_date_range"]) && $data["open_date_range"] = $params["open_date_range"];
        isset($params["address"]) && !empty($params["address"]) && $data["address"] = $params["address"];
        isset($params["phone"]) && !empty($params["phone"]) && $data["phone"] = $params["phone"];
        isset($params["latitude"]) && !empty($params["latitude"]) && $data["latitude"] = $params["latitude"];
        isset($params["longitude"]) && !empty($params["longitude"]) && $data["longitude"] = $params["longitude"];
        isset($params["status"]) && $data["status"] = $params["status"];
        isset($params["keyword"]) && !empty($params["keyword"]) && $data["keyword"] = $params["keyword"];
        isset($params["account"]) && !empty($params["account"]) && $_data["account"] = $params["account"];
        isset($params["password"]) && !empty($params["password"]) && $_data["password"] = $params["password"];

        if(empty($data))
            return true;

        $data["update_time"] = date("Y-m-d H:i:s");


        if(isset($_data["password"]) && !empty($_data["password"]))
        {
            $pass = md5($_data["password"]);
            DB::table($this->table_shop_admin)->where("account",$_data["account"])->update([ "pass"=> $pass ]);
        }

        $bool = DB::table($this->table)->where("id",$id)->update($data);

        return $bool;
    }


    //设置状态
    public function setStatus($id,$status,$lang){
        $row = DB::table($this->table)->where("id",$id)->first();
        if(empty($row))
            $this->failed(trans('msg.operate_error',[],$lang));

        $bool = DB::table($this->table)->where("id",$id)->update(["status" => $status]);

        return $bool;
    }


    //查询店铺
    public function list($params,$needCount = true){
        $page       = !empty($params['page'])       ? (int)$params['page']:1;
        $page_nums  = !empty($params['page_nums'])  ? (int)$params['page_nums']:10;
        $offset     = ($page-1) * $page_nums;

        $field = isset($params["field"]) ? $params["field"]:"create_time";
        $sort  = isset($params["sort"]) ? $params["sort"]:"desc";

        $where[] = ["status","!=",2];
        $data["lang"] = $params["lang"];
        if(!empty($params["key"])){
            if($data["lang"] == 'tc'){
                $where[] = ['name_tc','like','%'.$params['key'].'%'];
            }
            if($data["lang"] == 'en'){
                $where[] = ['name_en','like','%'.$params['key'].'%'];
            }
        }
        if($needCount)
        {
            $count = DB::table($this->table)
                ->where($where)
                ->count();

            if(empty($count))
                return ["count"=>0,"list"=>[],"lang"=>$params["lang"]];

            $data["count"] = $count;
        }

        $list = DB::table($this->table)
            ->where($where)
            ->orderby($field,$sort)
            ->offset($offset)
            ->limit($page_nums)
            ->get(["id","name_".$params["lang"]." as name","open_date_range","address","phone","create_time","status","latitude","longitude","keyword"]);


        foreach ($list as $item) {
            $_table = DB::table($this->table_shop_admin)->where('sid', $item->id)->where('type', 2)->first();
            $item->account = $_table->account??'';
        }

        $data["list"] = $list;

        return $data;
    }


    //组合列表
    protected function modifyList($list){
        return $list;
    }
}