<?php

/**
 * 优惠券
 */
namespace App\Repositories\Business\Item;

use Illuminate\Support\Facades\DB;

class UserCouponRepository
{
    use \App\Helpers\ApiResponse;

    private $table = "user_coupon";
    private $table_coupon   = "coupon";
    private $table_user     = "user";


    //发送优惠券(给每个用户发送优惠券)
    public function add($params,$lang,$level){

        //检查一下该优惠券是否有效
        $row  = DB::table($this->table_coupon)->where("id",$params["id"])->where("status",0)->first();

        if(empty($row))
            $this->failed(trans('msg.operate_error',[],$lang));

        //判断是否过期
        if(strtotime($row->end_date) <  time())
            $this->failed(trans('msg.operate_error',[],$lang));

        if($level > 0){
            $list = DB::table($this->table_user)->where("status",0)->where('level',$level)->pluck("id");
        }else{
            $list = DB::table($this->table_user)->where("status",0)->pluck("id");
        }


        if($list->isEmpty())
            return true;

        //判断是否已经全部发放过了
        $count = DB::table($this->table)->whereIn("uid",$list->toArray())->where("cpid",$row->id)->count();

        if($count >= count($list->toArray()))
            $this->failed(trans('msg.has_send',[],$lang));

        $data = [];
        foreach($list as $value)
        {
            $code = rand_str(10);
            $crow = DB::table($this->table)->where("code",$code)->first();
            while(!empty($crow)){
                $code = rand_str(10);
                $crow = DB::table($this->table)->where("code",$code)->first();
            }


            $data[] = [
                "uid"           => $value,
                "cpid"          => $params["id"],
                "img"           => $row->img,
                "start_date"    => $row->start_date,
                "end_date"      => $row->end_date,
                "create_time"   => date("Y-m-d H:i:s"),
                "update_time"   => date("Y-m-d H:i:s"),
                "status"        => 0,
                "type"          => 1,
                "ids"           => $row->ids,
                "discount"      => $row->discount,
                "flag"          => $row->type,
                "title_en"      => $row->name_en,
                "sub_title_en"  => $row->sub_title_en,
                "title_tc"      => $row->name_tc,
                "sub_title_tc"  => $row->sub_title_tc,
                "code"          => $code,
            ];
        }

        $bool = DB::table($this->table)->insertOrIgnore($data);

        return $bool;

    }


}