<?php

/**
 * 登陆资源
 */
namespace App\Repositories\Business;

use App\Repositories\Business\Account\AdminRepository;
use App\Repositories\Business\Account\MemberRepository;
use App\Repositories\Business\Account\ShopRepository;

class LoginRepository
{

    /**
     * 登陆逻辑
     * @param $params
     * @param $loginType   //登录方式
     * @param $loginObject //登陆对象
     * @return mixed
     */
    public function index($params,$loginType,$loginObject = "1")
    {
        $user = null;

        switch($loginObject)
        {
            case "0"://管理后台登陆
                $adminRepos = new AdminRepository();
                $user       = $adminRepos->login($params,$loginType);
                break;
            case "shop"://商家后台登陆
                $shopRepos  = new ShopRepository();
                $user       = $shopRepos->login($params,$loginType);
                break;
            case "1"://用户端登录
                $memberRepos= new MemberRepository();
                $user       = $memberRepos->login($params,$loginType);
                break;
        }

        return $user;
    }
}