<?php

/**
 *  小程序资源
 */
namespace App\Repositories\Business;

use App\Libraries\Wx\MiniProgram;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class MiniRepository
{
    use \App\Helpers\ApiResponse;

    private $template_msg_send_log;//模板消息发送记录表

    //初始化需要用到的表名称
    public function __construct()
    {
        $this->template_msg_send_log = config("db_table.template_msg_send_log");
    }


    /**
     * 发送统一服务消息
     * @param $openid
     * @param $template_id
     * @param $data
     * @param $url
     * @param $error
     * @return  boolean
     */
    public function sendServiceMsg($openid,$template_id,$data,$url,&$error)
    {
        $content = [
            'touser'        => $openid,//小程序openid与公众号openid区分开
            'weapp_template_msg' => [
                'template_id'   => $template_id,
                'page'          => $url,
                'data'          => $data,
            ]
        ];

        try{
            MiniProgram::getInstance()->uniformSend(MiniProgram::getInstance()->accessToken(), $content);
        }catch (\Exception $e){
            Log::info('推送模板消息失败:'.$e->getMessage());
            $error = $e->getMessage();
            return false;
        }

        return true;
    }


    /**
     * 发送订阅消息
     * @param $openid
     * @param $template_id
     * @param $data
     * @param $url
     * @param $error
     * @return  boolean
     */
    public function sendSubscribeMsg($openid,$template_id,$data,$url,&$error)
    {
        $content = [
            'touser'        => $openid,//小程序openid与公众号openid区分开
            'template_id'   => $template_id,
            'page'          => $url,
            'data'          => $data,
        ];
        Log::info('推送订阅消息内容:'.json_encode($content));
        try{
            MiniProgram::getInstance()->subscribeSend(MiniProgram::getInstance()->accessToken(), $content);
        }catch (\Exception $e){
            Log::info('推送订阅消息失败:'.$e->getMessage());
            $error = $e->getMessage();
            return false;
        }

        return true;
    }


    /**
     * 获取小程序令牌
     * @return mixed
     */
    public function getAccessToken($appid=null,$appsecret=null,&$error)
    {
        try {
            $accessToken = MiniProgram::getInstance()->accessToken();
        }
        catch (\Exception $e){
            Log::info('获取小程序token失败:'.$e->getMessage());
            $error = $e->getMessage();
            return false;
        }


        return $accessToken;
    }


    /**
     * 添加发送记录
     * @param $openid
     * @param $template_id
     * @param $json_data
     * @param $type
     * @param $status
     * @param $errorMsg
     * @return bool
     */
    public function addSendLog($openid,$template_id,$json_data,$type="subscribe",$status,$errorMsg="")
    {
        $data = [
            "openid"            => $openid,
            "template_id"       => $template_id,
            "content"           => $json_data,
            "type"              => $type,
            "result"            => $status  ? "success" : "failed",
            "error_msg"         => $errorMsg,
            "create_time"       => date("Y-m-d H:i:s")
        ];
        $bool = DB::table($this->template_msg_send_log)->insert($data);

        return $bool;
    }
}