<?php

/**
 * 登陆资源
 */
namespace App\Repositories\Business;

use App\Repositories\Business\Account\AdminRepository;
use App\Repositories\Business\Account\MemberRepository;
use App\Repositories\Business\Account\ShopRepository;
use Illuminate\Support\Facades\Crypt;

class RegistRepository
{

    /**
     * 注册逻辑
     * @param $params
     * @param $loginObject //注册对象
     * @return mixed
     */
    public function index($params,$loginObject = "member")
    {
        $user = null;

        switch($loginObject)
        {
            case "admin"://管理后台
                $adminRepos = new AdminRepository();
                $user       = $adminRepos->regist($params);
                break;
            case "shop"://商家后台
                $shopRepos  = new ShopRepository();
                $user       = $shopRepos->regist($params);
                break;
            case "member"://用户端
                $memberRepos= new MemberRepository();
                $user       = $memberRepos->regist($params);
                break;
        }

        return $user;
    }

    /**
     * 生成访问令牌
     * @param $user
     * @return array
     */
    public function createToken($user)
    {
        $token_data = [
            "plat"          => "member",
            "user_id"       => $user["user_id"],
            "expire"        => time()+7200
        ];

        $is_bind = $user["bind_id"] > 0 ? 1:0;
        $token = Crypt::encrypt($token_data);

        return ["token"=>$token,"user_name"=>$user["user_name"],"is_bind"=>$is_bind];
    }
}